/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.view;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.widget.TextView;
import com.instabug.library.R;
import com.instabug.library.view.ViewUtils;
import com.instabug.library.view.a;

public class IconView
extends TextView {
    public static final int ANDROID_ACTIONBAR_ICON_SIZE_DP = 24;
    public static final int ANDROID_ACTIONBAR_ICON_SIZE_PADDING_DP = 1;
    private Typeface font;
    @ColorInt
    int backgroundColor = 0;
    float strokeWidth = 0.0f;
    @ColorInt
    int strokeColor = 0;
    Paint paint;

    public IconView(Context context) {
        this(context, null);
    }

    public IconView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IconView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int n;
        if (this.isInEditMode()) {
            return;
        }
        if (this.font == null) {
            this.font = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"font_icons.ttf");
        }
        this.setTypeface(this.font);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.IconView);
        if (!typedArray.hasValue(R.styleable.IconView_android_textSize)) {
            this.setActionBarSize();
        }
        if (!typedArray.hasValue(R.styleable.IconView_android_padding)) {
            this.setActionBarPadding();
        }
        if (!typedArray.hasValue(R.styleable.IconView_android_textColor)) {
            this.setTextColor(com.instabug.library.settings.a.b().j());
        }
        if ((n = typedArray.getInt(R.styleable.IconView_instabug_icon, -1)) != -1) {
            this.setText(a.a(n));
        }
        typedArray.recycle();
        this.paint = new Paint(1);
    }

    private void setActionBarSize() {
        this.setTextSize(1, 24.0f);
    }

    private void setActionBarPadding() {
        int n = ViewUtils.convertDpToPx(this.getContext(), 1.0f);
        this.setPadding(n);
    }

    public void setPadding(int padding) {
        this.setPadding(padding, padding, padding, padding);
    }

    public void setBackgroundColor(@ColorInt int color2) {
        this.backgroundColor = color2;
        this.invalidate();
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.invalidate();
    }

    public void setStrokeColor(@ColorInt int strokeColor) {
        this.strokeColor = strokeColor;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        this.paint.setColor(this.backgroundColor);
        this.paint.setStyle(Paint.Style.FILL);
        canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, Math.min((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f) - this.strokeWidth / 2.0f, this.paint);
        this.paint.setStrokeWidth(this.strokeWidth);
        this.paint.setColor(this.strokeColor);
        this.paint.setStyle(Paint.Style.STROKE);
        canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, Math.min((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f) - this.strokeWidth / 2.0f, this.paint);
        super.onDraw(canvas);
    }
}

