/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.instabug.library.Feature;
import com.instabug.library.internal.storage.AttachmentManager;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.video.InstabugVideoUtils;
import com.instabug.library.internal.video.InternalAutoScreenRecorderHelper;
import com.instabug.library.internal.video.InternalScreenRecordHelper;
import com.instabug.library.internal.video.a.f;
import com.instabug.library.internal.video.a.g;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.d;
import com.instabug.library.util.threading.PoolProvider;
import java.io.File;
import java.io.IOException;

@TargetApi(value=21)
final class a {
    private final Context a;
    private final a b;
    private final File c;
    private Feature.State d;
    private String e;
    private boolean f;
    private boolean g;
    private MediaProjection h;
    private f i;

    a(Context context, a a2, int n, Intent intent) {
        this.a = context;
        this.b = a2;
        this.g = InternalScreenRecordHelper.getInstance().isRecording();
        this.d = SettingsManager.getInstance().getAutoScreenRecordingAudioCapturingState();
        if (this.g) {
            this.c = AttachmentsUtility.getVideoRecordingFramesDirectory(context);
            this.e = AttachmentsUtility.getVideoFile(context).getAbsolutePath();
        } else {
            this.c = AttachmentManager.getAutoScreenRecordingVideosDirectory(context);
            this.e = AttachmentManager.getAutoScreenRecordingFile(context).getAbsolutePath();
        }
        MediaProjectionManager mediaProjectionManager = (MediaProjectionManager)context.getSystemService("media_projection");
        this.h = mediaProjectionManager.getMediaProjection(n, intent);
        g g2 = this.d();
        if (this.g || this.d == Feature.State.ENABLED) {
            com.instabug.library.internal.video.a.a a3 = this.c();
            this.i = new f(g2, a3, this.h, this.e);
        } else {
            this.i = new f(g2, null, this.h, this.e);
        }
        this.f();
    }

    private com.instabug.library.internal.video.a.a c() {
        if (!com.instabug.library.util.d.a()) {
            return null;
        }
        return new com.instabug.library.internal.video.a.a();
    }

    private g d() {
        int[] nArray = this.e();
        Configuration configuration = this.a.getResources().getConfiguration();
        boolean bl = configuration.orientation == 2;
        int n = nArray[bl ? 0 : 1];
        int n2 = nArray[bl ? 1 : 0];
        int n3 = nArray[2];
        return new g(n, n2, n3);
    }

    private int[] e() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)this.a.getSystemService("window");
        windowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
        int n = displayMetrics.widthPixels;
        int n2 = displayMetrics.heightPixels;
        int n3 = displayMetrics.densityDpi;
        return new int[]{n2, n, n3};
    }

    private void f() {
        if (!this.c.exists() && !this.c.mkdirs()) {
            InstabugSDKLogger.d(this, "Unable to create output directory.\nCannot record screen.");
            return;
        }
        this.i.b();
        this.a(true);
        this.b.a();
        if (this.g) {
            InternalScreenRecordHelper.getInstance().startTimerOnRecordingFAB();
        }
        if (this.d == Feature.State.DISABLED) {
            com.instabug.library.util.d.a(this.a);
        } else {
            com.instabug.library.util.d.b(this.a);
        }
        InstabugSDKLogger.i(this, "Screen recording started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(f$a a2) {
        if (!this.f) {
            InstabugSDKLogger.e(this, "Recorder is not running");
            return;
        }
        this.a(false);
        boolean bl = false;
        try {
            this.h.stop();
            if (this.i != null) {
                this.i.a(a2);
            }
            if (this.i != null) {
                this.i.a();
            }
            this.i = null;
            bl = true;
        }
        catch (RuntimeException runtimeException) {
            InstabugSDKLogger.e(this, runtimeException.getMessage());
            this.i.a();
            bl = true;
        }
        finally {
            try {
                this.b.b();
            }
            catch (RuntimeException runtimeException) {
                if (bl) {
                    // empty if block
                }
            }
        }
    }

    synchronized void a(f$a a2) {
        if (this.f) {
            this.b(a2);
        } else {
            this.b.c();
            this.b.d();
        }
    }

    void a() {
        PoolProvider.postIOTask(new Runnable(){

            @Override
            public void run() {
                File file = new File(a.this.e);
                if (!file.exists()) {
                    InstabugSDKLogger.d(this, "Screen recording file doesn't exist - couldn't be deleted");
                    return;
                }
                if (!file.delete()) {
                    InstabugSDKLogger.d(this, "Screen recording file couldn't be deleted");
                }
            }
        });
    }

    public synchronized void b() {
        File file = new File(this.e);
        InstabugSDKLogger.d(this, "Recorded video file size: " + file.length() / 1024L + " KB");
        if (this.g) {
            InternalScreenRecordHelper.getInstance().setAutoScreenRecordingFile(file);
            InternalScreenRecordHelper.getInstance().onRecordingFinished();
        } else {
            InternalAutoScreenRecorderHelper.getInstance().setAutoScreenRecordingFile(file);
        }
        this.b.d();
    }

    synchronized void a(final int n) {
        PoolProvider.postBitmapTask(new Runnable(){

            @Override
            public void run() {
                File file = new File(a.this.e);
                try {
                    File file2 = InstabugVideoUtils.startTrim(file, AttachmentManager.getAutoScreenRecordingFile(a.this.a), n);
                    InstabugSDKLogger.d(this, "Recorded video file size after trim: " + file2.length() / 1024L + " KB");
                    InternalAutoScreenRecorderHelper.getInstance().setAutoScreenRecordingFile(file2);
                }
                catch (IOException | IllegalArgumentException exception) {
                    exception.printStackTrace();
                    InternalAutoScreenRecorderHelper.getInstance().setAutoScreenRecordingFile(file);
                }
                a.this.b.d();
            }
        });
    }

    public synchronized void a(boolean bl) {
        this.f = bl;
    }

    static interface a {
        public void a();

        public void b();

        public void c();

        public void d();
    }
}

