/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.concurrent.atomic.AtomicInteger;

public class SQLiteDatabaseWrapper {
    private AtomicInteger mOpenCounter = new AtomicInteger();
    private SQLiteDatabase database;
    private SQLiteOpenHelper databaseHelper;

    SQLiteDatabaseWrapper(SQLiteOpenHelper helper) {
        this.databaseHelper = helper;
    }

    synchronized void open() {
        if (this.mOpenCounter.incrementAndGet() == 1) {
            this.database = this.databaseHelper.getWritableDatabase();
        }
    }

    public synchronized void close() {
        if (this.mOpenCounter.decrementAndGet() == 0 && this.database.isOpen()) {
            this.database.close();
        }
    }

    public void beginTransaction() {
        this.database.beginTransaction();
    }

    public long insert(String table, String nullColumnHack, ContentValues values) {
        return this.database.insert(table, nullColumnHack, values);
    }

    public synchronized void beginTransactionNonExclusive() {
        this.database.beginTransactionNonExclusive();
    }

    public long insertWithOnConflict(String table, String nullColumnHack, ContentValues values) {
        return this.database.insertWithOnConflict(table, nullColumnHack, values, 4);
    }

    public long insertWithOnConflictReplace(String tableName, String nullColumnHack, ContentValues values) {
        return this.database.insertWithOnConflict(tableName, nullColumnHack, values, 5);
    }

    private void logOpenDatabaseError() {
        InstabugSDKLogger.e(DatabaseManager.class, "Please call open at first");
    }

    public void execSQL(String sql) {
        this.database.execSQL(sql);
    }

    public void setTransactionSuccessful() {
        this.database.setTransactionSuccessful();
    }

    public void endTransaction() {
        this.database.endTransaction();
    }

    public Cursor rawQuery(String sql, String[] selectionArgs) {
        return this.database.rawQuery(sql, selectionArgs);
    }

    public void delete(String table, String whereClause, String[] whereArgs) {
        this.database.delete(table, whereClause, whereArgs);
    }

    public int update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        return this.database.update(table, values, whereClause, whereArgs);
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        return this.database.query(table, columns, selection, selectionArgs, groupBy, having, orderBy);
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        return this.database.query(table, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
    }

    public long queryNumEntries(String tableName) {
        return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.database, (String)tableName);
    }
}

