/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core.eventbus;

import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.subjects.PublishSubject;

public class EventBus<T> {
    private final PublishSubject<T> subject;

    protected EventBus() {
        this(PublishSubject.create());
    }

    protected EventBus(PublishSubject<T> subject) {
        this.subject = subject;
    }

    public <E extends T> void post(E event) {
        try {
            this.subject.onNext(event);
        }
        catch (Throwable throwable) {
            InstabugSDKLogger.e(this, throwable.getMessage(), throwable);
        }
    }

    public Disposable subscribe(Consumer<? super T> consumer) {
        return this.subject.subscribe(consumer, (Consumer)new Consumer<Throwable>(){

            public void a(Throwable throwable) throws Exception {
                InstabugSDKLogger.e(this, throwable.getMessage(), throwable);
            }

            public /* synthetic */ void accept(Object object) throws Exception {
                this.a((Throwable)object);
            }
        });
    }

    public <E extends T> Observable<E> observeEvents(Class<E> eventClass) {
        return this.subject.ofType(eventClass);
    }

    public boolean hasObservers() {
        return this.subject.hasObservers();
    }
}

