/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.support.annotation.NonNull;
import android.util.Log;
import com.instabug.library.settings.SettingsManager;

public final class InstabugSDKLogger {
    private static final String LOG_TAG = "INSTABUG - ";

    private InstabugSDKLogger() {
    }

    public static String logTag(Object instance) {
        String string2 = instance instanceof Class ? ((Class)instance).getSimpleName() : instance.getClass().getSimpleName();
        return LOG_TAG + string2;
    }

    public static void v(@NonNull Object instance, @NonNull String logMessage) {
        if (logMessage == null) {
            return;
        }
        if (SettingsManager.getInstance().isDebugEnabled()) {
            String string2 = InstabugSDKLogger.logTag(instance);
            if (logMessage.length() > 4000) {
                int n = logMessage.length() / 4000;
                Log.v((String)string2, (String)("logMessage length = " + logMessage.length() + " divided to " + (n + 1) + " chunks"));
                for (int j = 0; j <= n; ++j) {
                    int n2 = 4000 * (j + 1);
                    String string3 = n2 >= logMessage.length() ? logMessage.substring(4000 * j) : logMessage.substring(4000 * j, n2);
                    Log.v((String)string2, (String)("chunk " + (j + 1) + " of " + (n + 1) + ":\n" + string3));
                }
            } else {
                Log.v((String)string2, (String)logMessage);
            }
        }
    }

    public static void d(@NonNull Object instance, @NonNull String logMessage) {
        if (logMessage == null) {
            return;
        }
        if (!SettingsManager.getInstance().isDebugEnabled()) {
            return;
        }
        String string2 = InstabugSDKLogger.logTag(instance);
        if (logMessage.length() > 4000) {
            int n = logMessage.length() / 4000;
            Log.d((String)string2, (String)("logMessage length = " + logMessage.length() + " divided to " + (n + 1) + " chunks"));
            for (int j = 0; j <= n; ++j) {
                int n2 = 4000 * (j + 1);
                String string3 = n2 >= logMessage.length() ? logMessage.substring(4000 * j) : logMessage.substring(4000 * j, n2);
                Log.d((String)string2, (String)("chunk " + (j + 1) + " of " + (n + 1) + ":\n" + string3));
            }
        } else {
            Log.d((String)string2, (String)logMessage);
        }
    }

    public static void i(@NonNull Object instance, @NonNull String logMessage) {
        if (logMessage == null) {
            return;
        }
        if (SettingsManager.getInstance().isDebugEnabled()) {
            Log.i((String)InstabugSDKLogger.logTag(instance), (String)logMessage);
        }
    }

    public static void w(@NonNull Object instance, @NonNull String logMessage) {
        if (logMessage == null) {
            return;
        }
        if (!SettingsManager.getInstance().isDebugEnabled()) {
            return;
        }
        Log.w((String)InstabugSDKLogger.logTag(instance), (String)logMessage);
    }

    public static void e(@NonNull Object instance, @NonNull String logMessage) {
        if (logMessage == null) {
            return;
        }
        if (!SettingsManager.getInstance().isDebugEnabled()) {
            return;
        }
        Log.e((String)InstabugSDKLogger.logTag(instance), (String)logMessage);
    }

    public static void e(@NonNull Object instance, @NonNull String logMessage, @NonNull Throwable throwable) {
        if (logMessage == null) {
            return;
        }
        if (SettingsManager.getInstance().isDebugEnabled()) {
            Log.e((String)InstabugSDKLogger.logTag(instance), (String)logMessage, (Throwable)throwable);
        }
    }

    public static void wtf(@NonNull Object instance, @NonNull String logMessage) {
        if (logMessage == null) {
            return;
        }
        if (!SettingsManager.getInstance().isDebugEnabled()) {
            return;
        }
        Log.wtf((String)InstabugSDKLogger.logTag(instance), (String)logMessage);
    }

    public static void wtf(@NonNull Object instance, @NonNull String logMessage, @NonNull Throwable throwable) {
        if (logMessage == null) {
            return;
        }
        if (!SettingsManager.getInstance().isDebugEnabled()) {
            return;
        }
        Log.wtf((String)InstabugSDKLogger.logTag(instance), (String)logMessage, (Throwable)throwable);
    }
}

