/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom.pagerindicator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.instabug.library.R;
import com.instabug.library.view.ViewUtils;

public final class Dot
extends RelativeLayout {
    private static final int DEFAULT_INACTIVE_DIAMETER_DP = 6;
    private static final int DEFAULT_ACTIVE_DIAMETER_DP = 9;
    private static final int DEFAULT_INACTIVE_COLOR = -1;
    private static final int DEFAULT_ACTIVE_COLOR = -1;
    private static final int DEFAULT_TRANSITION_DURATION_MS = 200;
    private static final boolean DEFAULT_INITIALLY_ACTIVE = false;
    private static final String TAG = "DOT";
    private int inactiveDiameterPx;
    private int activeDiameterPx;
    private int inactiveColor;
    private int activeColor;
    private int transitionDurationMs;
    private State state;
    private ShapeDrawable shape;
    private ImageView drawableHolder;
    private AnimatorSet currentAnimator = null;

    public Dot(Context context) {
        super(context);
        this.init(null, 0, 0);
    }

    public Dot(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0, 0);
    }

    public Dot(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public Dot(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs, defStyleAttr, defStyleRes);
    }

    private void init(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.IBDot, defStyleAttr, defStyleRes);
        int n = ViewUtils.convertDpToPx(this.getContext(), 9.0f);
        int n2 = ViewUtils.convertDpToPx(this.getContext(), 6.0f);
        this.inactiveDiameterPx = typedArray.getDimensionPixelSize(R.styleable.IBDot_ibViewPagerInactiveDiameter, n2);
        this.activeDiameterPx = typedArray.getDimensionPixelSize(R.styleable.IBDot_ibViewPagerActiveDiameter, n);
        this.inactiveColor = typedArray.getColor(R.styleable.IBDot_ibViewPagerInactiveColor, -1);
        this.activeColor = typedArray.getColor(R.styleable.IBDot_ibViewPagerActiveColor, -1);
        this.transitionDurationMs = typedArray.getInt(R.styleable.IBDot_ibViewPagerTransitionDuration, 200);
        this.state = typedArray.getBoolean(R.styleable.IBDot_ibViewPagerInitiallyActive, false) ? State.ACTIVE : State.INACTIVE;
        typedArray.recycle();
        this.reflectParametersInView();
    }

    private void reflectParametersInView() {
        this.removeAllViews();
        int n = Math.max(this.inactiveDiameterPx, this.activeDiameterPx);
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n));
        this.setGravity(17);
        int n2 = this.state == State.ACTIVE ? this.activeDiameterPx : this.inactiveDiameterPx;
        int n3 = this.state == State.ACTIVE ? this.activeColor : this.inactiveColor;
        this.shape = new ShapeDrawable((Shape)new OvalShape());
        this.shape.setIntrinsicWidth(n2);
        this.shape.setIntrinsicHeight(n2);
        this.shape.getPaint().setColor(n3);
        this.drawableHolder = new ImageView(this.getContext());
        this.drawableHolder.setImageDrawable(null);
        this.drawableHolder.setImageDrawable((Drawable)this.shape);
        this.addView((View)this.drawableHolder);
    }

    private void animateDotChange(final int startSize, final int endSize, final int startColor, final int endColor, int duration) {
        if (startSize < 0) {
            throw new IllegalArgumentException("startSize cannot be less than 0");
        }
        if (endSize < 0) {
            throw new IllegalArgumentException("endSize cannot be less than 0");
        }
        if (duration < 0) {
            throw new IllegalArgumentException("duration cannot be less than 0");
        }
        if (this.currentAnimator != null) {
            this.currentAnimator.cancel();
        }
        this.currentAnimator = new AnimatorSet();
        this.currentAnimator.setDuration((long)duration);
        this.currentAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                if (Dot.this.state == State.INACTIVE) {
                    Dot.this.state = State.TRANSITIONING_TO_ACTIVE;
                } else if (Dot.this.state == State.ACTIVE) {
                    Dot.this.state = State.TRANSITIONING_TO_INACTIVE;
                }
            }

            public void onAnimationEnd(Animator animation) {
                if (!Dot.this.state.isStable()) {
                    Dot.this.state = Dot.this.state.transitioningTo();
                }
                Dot.this.changeSize(endSize);
                Dot.this.changeColor(endColor);
                Dot.this.currentAnimator = null;
            }

            public void onAnimationCancel(Animator animation) {
                if (!Dot.this.state.isStable()) {
                    Dot.this.state = Dot.this.state.transitioningFrom();
                }
                Dot.this.changeSize(startSize);
                Dot.this.changeColor(startColor);
                Dot.this.currentAnimator = null;
            }
        });
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{startSize, endSize});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int n = (Integer)animation.getAnimatedValue();
                Dot.this.changeSize(n);
            }
        });
        ValueAnimator valueAnimator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Dot.this.changeColor(endColor);
            }
        });
        this.currentAnimator.playTogether(new Animator[]{valueAnimator, valueAnimator2});
        this.currentAnimator.start();
    }

    private void changeSize(int newSizePx) {
        this.shape.setIntrinsicWidth(newSizePx);
        this.shape.setIntrinsicHeight(newSizePx);
        this.drawableHolder.setImageDrawable(null);
        this.drawableHolder.setImageDrawable((Drawable)this.shape);
    }

    private void changeColor(int newColor) {
        this.shape.getPaint().setColor(newColor);
    }

    public Dot setInactiveDiameterPx(int inactiveDiameterPx) {
        if (inactiveDiameterPx < 0) {
            throw new IllegalArgumentException("inactiveDiameterPx cannot be less than 0");
        }
        this.inactiveDiameterPx = inactiveDiameterPx;
        this.reflectParametersInView();
        return this;
    }

    public Dot setInactiveDiameterDp(int inactiveDiameterDp) {
        if (inactiveDiameterDp < 0) {
            throw new IllegalArgumentException("inactiveDiameterDp cannot be less than 0");
        }
        this.setInactiveDiameterPx(ViewUtils.convertDpToPx(this.getContext(), inactiveDiameterDp));
        return this;
    }

    public int getInactiveDiameter() {
        return this.inactiveDiameterPx;
    }

    public Dot setActiveDiameterPx(int activeDiameterPx) {
        if (activeDiameterPx < 0) {
            throw new IllegalArgumentException("activeDiameterPx cannot be less than 0");
        }
        this.activeDiameterPx = activeDiameterPx;
        this.reflectParametersInView();
        return this;
    }

    public Dot setActiveDiameterDp(int activeDiameterDp) {
        if (activeDiameterDp < 0) {
            throw new IllegalArgumentException("activeDiameterDp cannot be less than 0");
        }
        this.setActiveDiameterPx(activeDiameterDp);
        return this;
    }

    public int getActiveDiameter() {
        return this.activeDiameterPx;
    }

    public int getInactiveColor() {
        return this.inactiveColor;
    }

    public Dot setInactiveColor(int inactiveColor) {
        this.inactiveColor = inactiveColor;
        this.reflectParametersInView();
        return this;
    }

    public int getActiveColor() {
        return this.activeColor;
    }

    public Dot setActiveColor(int activeColor) {
        this.activeColor = activeColor;
        this.reflectParametersInView();
        return this;
    }

    public int getTransitionDuration() {
        return this.transitionDurationMs;
    }

    public Dot setTransitionDuration(int transitionDurationMs) {
        if (transitionDurationMs < 0) {
            throw new IllegalArgumentException("transitionDurationMs cannot be less than 0");
        }
        this.transitionDurationMs = transitionDurationMs;
        return this;
    }

    public void toggleState(boolean animate) {
        if (this.currentAnimator != null) {
            this.currentAnimator.cancel();
        }
        if (this.state != State.ACTIVE) {
            this.setActive(animate);
        } else if (this.state != State.INACTIVE) {
            this.setInactive(animate);
        } else {
            Log.e((String)TAG, (String)"[Animation trying to start from illegal state]");
        }
    }

    public void setInactive(boolean animate) {
        boolean bl;
        if (this.currentAnimator != null) {
            this.currentAnimator.cancel();
        }
        boolean bl2 = bl = animate && this.state != State.INACTIVE && this.transitionDurationMs > 0;
        if (bl) {
            this.animateDotChange(this.activeDiameterPx, this.inactiveDiameterPx, this.activeColor, this.inactiveColor, this.transitionDurationMs);
        } else {
            this.changeSize(this.inactiveDiameterPx);
            this.changeColor(this.inactiveColor);
            this.state = State.INACTIVE;
        }
    }

    public void setActive(boolean animate) {
        boolean bl;
        if (this.currentAnimator != null) {
            this.currentAnimator.cancel();
        }
        boolean bl2 = bl = animate && this.state != State.ACTIVE && this.transitionDurationMs > 0;
        if (bl) {
            this.animateDotChange(this.inactiveDiameterPx, this.activeDiameterPx, this.inactiveColor, this.activeColor, this.transitionDurationMs);
        } else {
            this.changeSize(this.activeDiameterPx);
            this.changeColor(this.activeColor);
            this.state = State.ACTIVE;
        }
    }

    protected static enum State {
        INACTIVE(true, null, null),
        ACTIVE(true, null, null),
        TRANSITIONING_TO_ACTIVE(false, ACTIVE, INACTIVE),
        TRANSITIONING_TO_INACTIVE(false, INACTIVE, ACTIVE);

        private final boolean isStable;
        private final State to;
        private final State from;

        private State(boolean isStable, State to, State from) {
            this.isStable = isStable;
            this.to = to;
            this.from = from;
        }

        public boolean isStable() {
            return this.isStable;
        }

        public State transitioningTo() {
            return this.to;
        }

        public State transitioningFrom() {
            return this.from;
        }
    }
}

