/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.Context;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.instabug.library.Instabug;

public class InstabugDeprecationLogger {
    private static final String PREFIX_SECTION = "#section-";
    @VisibleForTesting
    static String baseUrl = "https://docs.instabug.com/docs/android-sdk-8-1-migration-guide";
    private static InstabugDeprecationLogger INSTANCE;

    private InstabugDeprecationLogger() {
    }

    public static InstabugDeprecationLogger getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstabugDeprecationLogger();
        }
        return INSTANCE;
    }

    @VisibleForTesting
    static void tearDown() {
        INSTANCE = null;
    }

    private static void setBaseUrl(String baseUrl) {
        if (baseUrl != null && baseUrl.trim().length() > 0) {
            InstabugDeprecationLogger.baseUrl = baseUrl;
        }
    }

    public void log(int section) {
        Context context;
        if (Instabug.isBuilt() && (context = Instabug.getApplicationContext()) != null) {
            boolean bl;
            boolean bl2 = bl = (context.getApplicationInfo().flags & 2) != 0;
            if (bl) {
                Log.i((String)"INSTABUG", (String)(" \n+-------------------------------------------------------------------------------------------+\n|                           [Instabug] Our APIs have changed!                               |\n+-------------------------------------------------------------------------------------------+\n| The main objective of this release is to give you more controls over the enabled Instabug |\n| products in the SDK. Some APIs have been renamed, moved to new classes or deprecated      |\n|                                                                                           |\n|                                                                                           |\n| Starting from version 8.1 of the SDK, you'll need to migrate to our new APIs. Old         |\n| APIs are currently deprecated, and while they still function, they will be completely     |\n| removed in a future release.                                                              |\n|                                                                                           |\n| For more details about this API's replacement, check the docs here:                       |\n| " + this.getMigrationPageUrl(section) + "                                                      |\n+-------------------------------------------------------------------------------------------+"));
            }
        }
    }

    @VisibleForTesting
    String getMigrationPageUrl() {
        return baseUrl;
    }

    @VisibleForTesting
    String getMigrationPageUrl(int section) {
        return baseUrl + PREFIX_SECTION + this.getSection(section);
    }

    private String getSection(int section) {
        switch (section) {
            case 0: {
                return "invoke";
            }
            case 1: {
                return "invoke-with-mode";
            }
            case 2: {
                return "setpromptoptions";
            }
            case 3: {
                return "setinvocationoptions";
            }
            case 4: {
                return "setonnewreplyreceivedcallback";
            }
            case 5: {
                return "setreplynotificationenabled";
            }
            case 6: {
                return "getunreadmessagescount";
            }
            case 7: {
                return "setpushnotificationstate";
            }
            case 8: {
                return "setpushnotificationregistrationtoken";
            }
            case 9: {
                return "shownotification";
            }
            case 10: {
                return "setinappreplynotificationsound";
            }
            case 11: {
                return "setcrashreportingstate";
            }
            case 12: {
                return "setsurveysstate";
            }
            case 13: {
                return "isinstabugnotification";
            }
            case 14: {
                return "setnotificationicon";
            }
            case 15: {
                return "setpushnotificationchannelid";
            }
            case 16: {
                return "setsystemreplynotificationsoundenabled";
            }
            case 17: {
                return "setshouldplayconversationsounds";
            }
        }
        return "";
    }
}

