/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.network;

import android.net.Uri;
import android.support.annotation.NonNull;
import com.instabug.library.network.NetworkManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class Request {
    protected static final String BASE_URL = "https://api.instabug.com/api/sdk/v3";
    private String requestUrl;
    private String endPoint;
    private RequestMethod requestMethod;
    private NetworkManager.RequestType requestType;
    private ArrayList<RequestParameter> urlParameters;
    private ArrayList<RequestParameter> bodyParameters;
    private ArrayList<RequestParameter> headers;
    private FileToUpload fileToUpload;
    private File downloadedFile;

    public Request(Endpoint endpoint, NetworkManager.RequestType requestType) {
        this.endPoint = endpoint.toString();
        this.requestUrl = BASE_URL + this.getEndpoint();
        this.requestType = requestType;
        this.initialize();
    }

    public Request(String requestUrl, NetworkManager.RequestType requestType) {
        this.requestUrl = requestUrl;
        this.requestType = requestType;
        this.initialize();
    }

    private void initialize() {
        this.urlParameters = new ArrayList();
        this.bodyParameters = new ArrayList();
        this.headers = new ArrayList();
    }

    public String getEndpoint() {
        return this.endPoint;
    }

    public void setEndpoint(String endpoint) {
        this.endPoint = endpoint;
        this.requestUrl = BASE_URL + this.getEndpoint();
    }

    public String getRequestUrl() {
        if (this.getUrlEncodedParameters() != null) {
            return this.requestUrl + this.getUrlEncodedParameters();
        }
        return this.requestUrl;
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        this.requestMethod = requestMethod;
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    public NetworkManager.RequestType getRequestType() {
        return this.requestType;
    }

    public void addHeader(RequestParameter header) {
        this.headers.add(header);
    }

    public ArrayList<RequestParameter> getHeaders() {
        return this.headers;
    }

    public Request addParameter(String key, Object value) throws JSONException {
        if (this.requestMethod.equals((Object)RequestMethod.Get) || this.requestMethod.equals((Object)RequestMethod.Delete)) {
            this.addRequestUrlParameter(key, value);
        } else {
            this.addRequestBodyParameter(key, value);
        }
        return this;
    }

    public void addRequestUrlParameter(String key, Object value) throws JSONException {
        this.urlParameters.add(new RequestParameter(key, value));
    }

    public ArrayList<RequestParameter> setRequestUrlParameters(ArrayList<RequestParameter> urlParameters) {
        this.urlParameters = urlParameters;
        return urlParameters;
    }

    public ArrayList<RequestParameter> getRequestUrlParameters() {
        return this.urlParameters;
    }

    public ArrayList<RequestParameter> clearRequestUrlParameters() {
        this.urlParameters.clear();
        return this.urlParameters;
    }

    public void addRequestBodyParameter(String key, Object value) throws JSONException {
        this.bodyParameters.add(new RequestParameter(key, value));
    }

    public ArrayList<RequestParameter> setRequestBodyParameters(ArrayList<RequestParameter> bodyParameters) {
        this.bodyParameters = bodyParameters;
        return bodyParameters;
    }

    public ArrayList<RequestParameter> getRequestBodyParameters() {
        return this.bodyParameters;
    }

    public ArrayList<RequestParameter> clearRequestBodyParameters() {
        this.bodyParameters.clear();
        return this.bodyParameters;
    }

    private String getUrlEncodedParameters() {
        Uri.Builder builder = new Uri.Builder();
        for (RequestParameter requestParameter : this.urlParameters) {
            builder.appendQueryParameter(requestParameter.getKey(), requestParameter.getValue().toString());
        }
        return builder.toString();
    }

    public String getRequestBody() {
        JSONObject jSONObject = new JSONObject();
        try {
            for (RequestParameter requestParameter : this.getRequestBodyParameters()) {
                jSONObject.put(requestParameter.getKey(), requestParameter.getValue());
            }
            return jSONObject.toString();
        }
        catch (OutOfMemoryError | JSONException throwable) {
            System.gc();
            InstabugSDKLogger.e(this, "OOM Exception trying to remove large logs...", throwable);
            throwable.printStackTrace();
            try {
                jSONObject.remove("console_log");
                jSONObject.remove("instabug_log");
                jSONObject.remove("network_log");
                return jSONObject.toString();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                InstabugSDKLogger.e(this, "Failed to resolve OOM, returning empty request body", throwable);
                outOfMemoryError.printStackTrace();
                return "";
            }
        }
    }

    public FileToUpload getFileToUpload() {
        return this.fileToUpload;
    }

    public Request setFileToUpload(FileToUpload fileToUpload) {
        this.fileToUpload = fileToUpload;
        return this;
    }

    public File getDownloadedFile() {
        return this.downloadedFile;
    }

    public Request setDownloadedFile(String downloadedFilePath) {
        this.downloadedFile = new File(downloadedFilePath);
        return this;
    }

    public static interface Callbacks<T, K> {
        public void onSucceeded(T var1);

        public void onFailed(K var1);
    }

    public static class FileToUpload {
        private String filePartName;
        private String fileName;
        private String filePath;
        private String fileType;

        public FileToUpload(@NonNull String filePartName, @NonNull String fileName, @NonNull String filePath, @NonNull String fileType) {
            this.filePartName = filePartName;
            this.fileName = fileName;
            this.filePath = filePath;
            this.fileType = fileType;
        }

        public String getFilePartName() {
            return this.filePartName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public String getFileType() {
            return this.fileType;
        }
    }

    public static class RequestParameter
    implements Serializable {
        private String key;
        private Object value;

        public RequestParameter(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static enum RequestMethod {
        Get("GET"),
        Post("POST"),
        put("PUT"),
        Delete("DELETE");

        private final String name;

        private RequestMethod(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Endpoint {
        ReportBug("/bugs"),
        AddBugAttachment("/bugs/:bug_token/attachments"),
        ReportCrash("/crashes"),
        AddCrashAttachment("/crashes/:crash_token/attachments"),
        TriggerChat("/chats"),
        SendMessage("/chats/:chat_number/messages"),
        AddMessageAttachment("/chats/:chat_number/messages/:message_id/attachments"),
        SyncChats("/chats/sync"),
        AppSettings("/features"),
        SendSession("/sessions"),
        GetSurveys("/surveys/v5"),
        SubmitSurvey("/surveys/:survey_id/v5/responses"),
        bugLogs("/bugs/:bug_token/state_logs"),
        crashLogs("/crashes/:crash_token/state_logs"),
        chatLogs("/chats/:chat_token/state_logs"),
        MigrateUUID("/migrate_uuid"),
        Analytics("/analytics"),
        PushToken("/push_token"),
        ReportCategories("/application_categories"),
        GetFeaturesRequest("/feature_reqs"),
        GetFeatureDetails("/feature_reqs/:feature_req_id"),
        GetFeatureTimeline("/feature_reqs/:feature_req_id/timeline"),
        VoteFeature("/feature_reqs/:feature_req_id/like"),
        Search("/search"),
        ADD_NEW_FEATURE("/feature_reqs"),
        AddComment("/feature_reqs/:feature_req_id/comment");

        private final String name;

        private Endpoint(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }
    }
}

