/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.model.State;
import com.instabug.library.model.c;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.HashMap;
import org.json.JSONException;

public class UserAttributesCacheManager {
    public static final String USER_ATTRIBUTES_DISK_CACHE_FILE_NAME = "/user_attributes.cache";
    public static final String USER_ATTRIBUTES_DISK_CACHE_KEY = "user_attributes_disk_cache";
    public static final String USER_ATTRIBUTES_MEMORY_CACHE_KEY = "user_attributes_memory_cache";
    public static final String USER_ATTRIBUTES_CACHE_KEY = "attrs";

    public static InMemoryCache<String, c> getCache() {
        CacheManager.getInstance().migrateCache(USER_ATTRIBUTES_DISK_CACHE_KEY, USER_ATTRIBUTES_MEMORY_CACHE_KEY, new CacheManager.KeyExtractor<String, c>(){

            public String a(c c2) {
                return UserAttributesCacheManager.USER_ATTRIBUTES_CACHE_KEY;
            }

            @Override
            public /* synthetic */ Object extractKey(Object object) {
                return this.a((c)object);
            }
        });
        return (InMemoryCache)CacheManager.getInstance().getCache(USER_ATTRIBUTES_MEMORY_CACHE_KEY);
    }

    public static void saveCacheToDisk() {
        Cache cache = CacheManager.getInstance().getCache(USER_ATTRIBUTES_MEMORY_CACHE_KEY);
        Cache cache2 = CacheManager.getInstance().getCache(USER_ATTRIBUTES_DISK_CACHE_KEY);
        if (cache != null && cache2 != null) {
            CacheManager.getInstance().migrateCache(cache, cache2, new CacheManager.KeyExtractor<String, c>(){

                public String a(c c2) {
                    return UserAttributesCacheManager.USER_ATTRIBUTES_CACHE_KEY;
                }

                @Override
                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((c)object);
                }
            });
        }
    }

    public static void putAttribute(@NonNull String key, String value) {
        InMemoryCache<String, c> inMemoryCache = UserAttributesCacheManager.getCache();
        if (inMemoryCache != null) {
            if (inMemoryCache.get(USER_ATTRIBUTES_CACHE_KEY) == null) {
                inMemoryCache.put(USER_ATTRIBUTES_CACHE_KEY, new c());
            }
            inMemoryCache.get(USER_ATTRIBUTES_CACHE_KEY).a(key, value);
        }
        UserAttributesCacheManager.saveCacheToDisk();
    }

    @Nullable
    public static String getAttribute(@NonNull String UserAttributeKey) {
        c c2;
        InMemoryCache<String, c> inMemoryCache = UserAttributesCacheManager.getCache();
        if (inMemoryCache != null && (c2 = inMemoryCache.get(USER_ATTRIBUTES_CACHE_KEY)) != null) {
            return c2.a(UserAttributeKey);
        }
        return null;
    }

    public static void deleteAttribute(String UserAttributeKey) {
        c c2;
        InMemoryCache<String, c> inMemoryCache = UserAttributesCacheManager.getCache();
        if (inMemoryCache != null && (c2 = inMemoryCache.get(USER_ATTRIBUTES_CACHE_KEY)) != null) {
            c2.b(UserAttributeKey);
        }
        UserAttributesCacheManager.saveCacheToDisk();
    }

    public static void deleteAll() {
        InMemoryCache<String, c> inMemoryCache = UserAttributesCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.invalidate();
        }
        UserAttributesCacheManager.saveCacheToDisk();
    }

    @Nullable
    public static HashMap<String, String> getAll() {
        InMemoryCache<String, c> inMemoryCache = UserAttributesCacheManager.getCache();
        c c2 = inMemoryCache != null ? UserAttributesCacheManager.getCache().get(USER_ATTRIBUTES_CACHE_KEY) : null;
        return c2 == null || c2.a() == null || c2.a().isEmpty() ? null : c2.a();
    }

    public static String getUserAttributes() {
        String string2 = "{}";
        HashMap<String, String> hashMap = UserAttributesCacheManager.getAll();
        if (hashMap != null && hashMap.size() != 0) {
            c c2 = new c();
            c2.a(hashMap);
            try {
                string2 = c2.toJson();
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(State.class, "parsing user attributes got error: " + jSONException.getMessage(), jSONException);
            }
        }
        return string2;
    }
}

