/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheChangedListener;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.List;

public class CacheManager {
    public static final String DEFAULT_IN_MEMORY_CACHE_KEY = "DEFAULT_IN_MEMORY_CACHE_KEY";
    private final List<Cache> caches = new ArrayList<Cache>();
    private static CacheManager INSTANCE;

    public CacheManager() {
        InMemoryCache inMemoryCache = new InMemoryCache(DEFAULT_IN_MEMORY_CACHE_KEY);
        this.caches.add(inMemoryCache);
    }

    public static synchronized CacheManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CacheManager();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Cache getCache(String cacheId) {
        List<Cache> list = this.caches;
        synchronized (list) {
            for (Cache cache : this.caches) {
                if (!cache.getId().equals(cacheId)) continue;
                return cache;
            }
        }
        InstabugSDKLogger.d(this, "No cache with this ID was found " + cacheId + " returning null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache addCache(Cache cache) {
        Cache cache2 = this.getCache(cache.getId());
        if (cache2 != null) {
            return cache2;
        }
        List<Cache> list = this.caches;
        synchronized (list) {
            this.caches.add(cache);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCache(String cacheId) {
        Cache cache = this.getCache(cacheId);
        if (cache != null) {
            List<Cache> list = this.caches;
            synchronized (list) {
                return this.caches.remove(cache);
            }
        }
        InstabugSDKLogger.d(this, "No cache was this ID was found " + cacheId + " to be deleted");
        return false;
    }

    public boolean cacheExists(String cacheId) {
        return this.getCache(cacheId) != null;
    }

    public boolean subscribe(String cacheId, CacheChangedListener cacheChangedListener) {
        if (this.cacheExists(cacheId)) {
            Cache cache = this.getCache(cacheId);
            return cache.addOnCacheChangedListener(cacheChangedListener);
        }
        throw new IllegalArgumentException("No cache exists with this ID to subscribe to");
    }

    public boolean unSubscribe(String cacheId, CacheChangedListener cacheChangedListener) {
        if (this.cacheExists(cacheId)) {
            Cache cache = this.getCache(cacheId);
            return cache.removeOnCacheChangedListener(cacheChangedListener);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllCaches() {
        List<Cache> list = this.caches;
        synchronized (list) {
            for (Cache cache : this.caches) {
                cache.invalidate();
            }
        }
        InstabugSDKLogger.d(this, "All caches have been invalidated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllCachesForIdentifyingUsers() {
        List<Cache> list = this.caches;
        synchronized (list) {
            for (Cache cache : this.caches) {
                if (cache.getId().equals("user_attributes_memory_cache") || cache.getId().equals("user_attributes_disk_cache")) continue;
                cache.invalidate();
            }
        }
        InstabugSDKLogger.d(this, "All caches have been invalidated except user attributes cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllCachesButUserAttributes() {
        List<Cache> list = this.caches;
        synchronized (list) {
            for (Cache cache : this.caches) {
                if (cache.getId().equalsIgnoreCase("attrs") || cache.getId().equalsIgnoreCase("/user_attributes.cache") || cache.getId().equalsIgnoreCase("user_attributes_disk_cache") || cache.getId().equalsIgnoreCase("user_attributes_memory_cache")) continue;
                cache.invalidate();
            }
        }
        InstabugSDKLogger.d(this, "All caches have been invalidated");
    }

    public <K, V> void migrateCache(@NonNull String migratingFromCacheKey, @NonNull String migratingToCacheKey, KeyExtractor<K, V> extractor) throws IllegalArgumentException {
        Cache cache = this.getCache(migratingFromCacheKey);
        InMemoryCache inMemoryCache = this.getCache(migratingToCacheKey);
        InstabugSDKLogger.v(this, "Caches to be migrated " + cache + " - " + inMemoryCache);
        if (cache == null) {
            InstabugSDKLogger.e(this, "Migration exception ", new IllegalArgumentException("No cache with these keys was found to migrate from"));
            return;
        }
        if (inMemoryCache == null) {
            inMemoryCache = new InMemoryCache(migratingToCacheKey);
            this.addCache(inMemoryCache);
        }
        this.migrateCache(cache, inMemoryCache, extractor);
    }

    public <K, V> void migrateCache(@NonNull Cache<K, V> migratingFromCache, @NonNull Cache<K, V> migratingToCache, KeyExtractor<K, V> extractor) {
        InstabugSDKLogger.d(this, "Invalidated migratingTo cache");
        if (migratingToCache == null || migratingFromCache == null) {
            InstabugSDKLogger.w(CacheManager.class, "cache migration process got failure, migratingToCache: " + migratingToCache + ", migratingFromCache: " + migratingFromCache);
            return;
        }
        migratingToCache.invalidate();
        List<V> list = migratingFromCache.getValues();
        if (list == null || list.isEmpty()) {
            InstabugSDKLogger.w(this, "Cache to migrate from doesn't contain any elements, not going further with the migration");
            return;
        }
        for (V v : list) {
            if (v == null) continue;
            InstabugSDKLogger.v(this, "Adding value " + v + " with key " + extractor.extractKey(v));
            migratingToCache.put(extractor.extractKey(v), v);
        }
    }

    public static abstract class KeyExtractor<K, V> {
        public abstract K extractKey(V var1);
    }
}

