/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache.db;

import android.database.sqlite.SQLiteOpenHelper;
import com.instabug.library.internal.storage.cache.db.SQLiteDatabaseWrapper;

public class DatabaseManager {
    private static DatabaseManager instance;
    private static SQLiteDatabaseWrapper databaseWrapper;

    public static synchronized void init(SQLiteOpenHelper sQLiteOpenHelper) {
        if (instance == null) {
            instance = new DatabaseManager();
            databaseWrapper = new SQLiteDatabaseWrapper(sQLiteOpenHelper);
        }
    }

    public static synchronized DatabaseManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException(DatabaseManager.class.getSimpleName() + " is not initialized, call init(..) method first.");
        }
        return instance;
    }

    public SQLiteDatabaseWrapper openDatabase() {
        databaseWrapper.open();
        return databaseWrapper;
    }

    public static synchronized void tearDown() {
        if (databaseWrapper != null) {
            databaseWrapper.close();
            databaseWrapper = null;
        }
        instance = null;
    }
}

