/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.internal.video.AutoScreenRecordingContract;
import com.instabug.library.internal.video.AutoScreenRecordingFileHolder;
import com.instabug.library.internal.video.AutoScreenRecordingService;
import com.instabug.library.internal.video.RequestPermissionActivity;
import com.instabug.library.model.Session;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.File;

public class InternalAutoScreenRecorderHelper
implements AutoScreenRecordingContract {
    private static InternalAutoScreenRecorderHelper INSTANCE;
    private AutoScreenRecordingFileHolder fileHolder = new AutoScreenRecordingFileHolder();
    private Disposable sessionDisposable;
    private Disposable activityLifeCycleDisposable;
    private boolean isCrashOccurred = false;

    public static InternalAutoScreenRecorderHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InternalAutoScreenRecorderHelper();
        }
        return INSTANCE;
    }

    public InternalAutoScreenRecorderHelper() {
        this.subscribeToSessionEvents();
        this.subscribeToActivityLifeCycleEvents();
    }

    @Override
    public Uri getAutoScreenRecordingFileUri() {
        return this.fileHolder.getAutoScreenRecordingFileUri();
    }

    public void setAutoScreenRecordingFile(File file) {
        this.fileHolder.setAutoScreenRecordingFile(file);
    }

    @Override
    public void delete() {
        this.fileHolder.delete();
    }

    @Override
    public void clear() {
        this.fileHolder.clear();
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.getInstance().autoScreenRecordingEnabled();
    }

    public boolean isCrashOccurred() {
        return this.isCrashOccurred;
    }

    public void setCrashOccurred(boolean bl) {
        this.isCrashOccurred = bl;
    }

    private void subscribeToSessionEvents() {
        if (this.sessionDisposable == null || this.sessionDisposable.isDisposed()) {
            this.sessionDisposable = SessionStateEventBus.getInstance().subscribe(new Consumer<Session.SessionState>(){

                public void a(Session.SessionState sessionState) {
                    if (sessionState == Session.SessionState.FINISH && !InternalAutoScreenRecorderHelper.this.isCrashOccurred()) {
                        AutoScreenRecordingEventBus.getInstance().post(AutoScreenRecordingService.Action.STOP_DELETE);
                        SettingsManager.getInstance().setAutoScreenRecordingDenied(false);
                        InternalAutoScreenRecorderHelper.this.unsubscribeFromSessionEvents();
                    }
                }

                public /* synthetic */ void accept(Object object) throws Exception {
                    this.a((Session.SessionState)((Object)object));
                }
            });
        }
    }

    private void subscribeToActivityLifeCycleEvents() {
        if (this.activityLifeCycleDisposable == null || this.activityLifeCycleDisposable.isDisposed()) {
            this.activityLifeCycleDisposable = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Consumer<ActivityLifeCycleEvent>(){

                public void a(ActivityLifeCycleEvent activityLifeCycleEvent) {
                    if (activityLifeCycleEvent == ActivityLifeCycleEvent.RESUMED) {
                        InternalAutoScreenRecorderHelper.this.subscribeToSessionEvents();
                        Handler handler = new Handler();
                        handler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                InternalAutoScreenRecorderHelper.getInstance().start();
                            }
                        }, 700L);
                    }
                }

                public /* synthetic */ void accept(Object object) throws Exception {
                    this.a((ActivityLifeCycleEvent)((Object)object));
                }
            });
        }
    }

    private void unsubscribeFromSessionEvents() {
        if (!this.sessionDisposable.isDisposed()) {
            this.sessionDisposable.dispose();
        }
    }

    public void start() {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (SettingsManager.getInstance().isScreenCurrentlyRecorded() || SettingsManager.getInstance().isAutoScreenRecordingDenied() || !this.isEnabled()) {
            return;
        }
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
        if (activity != null && !(activity instanceof _InstabugActivity) && SettingsManager.getInstance().isAppOnForeground() && Instabug.getState() == InstabugState.ENABLED && !InstabugCore.isForegroundBusy()) {
            Intent intent = new Intent((Context)activity, RequestPermissionActivity.class);
            activity.startActivity(intent);
            activity.overridePendingTransition(0, 0);
        }
    }
}

