/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.instacapture.screenshot;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import com.instabug.library.instacapture.c.a;
import com.instabug.library.instacapture.c.b;
import com.instabug.library.instacapture.screenshot.FieldHelper;
import com.instabug.library.instacapture.screenshot.RootViewInfo;
import com.instabug.library.util.InstabugSDKLogger;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;

public final class ScreenshotTaker {
    private ScreenshotTaker() {
    }

    public static Bitmap getScreenshotBitmap(Activity activity, @Nullable @IdRes int[] nArray) {
        Bitmap bitmap;
        if (activity == null) {
            throw new IllegalArgumentException("Parameter activity cannot be null.");
        }
        View view = activity.getWindow().getDecorView();
        List<RootViewInfo> list = FieldHelper.getRootViews(activity, nArray);
        a.a("viewRoots count: " + list.size());
        try {
            bitmap = (long)(view.getWidth() * view.getHeight() * 4) < b.a((Context)activity) ? Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        }
        catch (IllegalArgumentException | OutOfMemoryError throwable) {
            return null;
        }
        ScreenshotTaker.drawRootsToBitmap(list, bitmap, nArray);
        return bitmap;
    }

    private static void drawRootsToBitmap(List<RootViewInfo> list, Bitmap bitmap, @Nullable @IdRes int[] nArray) {
        for (RootViewInfo rootViewInfo : list) {
            ScreenshotTaker.drawRootToBitmap(rootViewInfo, bitmap, nArray);
        }
    }

    private static void drawRootToBitmap(RootViewInfo rootViewInfo, Bitmap bitmap, @Nullable @IdRes int[] nArray) {
        View view;
        int n;
        Canvas canvas;
        if ((rootViewInfo.getLayoutParams().flags & 2) == 2) {
            canvas = new Canvas(bitmap);
            int n2 = (int)(255.0f * rootViewInfo.getLayoutParams().dimAmount);
            canvas.drawARGB(n2, 0, 0, 0);
        }
        canvas = new Canvas(bitmap);
        canvas.translate((float)rootViewInfo.getLeft(), (float)rootViewInfo.getTop());
        int[] nArray2 = null;
        if (nArray != null) {
            nArray2 = new int[nArray.length];
        }
        if (nArray != null) {
            for (n = 0; n < nArray.length; ++n) {
                view = rootViewInfo.getView().findViewById(nArray[n]);
                if (view == null) continue;
                nArray2[n] = view.getVisibility();
                view.setVisibility(4);
            }
        }
        rootViewInfo.getView().draw(canvas);
        ScreenshotTaker.drawUnDrawableViews(rootViewInfo.getView(), canvas);
        if (nArray != null) {
            for (n = 0; n < nArray.length; ++n) {
                view = rootViewInfo.getView().findViewById(nArray[n]);
                if (view == null) continue;
                view.setVisibility(nArray2[n]);
            }
        }
    }

    private static ArrayList<View> drawUnDrawableViews(View view, Canvas canvas) {
        if (!(view instanceof ViewGroup)) {
            ArrayList<View> arrayList = new ArrayList<View>();
            arrayList.add(view);
            return arrayList;
        }
        ArrayList<View> arrayList = new ArrayList<View>();
        ViewGroup viewGroup = (ViewGroup)view;
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View view2 = viewGroup.getChildAt(i);
            ArrayList<View> arrayList2 = new ArrayList<View>();
            arrayList2.add(view);
            arrayList2.addAll(ScreenshotTaker.drawUnDrawableViews(view2, canvas));
            int[] nArray = new int[2];
            view2.getLocationOnScreen(nArray);
            if (Build.VERSION.SDK_INT >= 14 && view2 instanceof TextureView) {
                ScreenshotTaker.drawTextureView((TextureView)view2, nArray, canvas);
            }
            if (view2 instanceof GLSurfaceView) {
                ScreenshotTaker.drawGLSurfaceView((GLSurfaceView)view2, nArray, canvas);
            }
            if (Build.VERSION.SDK_INT >= 11 && view2 instanceof WebView) {
                ScreenshotTaker.drawWebView((WebView)view2, canvas);
            }
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public static void drawGLSurfaceView(GLSurfaceView gLSurfaceView, int[] nArray, Canvas canvas) {
        a.a("Drawing GLSurfaceView");
        if (gLSurfaceView.getWindowToken() != null) {
            final int n = gLSurfaceView.getWidth();
            final int n2 = gLSurfaceView.getHeight();
            boolean bl = false;
            boolean bl2 = false;
            int[] nArray2 = new int[n * (0 + n2)];
            final IntBuffer intBuffer = IntBuffer.wrap(nArray2);
            intBuffer.position(0);
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            gLSurfaceView.queueEvent(new Runnable(){

                @Override
                public void run() {
                    EGL10 eGL10 = (EGL10)EGLContext.getEGL();
                    eGL10.eglWaitGL();
                    GL10 gL10 = (GL10)eGL10.eglGetCurrentContext().getGL();
                    gL10.glFinish();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    gL10.glReadPixels(0, 0, n, 0 + n2, 6408, 5121, (Buffer)intBuffer);
                    countDownLatch.countDown();
                }
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            int[] nArray3 = new int[n * n2];
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                for (int i = 0; i < n; ++i) {
                    int n5;
                    int n6 = nArray2[n3 * n + i];
                    int n7 = n6 >> 16 & 0xFF;
                    int n8 = n6 << 16 & 0xFF0000;
                    nArray3[(n2 - n4 - 1) * n + i] = n5 = n6 & 0xFF00FF00 | n8 | n7;
                }
                ++n3;
                ++n4;
            }
            Bitmap bitmap = Bitmap.createBitmap((int[])nArray3, (int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Paint paint = new Paint();
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
            canvas.drawBitmap(bitmap, (float)nArray[0], (float)nArray[1], paint);
            bitmap.recycle();
        }
    }

    @TargetApi(value=14)
    public static void drawTextureView(TextureView textureView, int[] nArray, Canvas canvas) {
        a.a("Drawing TextureView");
        try {
            Bitmap bitmap = textureView.getBitmap();
            if (bitmap != null) {
                Paint paint = new Paint();
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
                canvas.drawBitmap(bitmap, (float)nArray[0], (float)nArray[1], paint);
                bitmap.recycle();
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugSDKLogger.e(ScreenshotTaker.class, ScreenshotTaker.class.getSimpleName(), outOfMemoryError);
        }
    }

    @TargetApi(value=11)
    public static void drawWebView(WebView webView, Canvas canvas) {
        int n = webView.getLayerType();
        if (n == 2) {
            webView.setLayerType(0, null);
            webView.setDrawingCacheEnabled(true);
            webView.buildDrawingCache(true);
            Bitmap bitmap = webView.getDrawingCache();
            if (bitmap != null) {
                Paint paint = new Paint();
                paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
                int[] nArray = new int[2];
                webView.getLocationOnScreen(nArray);
                canvas.drawBitmap(bitmap, (float)nArray[0], (float)nArray[1], paint);
                bitmap.recycle();
            }
            webView.setDrawingCacheEnabled(false);
            webView.setLayerType(n, null);
        }
    }
}

