/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.sessionprofiler.model.timeline;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.instabug.library.sessionprofiler.model.timeline.d;
import com.instabug.library.util.DeviceStateProvider;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConnectivityState
extends d {
    private static final String KEY_NAME = "name";
    private static final String KEY_WIFI = "WIFI";
    private static final String KEY_NO_CONNECTION = "no_connection";
    private String value;
    private String name;

    private ConnectivityState() {
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string2) {
        this.value = string2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string2) {
        this.name = string2;
    }

    public static ConnectivityState getNetworkState(Context context) {
        ConnectivityState connectivityState = new ConnectivityState();
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null) {
            if (networkInfo.getType() == 1) {
                connectivityState.setValue(KEY_WIFI);
                connectivityState.setName(DeviceStateProvider.getWifiSSID(context));
            } else if (networkInfo.getType() == 0) {
                connectivityState.setName(DeviceStateProvider.getCarrier(context));
                connectivityState.setValue(networkInfo.getSubtypeName());
            }
        } else {
            connectivityState.setValue(KEY_NO_CONNECTION);
        }
        return connectivityState;
    }

    @Override
    protected JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = this.getTimelinePointJSONObject(this.value);
        if (this.name != null) {
            jSONObject.put(KEY_NAME, (Object)this.name);
        }
        return jSONObject;
    }

    private static ConnectivityState fromJSONObject(JSONObject jSONObject) throws JSONException {
        ConnectivityState connectivityState = new ConnectivityState();
        connectivityState.setTime(jSONObject.getDouble("t"));
        connectivityState.setValue(jSONObject.getString("v"));
        if (jSONObject.has(KEY_NAME)) {
            connectivityState.setName(jSONObject.getString(KEY_NAME));
        }
        return connectivityState;
    }

    static LinkedList<d> fromJSONArray(JSONArray jSONArray) throws JSONException {
        LinkedList<d> linkedList = new LinkedList<d>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            linkedList.add(ConnectivityState.fromJSONObject(jSONArray.getJSONObject(i)));
        }
        return linkedList;
    }
}

