/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.AttachmentManager;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.Observable;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class DiskUtils {
    @Nullable
    public static synchronized Uri zipFiles(Context context, String string2, ArrayList<File> arrayList) {
        InstabugSDKLogger.v(DiskUtils.class, "zipping " + arrayList.size() + " files ... , time in MS:" + System.currentTimeMillis());
        try {
            File file = new File(AttachmentManager.getAttachmentDirectory(context) + File.separator + string2 + "_" + System.currentTimeMillis() + ".zip");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            for (File file2 : arrayList) {
                if (file2 == null) continue;
                zipOutputStream.putNextEntry(new ZipEntry(file2.getName()));
                DiskUtils.copy(file2, (OutputStream)zipOutputStream);
                zipOutputStream.closeEntry();
            }
            if (file.length() != 0L) {
                zipOutputStream.close();
            }
            InstabugSDKLogger.v(DiskUtils.class, "zipping files have been finished successfully, path: " + file.getPath() + ", time in MS: " + System.currentTimeMillis());
            return Uri.fromFile((File)file);
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(DiskUtils.class, "zipping files went wrong: " + iOException.getMessage() + ", time in MS: " + System.currentTimeMillis(), iOException);
            return null;
        }
    }

    private static void copy(File file, OutputStream outputStream) throws IOException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            DiskUtils.copy(fileInputStream, outputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            InstabugSDKLogger.e(DiskUtils.class, "FileNotFoundException: can not copy file to another stream");
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static ArrayList<File> listFilesInDirectory(File file) {
        File[] fileArray = file.listFiles();
        List<Object> list = new ArrayList();
        if (fileArray != null) {
            list = Arrays.asList(fileArray);
            InstabugSDKLogger.v(DiskUtils.class, "listing " + fileArray.length + " files ... at Directory name: " + file.getName() + "Directory path: " + file.getPath() + ", time in MS:" + System.currentTimeMillis());
        }
        return new ArrayList<File>(list);
    }

    @NonNull
    public static Observable<List<File>> getCleanDirectoryObservable(final File file) {
        return Observable.fromCallable((Callable)new Callable<List<File>>(){

            public List<File> a() {
                File[] fileArray;
                ArrayList<File> arrayList = new ArrayList<File>();
                if (file.exists() && file.isDirectory() && (fileArray = file.listFiles()) != null) {
                    for (File file2 : fileArray) {
                        if (file2.delete()) continue;
                        arrayList.add(file2);
                    }
                }
                return arrayList;
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.a();
            }
        }).subscribeOn(Schedulers.io());
    }
}

