/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.widget.Toast;
import com.instabug.library.Instabug;
import com.instabug.library.R;
import com.instabug.library.screenshot.a;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.InstabugMemoryUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;

public class InitialScreenshotHelper {
    public static void captureScreenshot(final @NonNull InitialScreenshotCapturingListener initialScreenshotCapturingListener) {
        if (InstabugMemoryUtils.isLowMemory()) {
            InstabugSDKLogger.e(InitialScreenshotHelper.class, "Couldn't take initial screenshot due to low memory");
            initialScreenshotCapturingListener.onScreenshotCapturingFailed(new Throwable("Your activity is currently in low memory"));
            Activity activity = InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
            if (activity != null) {
                String string2 = LocaleUtils.getLocaleStringResource(Instabug.getLocale((Context)activity), R.string.instabug_str_capturing_screenshot_error, (Context)activity);
                Toast.makeText((Context)activity, (CharSequence)string2, (int)0).show();
            }
            return;
        }
        a.a(InstabugInternalTrackingDelegate.getInstance().getTargetActivity(), new a.a(){

            @Override
            public void a(Bitmap bitmap) {
                BitmapUtils.saveBitmap(bitmap, (Context)InstabugInternalTrackingDelegate.getInstance().getTargetActivity(), new BitmapUtils.OnSaveBitmapCallback(){

                    @Override
                    public void onSuccess(Uri uri) {
                        initialScreenshotCapturingListener.onScreenshotCapturedSuccessfully(uri);
                    }

                    @Override
                    public void onError(Throwable throwable) {
                        InstabugSDKLogger.e(this, "initial screenshot capturing got error: " + throwable.getMessage() + ", time in MS: " + System.currentTimeMillis(), throwable);
                        initialScreenshotCapturingListener.onScreenshotCapturingFailed(throwable);
                    }
                });
            }

            @Override
            public void a(Throwable throwable) {
                InstabugSDKLogger.e(this, "initial screenshot capturing got error: " + throwable.getMessage() + ", time in MS: " + System.currentTimeMillis(), throwable);
                initialScreenshotCapturingListener.onScreenshotCapturingFailed(throwable);
            }
        });
    }

    public static interface InitialScreenshotCapturingListener {
        public void onScreenshotCapturedSuccessfully(Uri var1);

        public void onScreenshotCapturingFailed(Throwable var1);
    }
}

