/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.Context;
import android.util.Log;
import com.instabug.library.Instabug;

public class InstabugDeprecationLogger {
    private long lastCalled;
    private static InstabugDeprecationLogger INSTANCE;

    private InstabugDeprecationLogger() {
    }

    public static InstabugDeprecationLogger getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstabugDeprecationLogger();
        }
        return INSTANCE;
    }

    public void log() {
        Context context;
        if (Instabug.isBuilt() && (context = Instabug.getApplicationContext()) != null) {
            boolean bl;
            boolean bl2 = bl = (context.getApplicationInfo().flags & 2) != 0;
            if (bl && System.currentTimeMillis() - this.lastCalled > 20000L) {
                this.lastCalled = System.currentTimeMillis();
                Log.i((String)"INSTABUG", (String)" \n+---------------------------------------------------------------------------------------+\n|                           [Instabug] Our APIs have changed!                           |\n+---------------------------------------------------------------------------------------+\n| To make our APIs more intuitive and easily reachable, we renamed some of them,        |\n| and restructured them into different classes.                                         |\n|                                                                                       |\n| Starting from version 8.0 of the SDK, you'll need to migrate to our new APIs. Old     |\n| APIs are currently deprecated, and while they still function, they will be completely |\n| removed in a future release.                                                          |\n|                                                                                       |\n| To adopt the new changes, please refer to our migration guide at:                     |\n| https://docs.instabug.com/                                                            |\n+---------------------------------------------------------------------------------------+");
            }
        }
    }
}

