/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.instabug.library.e;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.internal.device.a;
import com.instabug.library.tracking.d;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DeviceStateProvider {
    public static String getDevice() {
        return InstabugDeviceProperties.getDeviceType();
    }

    public static boolean isDeviceRooted() {
        try {
            if (a.a()) {
                return true;
            }
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("DeviceStateProvider", "Something went wrong while checking if device is rooted or not " + exception.getMessage());
            return false;
        }
        return false;
    }

    public static String getOS() {
        return "OS Level " + Build.VERSION.SDK_INT;
    }

    public static String getCarrier(Context context) {
        try {
            return ((TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get Carrier", exception);
            return "Unknown";
        }
    }

    public static String getAppPackageName(Context context) {
        return InstabugDeviceProperties.getPackageName(context);
    }

    public static String getAppVersion(Context context) {
        return InstabugDeviceProperties.getAppVersion(context);
    }

    public static int getBatteryLevel(Context context) {
        try {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent intent = context.registerReceiver(null, intentFilter);
            assert (intent != null);
            int n = intent.getIntExtra("level", -1);
            int n2 = intent.getIntExtra("scale", -1);
            float f2 = (float)n / (float)n2;
            return (int)(f2 * 100.0f);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get battery level", exception);
            return -1;
        }
    }

    public static String getBatteryState(Context context) {
        try {
            boolean bl;
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent intent = context.registerReceiver(null, intentFilter);
            assert (intent != null);
            int n = intent.getIntExtra("status", -1);
            boolean bl2 = n == 2 || n == 5;
            int n2 = intent.getIntExtra("plugged", -1);
            boolean bl3 = n2 == 2;
            boolean bl4 = bl = n2 == 1;
            return bl2 ? "Charging" + (bl ? " through AC Charger" : (bl3 ? " through USB cable" : "")) : "Unplugged";
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get battery state", exception);
            return "Unknown";
        }
    }

    public static boolean getWifiState(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
            return networkInfo.isConnected();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get wifi state", exception);
            return false;
        }
    }

    public static String getWifiSSID(Context context) {
        if (DeviceStateProvider.getWifiState(context)) {
            try {
                WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                return wifiInfo.getSSID();
            }
            catch (SecurityException securityException) {
                InstabugSDKLogger.e("DeviceStateProvider", "Could not read wifi SSID. To enable please add the following line in your AndroidManifest.xml <uses-permission android:name=\"android.permission.ACCESS_WIFI_STATE\"/>");
                return "Connected";
            }
        }
        return "Not Connected";
    }

    public static long getFreeMemory(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        return memoryInfo.availMem / 0x100000L;
    }

    public static long getUsedMemory(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        long l = DeviceStateProvider.calculateTotalMemory(context) - memoryInfo.availMem;
        return l / 0x100000L;
    }

    public static long getTotalMemory(Context context) {
        long l = DeviceStateProvider.calculateTotalMemory(context);
        if (l == 0L) {
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while calculate total memory");
            return -1L;
        }
        return l / 0x100000L;
    }

    private static long calculateTotalMemory(Context context) {
        if (Build.VERSION.SDK_INT >= 16) {
            return DeviceStateProvider.calculateTotalMemoryApi16(context);
        }
        return DeviceStateProvider.calculateTotalMemoryPreApi16();
    }

    @TargetApi(value=16)
    private static long calculateTotalMemoryApi16(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        return memoryInfo.totalMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long calculateTotalMemoryPreApi16() {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile("/proc/meminfo", "r");
            String string2 = randomAccessFile.readLine();
            String[] stringArray = string2.split(":");
            string2 = stringArray[1].trim();
            string2 = string2.substring(0, string2.length() - 3).trim();
            randomAccessFile.close();
            long l = Long.parseLong(string2) * 1024L;
            return l;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return 0L;
    }

    public static long getFreeStorage() {
        if (DeviceStateProvider.externalMemoryAvailable()) {
            long l = Environment.getExternalStorageDirectory().getUsableSpace();
            return l / 0x100000L;
        }
        InstabugSDKLogger.e("DeviceStateProvider", "Got error while calculate free storage");
        return -1L;
    }

    public static long getUsedStorage() {
        if (DeviceStateProvider.externalMemoryAvailable()) {
            long l = Environment.getExternalStorageDirectory().getTotalSpace() - Environment.getExternalStorageDirectory().getFreeSpace();
            return l / 0x100000L;
        }
        InstabugSDKLogger.e("DeviceStateProvider", "Got error while calculate used storage");
        return -1L;
    }

    public static long getTotalStorage() {
        if (DeviceStateProvider.externalMemoryAvailable()) {
            long l = Environment.getExternalStorageDirectory().getTotalSpace();
            return (int)(l / 0x100000L);
        }
        InstabugSDKLogger.e("DeviceStateProvider", "Got error while calculate total storage");
        return -1L;
    }

    private static boolean externalMemoryAvailable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getScreenDensity(Context context) {
        DisplayMetrics displayMetrics = DeviceStateProvider.getDisplayMetrics(context);
        if (displayMetrics.densityDpi < 160) {
            return "ldpi";
        }
        if (displayMetrics.densityDpi < 240) {
            return "mdpi";
        }
        if (displayMetrics.densityDpi < 320) {
            return "hdpi";
        }
        if (displayMetrics.densityDpi < 480) {
            return "xhdpi";
        }
        if (displayMetrics.densityDpi < 640) {
            return "xxhdpi";
        }
        return "xxxhdpi";
    }

    public static String getScreenSize(Context context) {
        DisplayMetrics displayMetrics = DeviceStateProvider.getDisplayMetrics(context);
        return String.format("%sx%s", displayMetrics.widthPixels, displayMetrics.heightPixels);
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        display.getMetrics(displayMetrics);
        if (Build.VERSION.SDK_INT >= 17) {
            display.getRealMetrics(displayMetrics);
        }
        return displayMetrics;
    }

    public static String getScreenOrientation(Context context) {
        if (context.getResources().getConfiguration().orientation == 2) {
            return "landscape";
        }
        return "portrait";
    }

    public static String getCurrentView() {
        return d.a().b();
    }

    public static String getSdkVersion() {
        return "8.0.3";
    }

    public static String getLocale(Context context) {
        return context.getResources().getConfiguration().locale.toString();
    }

    public static long getActiveSessionDuration() {
        return e.a().b();
    }
}

