/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom.pagerindicator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.instabug.library.R;
import com.instabug.library.view.ViewUtils;

public final class Dot
extends RelativeLayout {
    private static final int DEFAULT_INACTIVE_DIAMETER_DP = 6;
    private static final int DEFAULT_ACTIVE_DIAMETER_DP = 9;
    private static final int DEFAULT_INACTIVE_COLOR = -1;
    private static final int DEFAULT_ACTIVE_COLOR = -1;
    private static final int DEFAULT_TRANSITION_DURATION_MS = 200;
    private static final boolean DEFAULT_INITIALLY_ACTIVE = false;
    private static final String TAG = "DOT";
    private int inactiveDiameterPx;
    private int activeDiameterPx;
    private int inactiveColor;
    private int activeColor;
    private int transitionDurationMs;
    private State state;
    private ShapeDrawable shape;
    private ImageView drawableHolder;
    private AnimatorSet currentAnimator = null;

    public Dot(Context context) {
        super(context);
        this.init(null, 0, 0);
    }

    public Dot(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(attributeSet, 0, 0);
    }

    public Dot(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(attributeSet, n, 0);
    }

    @TargetApi(value=21)
    public Dot(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.init(attributeSet, n, n2);
    }

    private void init(AttributeSet attributeSet, int n, int n2) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.IBDot, n, n2);
        int n3 = ViewUtils.convertDpToPx(this.getContext(), 9.0f);
        int n4 = ViewUtils.convertDpToPx(this.getContext(), 6.0f);
        this.inactiveDiameterPx = typedArray.getDimensionPixelSize(R.styleable.IBDot_ibViewPagerInactiveDiameter, n4);
        this.activeDiameterPx = typedArray.getDimensionPixelSize(R.styleable.IBDot_ibViewPagerActiveDiameter, n3);
        this.inactiveColor = typedArray.getColor(R.styleable.IBDot_ibViewPagerInactiveColor, -1);
        this.activeColor = typedArray.getColor(R.styleable.IBDot_ibViewPagerActiveColor, -1);
        this.transitionDurationMs = typedArray.getInt(R.styleable.IBDot_ibViewPagerTransitionDuration, 200);
        this.state = typedArray.getBoolean(R.styleable.IBDot_ibViewPagerInitiallyActive, false) ? State.ACTIVE : State.INACTIVE;
        typedArray.recycle();
        this.reflectParametersInView();
    }

    private void reflectParametersInView() {
        this.removeAllViews();
        int n = Math.max(this.inactiveDiameterPx, this.activeDiameterPx);
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(n, n));
        this.setGravity(17);
        int n2 = this.state == State.ACTIVE ? this.activeDiameterPx : this.inactiveDiameterPx;
        int n3 = this.state == State.ACTIVE ? this.activeColor : this.inactiveColor;
        this.shape = new ShapeDrawable((Shape)new OvalShape());
        this.shape.setIntrinsicWidth(n2);
        this.shape.setIntrinsicHeight(n2);
        this.shape.getPaint().setColor(n3);
        this.drawableHolder = new ImageView(this.getContext());
        this.drawableHolder.setImageDrawable(null);
        this.drawableHolder.setImageDrawable((Drawable)this.shape);
        this.addView((View)this.drawableHolder);
    }

    private void animateDotChange(final int n, final int n2, final int n3, final int n4, int n5) {
        if (n < 0) {
            throw new IllegalArgumentException("startSize cannot be less than 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("endSize cannot be less than 0");
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("duration cannot be less than 0");
        }
        if (this.currentAnimator != null) {
            this.currentAnimator.cancel();
        }
        this.currentAnimator = new AnimatorSet();
        this.currentAnimator.setDuration((long)n5);
        this.currentAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animator) {
                if (Dot.this.state == State.INACTIVE) {
                    Dot.this.state = State.TRANSITIONING_TO_ACTIVE;
                } else if (Dot.this.state == State.ACTIVE) {
                    Dot.this.state = State.TRANSITIONING_TO_INACTIVE;
                }
            }

            public void onAnimationEnd(Animator animator) {
                if (!Dot.this.state.isStable()) {
                    Dot.this.state = Dot.this.state.transitioningTo();
                }
                Dot.this.changeSize(n2);
                Dot.this.changeColor(n4);
                Dot.this.currentAnimator = null;
            }

            public void onAnimationCancel(Animator animator) {
                if (!Dot.this.state.isStable()) {
                    Dot.this.state = Dot.this.state.transitioningFrom();
                }
                Dot.this.changeSize(n);
                Dot.this.changeColor(n3);
                Dot.this.currentAnimator = null;
            }
        });
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{n, n2});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int n = (Integer)valueAnimator.getAnimatedValue();
                Dot.this.changeSize(n);
            }
        });
        ValueAnimator valueAnimator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float f2 = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                Dot.this.changeColor(n4);
            }
        });
        this.currentAnimator.playTogether(new Animator[]{valueAnimator, valueAnimator2});
        this.currentAnimator.start();
    }

    private void changeSize(int n) {
        this.shape.setIntrinsicWidth(n);
        this.shape.setIntrinsicHeight(n);
        this.drawableHolder.setImageDrawable(null);
        this.drawableHolder.setImageDrawable((Drawable)this.shape);
    }

    private void changeColor(int n) {
        this.shape.getPaint().setColor(n);
    }

    public Dot setInactiveDiameterPx(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("inactiveDiameterPx cannot be less than 0");
        }
        this.inactiveDiameterPx = n;
        this.reflectParametersInView();
        return this;
    }

    public Dot setInactiveDiameterDp(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("inactiveDiameterDp cannot be less than 0");
        }
        this.setInactiveDiameterPx(ViewUtils.convertDpToPx(this.getContext(), n));
        return this;
    }

    public int getInactiveDiameter() {
        return this.inactiveDiameterPx;
    }

    public Dot setActiveDiameterPx(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("activeDiameterPx cannot be less than 0");
        }
        this.activeDiameterPx = n;
        this.reflectParametersInView();
        return this;
    }

    public Dot setActiveDiameterDp(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("activeDiameterDp cannot be less than 0");
        }
        this.setActiveDiameterPx(n);
        return this;
    }

    public int getActiveDiameter() {
        return this.activeDiameterPx;
    }

    public int getInactiveColor() {
        return this.inactiveColor;
    }

    public Dot setInactiveColor(int n) {
        this.inactiveColor = n;
        this.reflectParametersInView();
        return this;
    }

    public int getActiveColor() {
        return this.activeColor;
    }

    public Dot setActiveColor(int n) {
        this.activeColor = n;
        this.reflectParametersInView();
        return this;
    }

    public int getTransitionDuration() {
        return this.transitionDurationMs;
    }

    public Dot setTransitionDuration(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("transitionDurationMs cannot be less than 0");
        }
        this.transitionDurationMs = n;
        return this;
    }

    public void toggleState(boolean bl) {
        if (this.currentAnimator != null) {
            this.currentAnimator.cancel();
        }
        if (this.state != State.ACTIVE) {
            this.setActive(bl);
        } else if (this.state != State.INACTIVE) {
            this.setInactive(bl);
        } else {
            Log.e((String)TAG, (String)"[Animation trying to start from illegal state]");
        }
    }

    public void setInactive(boolean bl) {
        boolean bl2;
        if (this.currentAnimator != null) {
            this.currentAnimator.cancel();
        }
        boolean bl3 = bl2 = bl && this.state != State.INACTIVE && this.transitionDurationMs > 0;
        if (bl2) {
            this.animateDotChange(this.activeDiameterPx, this.inactiveDiameterPx, this.activeColor, this.inactiveColor, this.transitionDurationMs);
        } else {
            this.changeSize(this.inactiveDiameterPx);
            this.changeColor(this.inactiveColor);
            this.state = State.INACTIVE;
        }
    }

    public void setActive(boolean bl) {
        boolean bl2;
        if (this.currentAnimator != null) {
            this.currentAnimator.cancel();
        }
        boolean bl3 = bl2 = bl && this.state != State.ACTIVE && this.transitionDurationMs > 0;
        if (bl2) {
            this.animateDotChange(this.inactiveDiameterPx, this.activeDiameterPx, this.inactiveColor, this.activeColor, this.transitionDurationMs);
        } else {
            this.changeSize(this.activeDiameterPx);
            this.changeColor(this.activeColor);
            this.state = State.ACTIVE;
        }
    }

    protected static enum State {
        INACTIVE(true, null, null),
        ACTIVE(true, null, null),
        TRANSITIONING_TO_ACTIVE(false, ACTIVE, INACTIVE),
        TRANSITIONING_TO_INACTIVE(false, INACTIVE, ACTIVE);

        private final boolean isStable;
        private final State to;
        private final State from;

        private State(boolean bl, State state, State state2) {
            this.isStable = bl;
            this.to = state;
            this.from = state2;
        }

        public boolean isStable() {
            return this.isStable;
        }

        public State transitioningTo() {
            return this.to;
        }

        public State transitioningFrom() {
            return this.from;
        }
    }
}

