/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.support.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class AttachmentManager {
    private static final double MAX_FILE_SIZE_IN_MB = 50.0;

    public static File getAttachmentDirectory(Context context) {
        File file;
        String string2;
        if (context == null && Instabug.isBuilt()) {
            context = Instabug.getApplicationContext();
        }
        if (context == null) {
            return null;
        }
        if (context.getExternalFilesDir(null) != null && Environment.getExternalStorageState().equals("mounted")) {
            try {
                string2 = context.getExternalFilesDir(null).getAbsolutePath();
            }
            catch (NullPointerException nullPointerException) {
                string2 = AttachmentManager.getInternalStoragePath(context);
            }
        } else {
            string2 = AttachmentManager.getInternalStoragePath(context);
        }
        if (!(file = new File(string2 + "/instabug/")).exists()) {
            file.mkdirs();
            File file2 = new File(file, ".nomedia");
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File getNewDirectory(Context context, String directoryName) {
        File file = new File(AttachmentManager.getAttachmentDirectory(context) + "/" + directoryName + "/");
        if (!file.exists()) {
            file.mkdirs();
            File file2 = new File(file, ".nomedia");
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File getVideoFile(Context context) {
        File file = AttachmentManager.getVideoRecordingVideosDirectory(context);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.getDefault());
        String string2 = "video-" + simpleDateFormat.format(new Date()) + ".mp4";
        return new File(file, string2);
    }

    public static File getVideoRecordingFramesDirectory(Context context) {
        File file = new File(AttachmentManager.getAttachmentDirectory(context) + "/frames/");
        if (!file.exists()) {
            file.mkdirs();
            File file2 = new File(file, ".nomedia");
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File getVideoRecordingVideosDirectory(Context context) {
        File file = new File(AttachmentManager.getAttachmentDirectory(context) + "/videos/");
        if (!file.exists()) {
            file.mkdirs();
            File file2 = new File(file, ".nomedia");
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File getAutoScreenRecordingVideosDirectory(Context context) {
        File file = new File(AttachmentManager.getAttachmentDirectory(context) + "/auto_recording/");
        if (!file.exists()) {
            file.mkdirs();
            File file2 = new File(file, ".nomedia");
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File getAutoScreenRecordingFile(Context context) {
        File file = AttachmentManager.getAutoScreenRecordingVideosDirectory(context);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.ENGLISH);
        String string2 = "auto-recording-" + simpleDateFormat.format(new Date()) + ".mp4";
        return new File(file, string2);
    }

    private static String getInternalStoragePath(Context context) {
        InstabugSDKLogger.i(AttachmentManager.class, "External storage not available, saving file to internal storage.");
        return context.getFilesDir().getAbsolutePath();
    }

    private static void saveBytesToFile(byte[] data, File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        bufferedOutputStream.write(data);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    private static File getAttachmentFile(Context context, String fileName) {
        File file = AttachmentManager.getAttachmentDirectory(context);
        File file2 = new File(file, fileName);
        if (file2.exists()) {
            file2 = new File(file, String.valueOf(System.currentTimeMillis()) + "_" + fileName);
        }
        return file2;
    }

    public static Uri getUriFromBytes(Context context, byte[] data, String fileName) {
        File file = AttachmentManager.getAttachmentFile(context, fileName);
        try {
            AttachmentManager.saveBytesToFile(data, file);
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(AttachmentManager.class, iOException.getMessage(), iOException);
            return null;
        }
        return Uri.fromFile((File)file);
    }

    public static void copyFromUriIntoFile(Context context, Uri source, File target) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(context.getContentResolver().openInputStream(source));
        InstabugSDKLogger.d(AttachmentManager.class, "Target file path: " + target.getPath());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(context.getContentResolver().openOutputStream(Uri.fromFile((File)target)));
        byte[] byArray = new byte[32768];
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedOutputStream.close();
        bufferedInputStream.close();
    }

    @Nullable
    public static String getGalleryImagePath(Activity activity, Uri uri) {
        if (activity == null || uri == null) {
            return null;
        }
        String[] stringArray = new String[]{"_data"};
        Cursor cursor = activity.managedQuery(uri, stringArray, null, null, null);
        if (cursor != null) {
            int n = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            return cursor.getString(n);
        }
        return null;
    }

    @Nullable
    public static Uri getNewFileUri(Context context, Uri originalUri, String fileNameWithExtension) {
        if (originalUri == null) {
            return null;
        }
        String string2 = originalUri.getLastPathSegment().toLowerCase();
        if (fileNameWithExtension != null && SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(originalUri)) {
            string2 = fileNameWithExtension;
        }
        File file = AttachmentManager.getAttachmentFile(context, string2);
        try {
            AttachmentManager.copyFromUriIntoFile(context, originalUri, file);
            if (!AttachmentManager.validateFileSize(originalUri, file)) {
                return null;
            }
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(AttachmentManager.class, iOException.getMessage(), iOException);
            return null;
        }
        return Uri.fromFile((File)file);
    }

    public static Uri getNewFileUri(Context context, Uri originalUri) {
        return AttachmentManager.getNewFileUri(context, originalUri, null);
    }

    private static boolean validateFileSize(Uri uri, File attachmentFile) {
        if (SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(uri)) {
            long l = attachmentFile.length();
            double d2 = (double)l / 1048576.0;
            InstabugSDKLogger.d(AttachmentManager.class, "External attachment file size is " + l + " bytes or " + d2 + " MBs");
            if (d2 > 50.0) {
                InstabugSDKLogger.i(AttachmentManager.class, "Attachment exceeds 50.0 MBs file size limit, ignoring attachment");
                return false;
            }
        }
        return true;
    }

    public static void saveBitmap(Bitmap bitmap, Context context, a callback) {
        File file = AttachmentManager.getAttachmentDirectory(context);
        File file2 = new File(file, "bug_" + System.currentTimeMillis() + "_.jpg");
        InstabugSDKLogger.v(AttachmentManager.class, "image path: " + file2.toString());
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bufferedOutputStream);
            bufferedOutputStream.close();
            Uri uri = Uri.fromFile((File)file2);
            if (uri != null) {
                callback.a(uri);
            } else {
                callback.a(new Throwable("Uri equal null"));
            }
        }
        catch (IOException iOException) {
            callback.a(iOException);
        }
    }

    public static void saveBitmap(Bitmap bitmap, File attachmentDirectory, a callback) {
        File file = new File(attachmentDirectory, "frame_" + System.currentTimeMillis() + "_.jpg");
        InstabugSDKLogger.v(AttachmentManager.class, "video frame path: " + file.toString());
        try {
            Bitmap bitmap2;
            int n;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            int n2 = n = bitmap.getWidth() > bitmap.getHeight() ? bitmap.getWidth() : bitmap.getHeight();
            if (n > 640) {
                bitmap2 = AttachmentManager.resizeBitmap(bitmap, 640);
                bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bufferedOutputStream);
            } else {
                bitmap2 = AttachmentManager.resizeBitmap(bitmap, 320);
                bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bufferedOutputStream);
            }
            bufferedOutputStream.close();
            bitmap2 = Uri.fromFile((File)file);
            if (bitmap2 != null) {
                callback.a((Uri)bitmap2);
            } else {
                callback.a(new Throwable("Uri equal null"));
            }
        }
        catch (IOException iOException) {
            callback.a(iOException);
        }
    }

    private static Bitmap resizeBitmap(Bitmap image, int maxSize) {
        int n;
        int n2 = image.getWidth();
        float f2 = (float)n2 / (float)(n = image.getHeight());
        if (f2 > 1.0f) {
            n2 = maxSize;
            n = (int)((float)n2 / f2);
        } else {
            n = maxSize;
            n2 = (int)((float)n * f2);
        }
        return Bitmap.createScaledBitmap((Bitmap)image, (int)n2, (int)n, (boolean)false);
    }

    public static void deleteRecursive(File fileOrDirectory) {
        if (fileOrDirectory.isDirectory()) {
            File[] fileArray = fileOrDirectory.listFiles();
            if (fileArray != null && fileArray.length > 0) {
                for (File file : fileArray) {
                    AttachmentManager.deleteRecursive(file);
                }
            }
            fileOrDirectory.delete();
        } else {
            fileOrDirectory.delete();
        }
    }

    public static interface a {
        public void a(Uri var1);

        public void a(Throwable var1);
    }
}

