/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheChangedListener;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.List;

public class CacheManager {
    public static final String DEFAULT_IN_MEMORY_CACHE_KEY = "DEFAULT_IN_MEMORY_CACHE_KEY";
    private final List<Cache> caches = new ArrayList<Cache>();
    private static CacheManager INSTANCE;

    public CacheManager() {
        InMemoryCache inMemoryCache = new InMemoryCache(DEFAULT_IN_MEMORY_CACHE_KEY);
        this.caches.add(inMemoryCache);
    }

    public static synchronized CacheManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CacheManager();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Cache getCache(String string2) {
        List<Cache> list = this.caches;
        synchronized (list) {
            for (Cache cache : this.caches) {
                if (!cache.getId().equals(string2)) continue;
                return cache;
            }
        }
        InstabugSDKLogger.d(this, "No cache with this ID was found " + string2 + " returning null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache addCache(Cache cache) {
        Cache cache2 = this.getCache(cache.getId());
        if (cache2 != null) {
            return cache2;
        }
        List<Cache> list = this.caches;
        synchronized (list) {
            this.caches.add(cache);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCache(String string2) {
        Cache cache = this.getCache(string2);
        if (cache != null) {
            List<Cache> list = this.caches;
            synchronized (list) {
                return this.caches.remove(cache);
            }
        }
        InstabugSDKLogger.d(this, "No cache was this ID was found " + string2 + " to be deleted");
        return false;
    }

    public boolean cacheExists(String string2) {
        return this.getCache(string2) != null;
    }

    public boolean subscribe(String string2, CacheChangedListener cacheChangedListener) {
        if (this.cacheExists(string2)) {
            Cache cache = this.getCache(string2);
            return cache.addOnCacheChangedListener(cacheChangedListener);
        }
        throw new IllegalArgumentException("No cache exists with this ID to subscribe to");
    }

    public boolean unSubscribe(String string2, CacheChangedListener cacheChangedListener) {
        if (this.cacheExists(string2)) {
            Cache cache = this.getCache(string2);
            return cache.removeOnCacheChangedListener(cacheChangedListener);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllCaches() {
        List<Cache> list = this.caches;
        synchronized (list) {
            for (Cache cache : this.caches) {
                cache.invalidate();
            }
        }
        InstabugSDKLogger.d(this, "All caches have been invalidated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllCachesForIdentifyingUsers() {
        List<Cache> list = this.caches;
        synchronized (list) {
            for (Cache cache : this.caches) {
                if (cache.getId().equals("user_attributes_memory_cache") || cache.getId().equals("user_attributes_disk_cache")) continue;
                cache.invalidate();
            }
        }
        InstabugSDKLogger.d(this, "All caches have been invalidated except user attributes cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllCachesButUserAttributes() {
        List<Cache> list = this.caches;
        synchronized (list) {
            for (Cache cache : this.caches) {
                if (cache.getId().equalsIgnoreCase("attrs") || cache.getId().equalsIgnoreCase("/user_attributes.cache") || cache.getId().equalsIgnoreCase("user_attributes_disk_cache") || cache.getId().equalsIgnoreCase("user_attributes_memory_cache")) continue;
                cache.invalidate();
            }
        }
        InstabugSDKLogger.d(this, "All caches have been invalidated");
    }

    public <K, V> void migrateCache(@NonNull String string2, @NonNull String string3, KeyExtractor<K, V> keyExtractor) throws IllegalArgumentException {
        Cache cache = this.getCache(string2);
        InMemoryCache inMemoryCache = this.getCache(string3);
        InstabugSDKLogger.v(this, "Caches to be migrated " + cache + " - " + inMemoryCache);
        if (cache == null) {
            InstabugSDKLogger.e(this, "Migration exception ", new IllegalArgumentException("No cache with these keys was found to migrate from"));
            return;
        }
        if (inMemoryCache == null) {
            inMemoryCache = new InMemoryCache(string3);
            this.addCache(inMemoryCache);
        }
        this.migrateCache(cache, inMemoryCache, keyExtractor);
    }

    public <K, V> void migrateCache(@NonNull Cache<K, V> cache, @NonNull Cache<K, V> cache2, KeyExtractor<K, V> keyExtractor) {
        InstabugSDKLogger.d(this, "Invalidated migratingTo cache");
        if (cache2 == null || cache == null) {
            InstabugSDKLogger.w(CacheManager.class, "cache migration process got failure, migratingToCache: " + cache2 + ", migratingFromCache: " + cache);
            return;
        }
        cache2.invalidate();
        List<V> list = cache.getValues();
        if (list == null || list.isEmpty()) {
            InstabugSDKLogger.w(this, "Cache to migrate from doesn't contain any elements, not going further with the migration");
            return;
        }
        for (V v : list) {
            if (v == null) continue;
            InstabugSDKLogger.v(this, "Adding value " + v + " with key " + keyExtractor.extractKey(v));
            cache2.put(keyExtractor.extractKey(v), v);
        }
    }

    public static abstract class KeyExtractor<K, V> {
        public abstract K extractKey(V var1);
    }
}

