/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.webkit.URLUtil;
import java.io.File;
import javax.annotation.Nonnull;

public final class FileUtils {
    private static final int NOT_FOUND = -1;
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';

    public static int getFileType(@NonNull File file) {
        if (file.isDirectory()) {
            return 2;
        }
        String string2 = file.getAbsolutePath();
        int n = FileUtils.getIndexOfExtension(string2);
        return n == -1 ? -1 : FileUtils.getTypeFromExtension(string2);
    }

    public static Intent getFileViewerIntent(@Nonnull String string2) {
        if (URLUtil.isNetworkUrl((String)string2)) {
            return new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        }
        String string3 = FileUtils.getExtension(string2);
        Uri uri = Uri.fromFile((File)new File(string2));
        return FileUtils.appropriateIntent(uri, string3);
    }

    public static String getExtension(@NonNull File file) {
        return FileUtils.getExtension(file.getAbsolutePath());
    }

    public static String getExtension(@NonNull String string2) {
        int n = FileUtils.getIndexOfExtension(string2);
        return n == -1 ? "" : string2.substring(n + 1);
    }

    public static boolean isVideoFile(@NonNull File file) {
        if (!file.isFile()) {
            return false;
        }
        String string2 = FileUtils.getExtension(file);
        return FileUtils.isVideoExtension(string2);
    }

    public static boolean isImageFile(@NonNull File file) {
        if (!file.isFile()) {
            return false;
        }
        String string2 = FileUtils.getExtension(file);
        return FileUtils.isImageExtension(string2);
    }

    public static boolean isTextFile(@NonNull File file) {
        if (!file.isFile()) {
            return false;
        }
        String string2 = FileUtils.getExtension(file.getAbsolutePath());
        return FileUtils.isTextExtension(string2);
    }

    public static boolean isVideoExtension(@NonNull String string2) {
        return string2.equalsIgnoreCase("mp4") || string2.equalsIgnoreCase("avi") || string2.equalsIgnoreCase("mpg") || string2.equalsIgnoreCase("3gp") || string2.equalsIgnoreCase("3gpp") || string2.equalsIgnoreCase("ts") || string2.equalsIgnoreCase("AAC") || string2.equalsIgnoreCase("webm") || string2.equalsIgnoreCase("mkv");
    }

    public static boolean isImageExtension(@NonNull String string2) {
        return string2.equalsIgnoreCase("jpeg") || string2.equalsIgnoreCase("gif") || string2.equalsIgnoreCase("png") || string2.equalsIgnoreCase("bmp") || string2.equalsIgnoreCase("jpg") || string2.equalsIgnoreCase("webp");
    }

    private static boolean isTextExtension(@NonNull String string2) {
        return string2.equalsIgnoreCase("txt");
    }

    private static int getTypeFromExtension(String string2) {
        String string3 = FileUtils.getExtension(string2);
        if (FileUtils.isVideoExtension(string3)) {
            return 0;
        }
        if (FileUtils.isImageExtension(string3)) {
            return 1;
        }
        return -1;
    }

    private static Intent appropriateIntent(Uri uri, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW");
        if (string2.equalsIgnoreCase("doc") || string2.equalsIgnoreCase("docx")) {
            intent.setDataAndType(uri, "application/msword");
        } else if (string2.equalsIgnoreCase("pdf")) {
            intent.setDataAndType(uri, "application/pdf");
        } else if (string2.equalsIgnoreCase("ppt") || string2.equalsIgnoreCase("pptx")) {
            intent.setDataAndType(uri, "application/vnd.ms-powerpoint");
        } else if (string2.equalsIgnoreCase("xls") || string2.equalsIgnoreCase("xlsx")) {
            intent.setDataAndType(uri, "application/vnd.ms-excel");
        } else if (string2.equalsIgnoreCase("zip") || string2.equalsIgnoreCase("rar")) {
            intent.setDataAndType(uri, "application/x-wav");
        } else if (string2.equalsIgnoreCase("rtf")) {
            intent.setDataAndType(uri, "application/rtf");
        } else if (string2.equalsIgnoreCase("wav") || string2.equalsIgnoreCase("mp3")) {
            intent.setDataAndType(uri, "audio/x-wav");
        } else if (string2.equalsIgnoreCase("gif")) {
            intent.setDataAndType(uri, "image/gif");
        } else if (string2.equalsIgnoreCase("jpg") || string2.equalsIgnoreCase("jpeg") || string2.equalsIgnoreCase("png")) {
            intent.setDataAndType(uri, "image/jpeg");
        } else if (string2.equalsIgnoreCase("txt")) {
            intent.setDataAndType(uri, "text/plain");
        } else if (string2.equalsIgnoreCase("3gp") || string2.equalsIgnoreCase("mpg") || string2.equalsIgnoreCase("mpeg") || string2.equalsIgnoreCase("mpe") || string2.equalsIgnoreCase("mp4") || string2.equalsIgnoreCase("avi")) {
            intent.setDataAndType(uri, "video/*");
        } else {
            intent.setDataAndType(uri, "*/*");
        }
        intent.addFlags(0x10000000);
        return intent;
    }

    private static int getIndexOfExtension(String string2) {
        int n = string2.lastIndexOf(46);
        int n2 = string2.lastIndexOf(47);
        return n2 > n ? -1 : n;
    }
}

