/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.concurrent.atomic.AtomicInteger;

public class SQLiteDatabaseWrapper {
    private AtomicInteger mOpenCounter = new AtomicInteger();
    private SQLiteDatabase database;
    private SQLiteOpenHelper databaseHelper;

    SQLiteDatabaseWrapper(SQLiteOpenHelper sQLiteOpenHelper) {
        this.databaseHelper = sQLiteOpenHelper;
    }

    synchronized void open() {
        if (this.mOpenCounter.incrementAndGet() == 1) {
            this.database = this.databaseHelper.getWritableDatabase();
        }
    }

    public synchronized void close() {
        if (this.mOpenCounter.decrementAndGet() == 0) {
            this.database.close();
        }
    }

    public void beginTransaction() {
        this.database.beginTransaction();
    }

    public long insert(String string2, String string3, ContentValues contentValues) {
        return this.database.insert(string2, string3, contentValues);
    }

    public long insertWithOnConflictReplace(String string2, String string3, ContentValues contentValues) {
        return this.database.insertWithOnConflict(string2, string3, contentValues, 5);
    }

    private void logOpenDatabaseError() {
        InstabugSDKLogger.e(DatabaseManager.class, "Please call open at first");
    }

    public void execSQL(String string2) {
        this.database.execSQL(string2);
    }

    public void setTransactionSuccessful() {
        this.database.setTransactionSuccessful();
    }

    public void endTransaction() {
        this.database.endTransaction();
    }

    public Cursor rawQuery(String string2, String[] stringArray) {
        return this.database.rawQuery(string2, stringArray);
    }

    public void delete(String string2, String string3, String[] stringArray) {
        this.database.delete(string2, string3, stringArray);
    }

    public int update(String string2, ContentValues contentValues, String string3, String[] stringArray) {
        return this.database.update(string2, contentValues, string3, stringArray);
    }

    public Cursor query(String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6) {
        return this.database.query(string2, stringArray, string3, stringArray2, string4, string5, string6);
    }

    public Cursor query(String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6, String string7) {
        return this.database.query(string2, stringArray, string3, stringArray2, string4, string5, string6, string7);
    }

    public long queryNumEntries(String string2) {
        return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.database, (String)string2);
    }
}

