/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.content.ContentValues;
import android.database.Cursor;
import com.instabug.library.internal.storage.cache.db.DatabaseManager;
import com.instabug.library.internal.storage.cache.db.SQLiteDatabaseWrapper;
import com.instabug.library.model.Attachment;
import java.io.Serializable;
import java.util.ArrayList;

public class AttachmentsDbHelper {
    private static final String[] ATTACHMENT_COLUMN = new String[]{"attachments._id", "name", "local_path", "url", "type", "attachment_state", "video_encoded", "duration", "report_id", "encrypted"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized long insert(Attachment attachment, String string2) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("url", attachment.getUrl());
            contentValues.put("attachment_state", attachment.getAttachmentState().name());
            contentValues.put("duration", attachment.getDuration());
            contentValues.put("local_path", attachment.getLocalPath());
            contentValues.put("name", attachment.getName());
            contentValues.put("type", attachment.getType().name());
            contentValues.put("video_encoded", Boolean.valueOf(attachment.isVideoEncoded()));
            contentValues.put("report_id", string2);
            contentValues.put("encrypted", Boolean.valueOf(attachment.isEncrypted()));
            long l = sQLiteDatabaseWrapper.insert("attachments", null, contentValues);
            sQLiteDatabaseWrapper.setTransactionSuccessful();
            long l2 = l;
            return l2;
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
    }

    public static ArrayList<Attachment> retrieve(String string2, SQLiteDatabaseWrapper sQLiteDatabaseWrapper) {
        String[] stringArray = new String[]{"attachments._id", "name", "local_path", "url", "type", "attachment_state", "video_encoded", "duration", "report_id", "encrypted"};
        String[] stringArray2 = new String[]{string2};
        Cursor cursor = sQLiteDatabaseWrapper.query("attachments", stringArray, "report_id=?", stringArray2, null, null, null, null);
        ArrayList<Attachment> arrayList = new ArrayList<Attachment>();
        if (cursor.moveToFirst()) {
            do {
                Attachment attachment = new Attachment();
                int n = cursor.getColumnIndex("_id");
                attachment.setId(cursor.getInt(n));
                int n2 = cursor.getColumnIndex("name");
                attachment.setName(cursor.getString(n2));
                int n3 = cursor.getColumnIndex("attachment_state");
                attachment.setAttachmentState(Enum.valueOf(Attachment.AttachmentState.class, cursor.getString(n3)));
                int n4 = cursor.getColumnIndex("duration");
                attachment.setDuration(cursor.getString(n4));
                int n5 = cursor.getColumnIndex("url");
                attachment.setUrl(cursor.getString(n5));
                int n6 = cursor.getColumnIndex("local_path");
                attachment.setLocalPath(cursor.getString(n6));
                int n7 = cursor.getColumnIndex("video_encoded");
                attachment.setVideoEncoded(cursor.getInt(n7) != 0);
                int n8 = cursor.getColumnIndex("type");
                attachment.setType(Enum.valueOf(Attachment.Type.class, cursor.getString(n8)));
                int n9 = cursor.getColumnIndex("encrypted");
                attachment.setEncrypted(cursor.getInt(n9) != 0);
                arrayList.add(attachment);
            } while (cursor.moveToNext());
        }
        cursor.close();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Attachment> retrieve(String string2) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            Serializable serializable;
            String[] stringArray = new String[]{string2};
            Cursor cursor = sQLiteDatabaseWrapper.query("attachments", ATTACHMENT_COLUMN, "report_id=?", stringArray, null, null, null, null);
            ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
            if (cursor.moveToFirst()) {
                do {
                    serializable = new Attachment();
                    int n = cursor.getColumnIndex("_id");
                    ((Attachment)serializable).setId(cursor.getInt(n));
                    int n2 = cursor.getColumnIndex("name");
                    ((Attachment)serializable).setName(cursor.getString(n2));
                    int n3 = cursor.getColumnIndex("attachment_state");
                    ((Attachment)serializable).setAttachmentState(Enum.valueOf(Attachment.AttachmentState.class, cursor.getString(n3)));
                    int n4 = cursor.getColumnIndex("duration");
                    ((Attachment)serializable).setDuration(cursor.getString(n4));
                    int n5 = cursor.getColumnIndex("url");
                    ((Attachment)serializable).setUrl(cursor.getString(n5));
                    int n6 = cursor.getColumnIndex("local_path");
                    ((Attachment)serializable).setLocalPath(cursor.getString(n6));
                    int n7 = cursor.getColumnIndex("video_encoded");
                    ((Attachment)serializable).setVideoEncoded(cursor.getInt(n7) != 0);
                    int n8 = cursor.getColumnIndex("type");
                    ((Attachment)serializable).setType(Enum.valueOf(Attachment.Type.class, cursor.getString(n8)));
                    int n9 = cursor.getColumnIndex("encrypted");
                    ((Attachment)serializable).setEncrypted(cursor.getInt(n9) > 0);
                    arrayList.add(serializable);
                } while (cursor.moveToNext());
            }
            cursor.close();
            sQLiteDatabaseWrapper.setTransactionSuccessful();
            serializable = arrayList;
            return serializable;
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void update(long l, ContentValues contentValues) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            sQLiteDatabaseWrapper.update("attachments", contentValues, "_id=" + l, null);
            sQLiteDatabaseWrapper.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void update(String string2, String string3, ContentValues contentValues) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            sQLiteDatabaseWrapper.update("attachments", contentValues, "name='" + string2 + "' and " + "report_id" + "='" + string3 + "'", null);
            sQLiteDatabaseWrapper.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
    }

    public static synchronized void delete(long l) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            sQLiteDatabaseWrapper.delete("attachments", "_id=" + l, null);
            sQLiteDatabaseWrapper.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
    }

    public static synchronized void delete(String string2, String string3) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            sQLiteDatabaseWrapper.delete("attachments", "name='" + string2 + "' and " + "report_id" + "='" + string3 + "'", null);
            sQLiteDatabaseWrapper.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
    }

    public static synchronized void deleteAll() {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.beginTransaction();
        try {
            sQLiteDatabaseWrapper.delete("attachments", null, null);
            sQLiteDatabaseWrapper.setTransactionSuccessful();
        }
        finally {
            sQLiteDatabaseWrapper.endTransaction();
            sQLiteDatabaseWrapper.close();
        }
    }
}

