/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.AppCompatActivity;
import com.instabug.library.Instabug;
import com.instabug.library.R;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.InstabugThemeResolver;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.StatusBarUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

@SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"})
public abstract class BaseFragmentActivity<P extends BaseContract.Presenter>
extends AppCompatActivity
implements _InstabugActivity,
BaseContract.View<AppCompatActivity> {
    protected P presenter;

    public void onCreate(Bundle bundle) {
        InstabugSDKLogger.i(this, "onCreate called");
        StatusBarUtils.setStatusBar((Activity)this);
        LocaleUtils.setLocale((Activity)this, Instabug.getLocale((Context)this));
        super.onCreate(bundle);
        this.setTheme(InstabugThemeResolver.resolveTheme(SettingsManager.getInstance().getTheme()));
        this.setContentView(this.getLayout());
        this.initViews();
        this.getWindow().getDecorView().setId(R.id.instabug_decor_view);
    }

    public void onStart() {
        InstabugSDKLogger.i(this, "onStart called");
        super.onStart();
    }

    protected void onResume() {
        super.onResume();
        InstabugSDKLogger.d(this, "onResume(),  SDK Invoking State Changed: true");
        Intent intent = new Intent();
        intent.setAction("SDK invoked");
        intent.putExtra("SDK invoking state", true);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }

    protected void onPause() {
        super.onPause();
        InstabugSDKLogger.d(this, "onPause(),  SDK Invoking State Changed: false");
        Intent intent = new Intent();
        intent.setAction("SDK invoked");
        intent.putExtra("SDK invoking state", false);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }

    public void onStop() {
        InstabugSDKLogger.i(this, "onStop called");
        super.onStop();
    }

    protected void onDestroy() {
        InstabugSDKLogger.i(this, "onDestroy called");
        super.onDestroy();
    }

    @Override
    public AppCompatActivity getViewContext() {
        return this;
    }

    @Override
    public void finishActivity() {
        this.finish();
    }

    @LayoutRes
    protected abstract int getLayout();

    protected abstract void initViews();
}

