/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.media.MediaMuxer;
import com.instabug.library.Instabug;
import com.instabug.library.internal.storage.AttachmentManager;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class InstabugVideoUtils {
    private static final String TAG = "InstabugVideoUtils";

    @TargetApi(value=18)
    public String mux(String string2, String string3) throws IOException {
        File file = AttachmentManager.getVideoFile(Instabug.getApplicationContext());
        String string4 = file.getAbsolutePath();
        MediaExtractor mediaExtractor = new MediaExtractor();
        mediaExtractor.setDataSource(string3);
        MediaExtractor mediaExtractor2 = new MediaExtractor();
        mediaExtractor2.setDataSource(string2);
        InstabugSDKLogger.i(this, "Video Extractor Track Count " + mediaExtractor.getTrackCount());
        InstabugSDKLogger.i(this, "Audio Extractor Track Count " + mediaExtractor2.getTrackCount());
        InstabugSDKLogger.i(this, "Video Extractor Track duration " + mediaExtractor.getCachedDuration());
        InstabugSDKLogger.i(this, "Audio Extractor Track duration " + mediaExtractor2.getCachedDuration());
        MediaMuxer mediaMuxer = new MediaMuxer(string4, 0);
        mediaExtractor.selectTrack(0);
        MediaFormat mediaFormat = mediaExtractor.getTrackFormat(0);
        int n = mediaMuxer.addTrack(mediaFormat);
        mediaExtractor2.selectTrack(0);
        MediaFormat mediaFormat2 = mediaExtractor2.getTrackFormat(0);
        int n2 = mediaMuxer.addTrack(mediaFormat2);
        InstabugSDKLogger.i(this, "Video Format " + mediaFormat.toString());
        InstabugSDKLogger.i(this, "Audio Format " + mediaFormat2.toString());
        boolean bl = false;
        int n3 = 0;
        int n4 = 100;
        int n5 = 262144;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n5);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n5);
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        MediaCodec.BufferInfo bufferInfo2 = new MediaCodec.BufferInfo();
        mediaExtractor.seekTo(0L, 0);
        mediaExtractor2.seekTo(0L, 1);
        mediaMuxer.start();
        while (!bl) {
            bufferInfo.offset = n4;
            bufferInfo.size = mediaExtractor.readSampleData(byteBuffer, n4);
            if (bufferInfo.size < 0 || bufferInfo2.size < 0) {
                InstabugSDKLogger.i(this, "saw input EOS.");
                bl = true;
                bufferInfo.size = 0;
                continue;
            }
            bufferInfo.presentationTimeUs = mediaExtractor.getSampleTime();
            bufferInfo.flags = mediaExtractor.getSampleFlags();
            mediaMuxer.writeSampleData(n, byteBuffer, bufferInfo);
            mediaExtractor.advance();
            InstabugSDKLogger.i("ContentValues", "Frame (" + ++n3 + ") Video PresentationTimeUs:" + bufferInfo.presentationTimeUs + " Flags:" + bufferInfo.flags + " Size(KB) " + bufferInfo.size / 1024);
            InstabugSDKLogger.i(this, "Frame (" + n3 + ") Audio PresentationTimeUs:" + bufferInfo2.presentationTimeUs + " Flags:" + bufferInfo2.flags + " Size(KB) " + bufferInfo2.size / 1024);
        }
        boolean bl2 = false;
        int n6 = 0;
        while (!bl2) {
            ++n6;
            bufferInfo2.offset = n4;
            bufferInfo2.size = mediaExtractor2.readSampleData(byteBuffer2, n4);
            if (bufferInfo.size < 0 || bufferInfo2.size < 0) {
                InstabugSDKLogger.i(this, "saw input EOS.");
                bl2 = true;
                bufferInfo2.size = 0;
                continue;
            }
            bufferInfo2.presentationTimeUs = mediaExtractor2.getSampleTime();
            bufferInfo2.flags = mediaExtractor2.getSampleFlags();
            mediaMuxer.writeSampleData(n2, byteBuffer2, bufferInfo2);
            mediaExtractor2.advance();
            InstabugSDKLogger.i(this, "Frame (" + n3 + ") Video PresentationTimeUs:" + bufferInfo.presentationTimeUs + " Flags:" + bufferInfo.flags + " Size(KB) " + bufferInfo.size / 1024);
            InstabugSDKLogger.i(this, "Frame (" + n3 + ") Audio PresentationTimeUs:" + bufferInfo2.presentationTimeUs + " Flags:" + bufferInfo2.flags + " Size(KB) " + bufferInfo2.size / 1024);
        }
        mediaMuxer.stop();
        mediaMuxer.release();
        return file.getAbsolutePath();
    }

    public static int getVideoDuration(String string2) {
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(string2);
        String string3 = mediaMetadataRetriever.extractMetadata(9);
        return Integer.parseInt(string3);
    }

    public static boolean isDurationMoreThanAutoRecMaxDuration(int n, int n2) {
        return n > n2;
    }

    public static File startTrim(File file, File file2, int n) throws IOException {
        if (InstabugVideoUtils.isDurationMoreThanAutoRecMaxDuration(InstabugVideoUtils.getVideoDuration(file.getPath()), n)) {
            int n2 = InstabugVideoUtils.getVideoDuration(file.getPath());
            int n3 = n2 - n;
            InstabugVideoUtils.genVideoUsingMuxer(file.getPath(), file2.getPath(), n3, n2, false, true);
            return file2;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=21)
    private static void genVideoUsingMuxer(String string2, String string3, int n, int n2, boolean bl, boolean bl2) throws IOException {
        int n3;
        int n4;
        int n5;
        Object object;
        MediaExtractor mediaExtractor = new MediaExtractor();
        mediaExtractor.setDataSource(string2);
        int n6 = mediaExtractor.getTrackCount();
        MediaMuxer mediaMuxer = new MediaMuxer(string3, 0);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(n6);
        int n7 = -1;
        for (int i = 0; i < n6; ++i) {
            object = mediaExtractor.getTrackFormat(i);
            String string4 = object.getString("mime");
            n5 = 0;
            if (string4.startsWith("audio/") && bl) {
                n5 = 1;
            } else if (string4.startsWith("video/") && bl2) {
                n5 = 1;
            }
            if (n5 == 0) continue;
            mediaExtractor.selectTrack(i);
            n4 = mediaMuxer.addTrack(object);
            hashMap.put(i, n4);
            if (!object.containsKey("max-input-size")) continue;
            int n8 = object.getInteger("max-input-size");
            n7 = n8 > n7 ? n8 : n7;
        }
        if (n7 < 0) {
            n7 = 4096;
        }
        MediaMetadataRetriever mediaMetadataRetriever = new MediaMetadataRetriever();
        mediaMetadataRetriever.setDataSource(string2);
        object = mediaMetadataRetriever.extractMetadata(24);
        if (object != null && (n3 = Integer.parseInt((String)object)) >= 0) {
            mediaMuxer.setOrientationHint(n3);
        }
        if (n > 0) {
            mediaExtractor.seekTo((long)(n * 1000), 2);
        }
        int n9 = 0;
        n5 = -1;
        n4 = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n7);
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        try {
            mediaMuxer.start();
            while (true) {
                bufferInfo.offset = n9;
                bufferInfo.size = mediaExtractor.readSampleData(byteBuffer, n9);
                if (bufferInfo.size < 0) {
                    InstabugSDKLogger.d(TAG, "Saw input EOS.");
                    bufferInfo.size = 0;
                    break;
                }
                bufferInfo.presentationTimeUs = mediaExtractor.getSampleTime();
                if (n2 > 0 && bufferInfo.presentationTimeUs > (long)(n2 * 1000)) {
                    InstabugSDKLogger.d(TAG, "The current sample is over the trim end time.");
                    break;
                }
                bufferInfo.flags = mediaExtractor.getSampleFlags();
                n5 = mediaExtractor.getSampleTrackIndex();
                mediaMuxer.writeSampleData(((Integer)hashMap.get(n5)).intValue(), byteBuffer, bufferInfo);
                n4 = 1;
                mediaExtractor.advance();
            }
            mediaMuxer.stop();
            File file = new File(string2);
            file.delete();
        }
        catch (IllegalStateException illegalStateException) {
            InstabugSDKLogger.w(TAG, "The source video file is malformed");
        }
        finally {
            if (n4 != 0) {
                mediaMuxer.release();
                InstabugSDKLogger.d(TAG, "The muxer has been released!");
            } else {
                InstabugSDKLogger.w(TAG, "The muxer skip release/stop since it has no written frames");
            }
        }
    }
}

