/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.instabug.library.Instabug;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.util.BitmapWorkerTask;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

public class BitmapUtils {
    private static transient /* synthetic */ boolean[] $jacocoData;

    public BitmapUtils() {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        blArray[0] = true;
    }

    public static int getInMemoryByteSizeOfBitmap(Bitmap bitmap) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        if (null == bitmap) {
            blArray[1] = true;
            return 0;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            blArray[2] = true;
            blArray[3] = true;
            return bitmap.getAllocationByteCount();
        }
        if (Build.VERSION.SDK_INT >= 12) {
            blArray[4] = true;
            blArray[5] = true;
            return bitmap.getByteCount();
        }
        blArray[6] = true;
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    public static int getOnDiskByteSizeOfBitmap(Bitmap bitmap) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        if (null == bitmap) {
            blArray[7] = true;
            return 0;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        blArray[8] = true;
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        blArray[9] = true;
        blArray[10] = true;
        return byteArrayOutputStream.toByteArray().length;
    }

    public static Bitmap getBitmapFromFilePath(String string2) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        Uri uri = Uri.fromFile((File)new File(string2));
        blArray[11] = true;
        blArray[12] = true;
        return BitmapUtils.getBitmapFromUri(uri);
    }

    public static Bitmap getBitmapFromUri(@NonNull Uri uri) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        Bitmap bitmap = null;
        try {
            blArray[13] = true;
            blArray[14] = true;
            blArray[15] = true;
            bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)Instabug.getApplicationContext().getContentResolver(), (Uri)uri);
            blArray[16] = true;
        }
        catch (IOException iOException) {
            blArray[17] = true;
            iOException.printStackTrace();
            blArray[18] = true;
            blArray[19] = true;
            blArray[20] = true;
            InstabugSDKLogger.e(BitmapUtils.class, "getBitmapFromFilePath returns null because of " + iOException.getMessage());
            blArray[21] = true;
        }
        blArray[22] = true;
        return bitmap;
    }

    public static void compressBitmapAndSave(@NonNull File file) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        PoolProvider.postBitmapTask(new Runnable(file){
            final /* synthetic */ File a;
            private static transient /* synthetic */ boolean[] b;
            {
                boolean[] blArray = 1.a();
                this.a = file;
                blArray[0] = true;
            }

            @Override
            public void run() {
                boolean[] blArray = 1.a();
                try {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = true;
                    blArray[1] = true;
                    BitmapFactory.decodeStream((InputStream)new FileInputStream(this.a), null, (BitmapFactory.Options)options);
                    int n = 900;
                    int n2 = 1;
                    blArray[2] = true;
                    while (true) {
                        if (options.outWidth / n2 / 2 < 900) {
                            blArray[3] = true;
                            break;
                        }
                        if (options.outHeight / n2 / 2 < 900) {
                            blArray[4] = true;
                            break;
                        }
                        n2 *= 2;
                        blArray[5] = true;
                    }
                    BitmapFactory.Options options2 = new BitmapFactory.Options();
                    options2.inSampleSize = n2;
                    blArray[6] = true;
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)new FileInputStream(this.a), null, (BitmapFactory.Options)options2);
                    blArray[7] = true;
                    FileOutputStream fileOutputStream = new FileOutputStream(this.a);
                    blArray[8] = true;
                    bitmap.compress(BitmapUtils.access$000(this.a), 100, (OutputStream)fileOutputStream);
                    blArray[9] = true;
                    bitmap.recycle();
                    blArray[10] = true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    blArray[11] = true;
                    fileNotFoundException.printStackTrace();
                    blArray[12] = true;
                    blArray[13] = true;
                    blArray[14] = true;
                    InstabugSDKLogger.e(BitmapUtils.class, "compressBitmapAndSave bitmap doesn't compressed correctly " + fileNotFoundException.getMessage());
                    blArray[15] = true;
                }
                blArray[16] = true;
            }

            private static /* synthetic */ boolean[] a() {
                boolean[] blArray = b;
                if (b == null) {
                    blArray = b = Offline.getProbes((long)4198202421619062554L, (String)"com/instabug/library/util/BitmapUtils$1", (int)17);
                }
                return blArray;
            }
        });
        blArray[23] = true;
    }

    private static Bitmap.CompressFormat getImageMimeType(File file) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        if (file.getName().contains("png")) {
            blArray[24] = true;
            return Bitmap.CompressFormat.PNG;
        }
        blArray[25] = true;
        return Bitmap.CompressFormat.JPEG;
    }

    public static void loadBitmap(String string2, ImageView imageView) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask(imageView);
        blArray[26] = true;
        bitmapWorkerTask.execute(new String[]{string2});
        blArray[27] = true;
    }

    public static void loadBitmap(String string2, ImageView imageView, float f2, float f3) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask(imageView, f2, f3);
        blArray[28] = true;
        bitmapWorkerTask.execute(new String[]{string2});
        blArray[29] = true;
    }

    public static void loadBitmap(String string2, ImageView imageView, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask(imageView, onImageLoadedListener);
        blArray[30] = true;
        bitmapWorkerTask.execute(new String[]{string2});
        blArray[31] = true;
    }

    /*
     * Unable to fully structure code
     */
    public static int calculateInSampleSize(BitmapFactory.Options var0) {
        block5: {
            var1_1 = BitmapUtils.$jacocoInit();
            var2_2 = var0.outHeight;
            var3_3 = var0.outWidth;
            var4_4 = 1;
            var5_5 = 500;
            var6_6 = 500;
            if (var2_2 <= var5_5) break block5;
            var1_1[32] = true;
            ** GOTO lbl15
        }
        if (var3_3 <= var6_6) {
            var1_1[33] = true;
        } else {
            var1_1[34] = true;
lbl15:
            // 2 sources

            var7_7 = var2_2 / 2;
            var8_8 = var3_3 / 2;
            var1_1[35] = true;
            while (true) {
                if (var7_7 / var4_4 < var5_5) {
                    var1_1[36] = true;
                    break;
                }
                if (var8_8 / var4_4 < var6_6) {
                    var1_1[37] = true;
                    break;
                }
                var4_4 *= 2;
                var1_1[38] = true;
            }
        }
        var1_1[39] = true;
        return var4_4;
    }

    public static Bitmap decodeSampledBitmapFromLocalPath(String string2) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        blArray[40] = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        blArray[41] = true;
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options);
        options.inJustDecodeBounds = false;
        blArray[42] = true;
        blArray[43] = true;
        return BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
    }

    public static Bitmap resizeBitmap(Bitmap bitmap, float f2, float f3) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        if (bitmap == null) {
            blArray[44] = true;
            return null;
        }
        if (f2 != 0.0f) {
            blArray[45] = true;
        } else if (f3 != 0.0f) {
            blArray[46] = true;
        } else {
            blArray[47] = true;
            return bitmap;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)((int)f2), (int)((int)f3), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        blArray[48] = true;
        if (bitmap.getWidth() >= bitmap.getHeight()) {
            blArray[49] = true;
        } else if (!(f2 > f3)) {
            blArray[50] = true;
        } else {
            blArray[51] = true;
            return bitmap;
        }
        if (bitmap.getWidth() <= bitmap.getHeight()) {
            blArray[52] = true;
        } else if (!(f2 < f3)) {
            blArray[53] = true;
        } else {
            blArray[54] = true;
            return bitmap;
        }
        Canvas canvas = new Canvas(bitmap2);
        blArray[55] = true;
        Matrix matrix = new Matrix();
        blArray[56] = true;
        if (bitmap.getWidth() < bitmap.getHeight()) {
            blArray[57] = true;
            matrix.setScale(f2 / (float)bitmap.getWidth(), f3 / (float)bitmap.getHeight());
            blArray[58] = true;
        } else {
            matrix.setScale(f3 / (float)bitmap.getHeight(), f2 / (float)bitmap.getWidth());
            blArray[59] = true;
        }
        canvas.drawBitmap(bitmap, matrix, new Paint());
        blArray[60] = true;
        return bitmap2;
    }

    private static Bitmap resizeBitmap(Bitmap bitmap, int n) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        int n2 = bitmap.getWidth();
        blArray[61] = true;
        int n3 = bitmap.getHeight();
        if (n3 > n2) {
            n3 = n;
            n2 = n / 2;
            blArray[62] = true;
        } else {
            n2 = n;
            n3 = n / 2;
            blArray[63] = true;
        }
        blArray[64] = true;
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n2, (int)n3, (boolean)false);
    }

    public static void saveBitmapAsPNG(Bitmap bitmap, int n, File file, String string2, OnSaveBitmapCallback onSaveBitmapCallback) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        PoolProvider.postBitmapTask(new Runnable(file, string2, bitmap, n, onSaveBitmapCallback){
            final /* synthetic */ File a;
            final /* synthetic */ String b;
            final /* synthetic */ Bitmap c;
            final /* synthetic */ int d;
            final /* synthetic */ OnSaveBitmapCallback e;
            private static transient /* synthetic */ boolean[] f;
            {
                boolean[] blArray = 2.a();
                this.a = file;
                this.b = string2;
                this.c = bitmap;
                this.d = n;
                this.e = onSaveBitmapCallback;
                blArray[0] = true;
            }

            @Override
            public void run() {
                boolean[] blArray = 2.a();
                blArray[1] = true;
                File file = new File(this.a, this.b + "_" + System.currentTimeMillis() + ".png");
                blArray[2] = true;
                InstabugSDKLogger.v(AttachmentsUtility.class, "image path: " + file.toString());
                try {
                    blArray[3] = true;
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    blArray[4] = true;
                    this.c.compress(Bitmap.CompressFormat.PNG, this.d, (OutputStream)bufferedOutputStream);
                    blArray[5] = true;
                    bufferedOutputStream.close();
                    blArray[6] = true;
                    Uri uri = Uri.fromFile((File)file);
                    if (uri != null) {
                        blArray[7] = true;
                        this.e.onSuccess(uri);
                        blArray[8] = true;
                    } else {
                        this.e.onError(new Throwable("Uri equal null"));
                        blArray[9] = true;
                    }
                    blArray[10] = true;
                }
                catch (IOException iOException) {
                    blArray[11] = true;
                    this.e.onError(iOException);
                    blArray[12] = true;
                }
                blArray[13] = true;
            }

            private static /* synthetic */ boolean[] a() {
                boolean[] blArray = f;
                if (f == null) {
                    blArray = f = Offline.getProbes((long)6595334509421572323L, (String)"com/instabug/library/util/BitmapUtils$2", (int)14);
                }
                return blArray;
            }
        });
        blArray[65] = true;
    }

    public static void saveBitmap(Bitmap bitmap, Context context, OnSaveBitmapCallback onSaveBitmapCallback) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        PoolProvider.postBitmapTask(new Runnable(context, bitmap, onSaveBitmapCallback){
            final /* synthetic */ Context a;
            final /* synthetic */ Bitmap b;
            final /* synthetic */ OnSaveBitmapCallback c;
            private static transient /* synthetic */ boolean[] d;
            {
                boolean[] blArray = 3.a();
                this.a = context;
                this.b = bitmap;
                this.c = onSaveBitmapCallback;
                blArray[0] = true;
            }

            @Override
            public void run() {
                boolean[] blArray = 3.a();
                File file = DiskUtils.getInstabugDirectory(this.a);
                blArray[1] = true;
                File file2 = new File(file, "bug_" + System.currentTimeMillis() + "_.jpg");
                blArray[2] = true;
                InstabugSDKLogger.v(AttachmentsUtility.class, "image path: " + file2.toString());
                try {
                    blArray[3] = true;
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    blArray[4] = true;
                    this.b.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bufferedOutputStream);
                    blArray[5] = true;
                    bufferedOutputStream.close();
                    blArray[6] = true;
                    Uri uri = Uri.fromFile((File)file2);
                    blArray[7] = true;
                    Handler handler = new Handler(Looper.getMainLooper());
                    blArray[8] = true;
                    handler.post(new Runnable(this, uri){
                        final /* synthetic */ Uri a;
                        final /* synthetic */ 3 b;
                        private static transient /* synthetic */ boolean[] c;
                        {
                            boolean[] blArray = 1.a();
                            this.b = var1_1;
                            this.a = uri;
                            blArray[0] = true;
                        }

                        @Override
                        public void run() {
                            boolean[] blArray = 1.a();
                            if (this.a != null) {
                                blArray[1] = true;
                                this.b.c.onSuccess(this.a);
                                blArray[2] = true;
                            } else {
                                this.b.c.onError(new Throwable("Uri equal null"));
                                blArray[3] = true;
                            }
                            blArray[4] = true;
                        }

                        private static /* synthetic */ boolean[] a() {
                            boolean[] blArray = c;
                            if (c == null) {
                                blArray = c = Offline.getProbes((long)6025301682287988073L, (String)"com/instabug/library/util/BitmapUtils$3$1", (int)5);
                            }
                            return blArray;
                        }
                    });
                    blArray[9] = true;
                }
                catch (IOException iOException) {
                    blArray[10] = true;
                    this.c.onError(iOException);
                    blArray[11] = true;
                }
                blArray[12] = true;
            }

            private static /* synthetic */ boolean[] a() {
                boolean[] blArray = d;
                if (d == null) {
                    blArray = d = Offline.getProbes((long)3036309383542844475L, (String)"com/instabug/library/util/BitmapUtils$3", (int)13);
                }
                return blArray;
            }
        });
        blArray[66] = true;
    }

    public static void saveBitmap(Bitmap bitmap, Uri uri, Context context, OnSaveBitmapCallback onSaveBitmapCallback) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        PoolProvider.postBitmapTask(new Runnable(bitmap, context, uri, onSaveBitmapCallback){
            final /* synthetic */ Bitmap a;
            final /* synthetic */ Context b;
            final /* synthetic */ Uri c;
            final /* synthetic */ OnSaveBitmapCallback d;
            private static transient /* synthetic */ boolean[] e;
            {
                boolean[] blArray = 4.a();
                this.a = bitmap;
                this.b = context;
                this.c = uri;
                this.d = onSaveBitmapCallback;
                blArray[0] = true;
            }

            @Override
            public void run() {
                boolean[] blArray = 4.a();
                try {
                    blArray[1] = true;
                    blArray[2] = true;
                    blArray[3] = true;
                    boolean bl = this.a.compress(Bitmap.CompressFormat.PNG, 100, this.b.getContentResolver().openOutputStream(Uri.fromFile((File)new File(this.c.getPath()))));
                    blArray[4] = true;
                    Handler handler = new Handler(Looper.getMainLooper());
                    blArray[5] = true;
                    handler.post(new Runnable(this, bl){
                        final /* synthetic */ boolean a;
                        final /* synthetic */ 4 b;
                        private static transient /* synthetic */ boolean[] c;
                        {
                            boolean[] blArray = 1.a();
                            this.b = var1_1;
                            this.a = bl;
                            blArray[0] = true;
                        }

                        @Override
                        public void run() {
                            boolean[] blArray = 1.a();
                            if (!this.a) {
                                blArray[1] = true;
                            } else if (this.b.d == null) {
                                blArray[2] = true;
                            } else {
                                blArray[3] = true;
                                this.b.d.onSuccess(null);
                                blArray[4] = true;
                            }
                            blArray[5] = true;
                        }

                        private static /* synthetic */ boolean[] a() {
                            boolean[] blArray = c;
                            if (c == null) {
                                blArray = c = Offline.getProbes((long)-6729810254224116853L, (String)"com/instabug/library/util/BitmapUtils$4$1", (int)6);
                            }
                            return blArray;
                        }
                    });
                    blArray[6] = true;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    blArray[7] = true;
                    InstabugSDKLogger.e(BitmapUtils.class, fileNotFoundException.getMessage(), fileNotFoundException);
                    blArray[8] = true;
                }
                blArray[9] = true;
            }

            private static /* synthetic */ boolean[] a() {
                boolean[] blArray = e;
                if (e == null) {
                    blArray = e = Offline.getProbes((long)-3904916537628595753L, (String)"com/instabug/library/util/BitmapUtils$4", (int)10);
                }
                return blArray;
            }
        });
        blArray[67] = true;
    }

    public static void saveBitmap(Bitmap bitmap, File file, OnSaveBitmapCallback onSaveBitmapCallback) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        PoolProvider.postBitmapTask(new Runnable(file, bitmap, onSaveBitmapCallback){
            final /* synthetic */ File a;
            final /* synthetic */ Bitmap b;
            final /* synthetic */ OnSaveBitmapCallback c;
            private static transient /* synthetic */ boolean[] d;
            {
                boolean[] blArray = 5.a();
                this.a = file;
                this.b = bitmap;
                this.c = onSaveBitmapCallback;
                blArray[0] = true;
            }

            @Override
            public void run() {
                boolean[] blArray = 5.a();
                File file = new File(this.a, "frame_" + System.currentTimeMillis() + "_.jpg");
                blArray[1] = true;
                blArray[2] = true;
                blArray[3] = true;
                InstabugSDKLogger.v(AttachmentsUtility.class, "video frame path: " + file.toString());
                try {
                    Bitmap bitmap;
                    int n;
                    blArray[4] = true;
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    blArray[5] = true;
                    if (this.b.getWidth() > this.b.getHeight()) {
                        n = this.b.getWidth();
                        blArray[6] = true;
                    } else {
                        blArray[7] = true;
                        n = this.b.getHeight();
                        blArray[8] = true;
                    }
                    int n2 = n;
                    if (n2 > 640) {
                        blArray[9] = true;
                        bitmap = BitmapUtils.access$100(this.b, 640);
                        blArray[10] = true;
                        bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bufferedOutputStream);
                        blArray[11] = true;
                    } else {
                        bitmap = BitmapUtils.access$100(this.b, 320);
                        blArray[12] = true;
                        bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bufferedOutputStream);
                        blArray[13] = true;
                    }
                    bufferedOutputStream.close();
                    blArray[14] = true;
                    bitmap = Uri.fromFile((File)file);
                    if (bitmap != null) {
                        blArray[15] = true;
                        this.c.onSuccess((Uri)bitmap);
                        blArray[16] = true;
                    } else {
                        this.c.onError(new Throwable("Uri equal null"));
                        blArray[17] = true;
                    }
                    blArray[18] = true;
                }
                catch (IOException iOException) {
                    blArray[19] = true;
                    this.c.onError(iOException);
                    blArray[20] = true;
                }
                blArray[21] = true;
            }

            private static /* synthetic */ boolean[] a() {
                boolean[] blArray = d;
                if (d == null) {
                    blArray = d = Offline.getProbes((long)-7937910990891742948L, (String)"com/instabug/library/util/BitmapUtils$5", (int)22);
                }
                return blArray;
            }
        });
        blArray[68] = true;
    }

    static /* synthetic */ Bitmap.CompressFormat access$000(File file) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        blArray[69] = true;
        return BitmapUtils.getImageMimeType(file);
    }

    static /* synthetic */ Bitmap access$100(Bitmap bitmap, int n) {
        boolean[] blArray = BitmapUtils.$jacocoInit();
        blArray[70] = true;
        return BitmapUtils.resizeBitmap(bitmap, n);
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-1568811488706630482L, (String)"com/instabug/library/util/BitmapUtils", (int)71);
        }
        return blArray;
    }

    public static interface OnSaveBitmapCallback {
        public void onSuccess(Uri var1);

        public void onError(Throwable var1);
    }
}

