/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom.pagerindicator;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.instabug.library.R;
import com.instabug.library.ui.custom.pagerindicator.Dot;
import com.instabug.library.ui.custom.pagerindicator.SelectionIndicator;
import com.instabug.library.view.ViewUtils;
import java.util.ArrayList;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

public final class DotIndicator
extends RelativeLayout
implements SelectionIndicator {
    private static final String TAG = "[DotIndicator]";
    private static final int DEFAULT_NUMBER_OF_DOTS = 1;
    private static final int DEFAULT_SELECTED_DOT_INDEX = 0;
    private static final int DEFAULT_UNSELECTED_DOT_DIAMETER_DP = 6;
    private static final int DEFAULT_SELECTED_DOT_DIAMETER_DP = 9;
    private static final int DEFAULT_UNSELECTED_DOT_COLOR = -1;
    private static final int DEFAULT_SELECTED_DOT_COLOR = -1;
    private static final int DEFAULT_SPACING_BETWEEN_DOTS_DP = 7;
    private static final int DEFAULT_DOT_TRANSITION_DURATION_MS = 200;
    private final ArrayList<Dot> dots;
    private int numberOfDots;
    private int selectedDotIndex;
    private int unselectedDotDiameterPx;
    private int selectedDotDiameterPx;
    private int unselectedDotColor;
    private int selectedDotColor;
    private int spacingBetweenDotsPx;
    private int dotTransitionDuration;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public DotIndicator(Context context) {
        boolean[] blArray = DotIndicator.$jacocoInit();
        super(context);
        blArray[0] = true;
        this.dots = new ArrayList();
        blArray[1] = true;
        this.init(null, 0, 0);
        blArray[2] = true;
    }

    public DotIndicator(Context context, AttributeSet attributeSet) {
        boolean[] blArray = DotIndicator.$jacocoInit();
        super(context, attributeSet);
        blArray[3] = true;
        this.dots = new ArrayList();
        blArray[4] = true;
        this.init(attributeSet, 0, 0);
        blArray[5] = true;
    }

    public DotIndicator(Context context, AttributeSet attributeSet, int n) {
        boolean[] blArray = DotIndicator.$jacocoInit();
        super(context, attributeSet, n);
        blArray[6] = true;
        this.dots = new ArrayList();
        blArray[7] = true;
        this.init(attributeSet, n, 0);
        blArray[8] = true;
    }

    @TargetApi(value=21)
    public DotIndicator(Context context, AttributeSet attributeSet, int n, int n2) {
        boolean[] blArray = DotIndicator.$jacocoInit();
        super(context, attributeSet, n, n2);
        blArray[9] = true;
        this.dots = new ArrayList();
        blArray[10] = true;
        this.init(attributeSet, n, n2);
        blArray[11] = true;
    }

    private void init(AttributeSet attributeSet, int n, int n2) {
        boolean[] blArray = DotIndicator.$jacocoInit();
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.IBDotIndicator, n, n2);
        blArray[12] = true;
        int n3 = ViewUtils.convertDpToPx(this.getContext(), 9.0f);
        blArray[13] = true;
        int n4 = ViewUtils.convertDpToPx(this.getContext(), 6.0f);
        blArray[14] = true;
        int n5 = ViewUtils.convertDpToPx(this.getContext(), 7.0f);
        blArray[15] = true;
        this.numberOfDots = typedArray.getInt(R.styleable.IBDotIndicator_ibViewPagerNumberOfDots, 1);
        blArray[16] = true;
        this.selectedDotIndex = typedArray.getInt(R.styleable.IBDotIndicator_ibViewPagerSelectedDotIndex, 0);
        blArray[17] = true;
        this.unselectedDotDiameterPx = typedArray.getDimensionPixelSize(R.styleable.IBDotIndicator_ibViewPagerUnselectedDotDiameter, n4);
        blArray[18] = true;
        this.selectedDotDiameterPx = typedArray.getDimensionPixelSize(R.styleable.IBDotIndicator_ibViewPagerSelectedDotDiameter, n3);
        blArray[19] = true;
        this.unselectedDotColor = typedArray.getColor(R.styleable.IBDotIndicator_ibViewPagerUnselectedDotColor, -1);
        blArray[20] = true;
        this.selectedDotColor = typedArray.getColor(R.styleable.IBDotIndicator_ibViewPagerSelectedDotColor, -1);
        blArray[21] = true;
        this.spacingBetweenDotsPx = typedArray.getDimensionPixelSize(R.styleable.IBDotIndicator_ibViewPagerSpacingBetweenDots, n5);
        blArray[22] = true;
        this.dotTransitionDuration = typedArray.getDimensionPixelSize(R.styleable.IBDot_ibViewPagerTransitionDuration, 200);
        blArray[23] = true;
        typedArray.recycle();
        blArray[24] = true;
        this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        blArray[25] = true;
        this.setGravity(17);
        blArray[26] = true;
        this.reflectParametersInView();
        blArray[27] = true;
    }

    private void reflectParametersInView() {
        boolean[] blArray = DotIndicator.$jacocoInit();
        this.removeAllViews();
        blArray[28] = true;
        this.dots.clear();
        blArray[29] = true;
        for (int i = 0; i < this.numberOfDots; ++i) {
            blArray[30] = true;
            Dot dot = new Dot(this.getContext());
            blArray[31] = true;
            blArray[32] = true;
            blArray[33] = true;
            blArray[34] = true;
            blArray[35] = true;
            dot.setInactiveDiameterPx(this.unselectedDotDiameterPx).setActiveDiameterPx(this.selectedDotDiameterPx).setActiveColor(this.selectedDotColor).setInactiveColor(this.unselectedDotColor).setTransitionDuration(this.dotTransitionDuration);
            if (i == this.selectedDotIndex) {
                blArray[36] = true;
                dot.setActive(false);
                blArray[37] = true;
            } else {
                dot.setInactive(false);
                blArray[38] = true;
            }
            int n = Math.max(this.selectedDotDiameterPx, this.unselectedDotDiameterPx);
            int n2 = i * (this.spacingBetweenDotsPx + this.unselectedDotDiameterPx);
            blArray[39] = true;
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(n, n);
            blArray[40] = true;
            layoutParams.setMargins(n2, 0, 0, 0);
            if (Build.VERSION.SDK_INT < 17) {
                blArray[41] = true;
            } else {
                blArray[42] = true;
                layoutParams.setMarginStart(n2);
                blArray[43] = true;
            }
            dot.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            blArray[44] = true;
            this.addView((View)dot);
            blArray[45] = true;
            this.dots.add(i, dot);
            blArray[46] = true;
        }
        blArray[47] = true;
    }

    public void redrawDots() {
        boolean[] blArray = DotIndicator.$jacocoInit();
        this.reflectParametersInView();
        blArray[48] = true;
    }

    public void setUnselectedDotDiameterPx(int n) {
        boolean[] blArray = DotIndicator.$jacocoInit();
        this.unselectedDotDiameterPx = n;
        blArray[49] = true;
        this.reflectParametersInView();
        blArray[50] = true;
    }

    public void setUnselectedDotDiameterDp(int n) {
        boolean[] blArray = DotIndicator.$jacocoInit();
        int n2 = ViewUtils.convertDpToPx(this.getContext(), n);
        blArray[51] = true;
        this.setUnselectedDotDiameterPx(n2);
        blArray[52] = true;
    }

    public int getUnselectedDotDiameter() {
        boolean[] blArray = DotIndicator.$jacocoInit();
        blArray[53] = true;
        return this.unselectedDotDiameterPx;
    }

    public void setSelectedDotDiameterPx(int n) {
        boolean[] blArray = DotIndicator.$jacocoInit();
        this.selectedDotDiameterPx = n;
        blArray[54] = true;
        this.reflectParametersInView();
        blArray[55] = true;
    }

    public void setSelectedDotDiameterDp(int n) {
        boolean[] blArray = DotIndicator.$jacocoInit();
        int n2 = ViewUtils.convertDpToPx(this.getContext(), n);
        blArray[56] = true;
        this.setSelectedDotDiameterPx(n2);
        blArray[57] = true;
    }

    public int getSelectedDotDiameter() {
        boolean[] blArray = DotIndicator.$jacocoInit();
        blArray[58] = true;
        return this.selectedDotDiameterPx;
    }

    public int getUnselectedDotColor() {
        boolean[] blArray = DotIndicator.$jacocoInit();
        blArray[59] = true;
        return this.unselectedDotColor;
    }

    public void setUnselectedDotColor(int n) {
        boolean[] blArray = DotIndicator.$jacocoInit();
        this.unselectedDotColor = n;
        blArray[60] = true;
        this.reflectParametersInView();
        blArray[61] = true;
    }

    public int getSelectedDotColor() {
        boolean[] blArray = DotIndicator.$jacocoInit();
        blArray[62] = true;
        return this.selectedDotColor;
    }

    public void setSelectedDotColor(int n) {
        boolean[] blArray = DotIndicator.$jacocoInit();
        this.selectedDotColor = n;
        blArray[63] = true;
        this.reflectParametersInView();
        blArray[64] = true;
    }

    public void setSpacingBetweenDotsPx(int n) {
        boolean[] blArray = DotIndicator.$jacocoInit();
        this.spacingBetweenDotsPx = n;
        blArray[65] = true;
        this.reflectParametersInView();
        blArray[66] = true;
    }

    public void setSpacingBetweenDotsDp(int n) {
        boolean[] blArray = DotIndicator.$jacocoInit();
        int n2 = ViewUtils.convertDpToPx(this.getContext(), n);
        blArray[67] = true;
        this.setSpacingBetweenDotsPx(n2);
        blArray[68] = true;
    }

    public int getSpacingBetweenDots() {
        boolean[] blArray = DotIndicator.$jacocoInit();
        blArray[69] = true;
        return this.spacingBetweenDotsPx;
    }

    @Override
    public void setSelectedItem(int n, boolean bl) {
        boolean[] blArray = DotIndicator.$jacocoInit();
        if (this.dots.size() <= 0) {
            blArray[70] = true;
        } else {
            try {
                blArray[71] = true;
                if (this.selectedDotIndex >= this.dots.size()) {
                    blArray[72] = true;
                } else {
                    blArray[73] = true;
                    this.dots.get(this.selectedDotIndex).setInactive(bl);
                    blArray[74] = true;
                }
                this.dots.get(n).setActive(bl);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                blArray[75] = true;
                blArray[76] = true;
                throw new IndexOutOfBoundsException();
            }
            this.selectedDotIndex = n;
            blArray[77] = true;
        }
        blArray[78] = true;
    }

    @Override
    public int getSelectedItemIndex() {
        boolean[] blArray = DotIndicator.$jacocoInit();
        blArray[79] = true;
        return this.selectedDotIndex;
    }

    @Override
    public int getNumberOfItems() {
        boolean[] blArray = DotIndicator.$jacocoInit();
        blArray[80] = true;
        return this.numberOfDots;
    }

    @Override
    public void setNumberOfItems(int n) {
        boolean[] blArray = DotIndicator.$jacocoInit();
        this.numberOfDots = n;
        blArray[81] = true;
        this.reflectParametersInView();
        blArray[82] = true;
    }

    @Override
    public int getTransitionDuration() {
        boolean[] blArray = DotIndicator.$jacocoInit();
        blArray[83] = true;
        return this.dotTransitionDuration;
    }

    @Override
    public void setTransitionDuration(int n) {
        boolean[] blArray = DotIndicator.$jacocoInit();
        this.dotTransitionDuration = n;
        blArray[84] = true;
        this.reflectParametersInView();
        blArray[85] = true;
    }

    @Override
    public void setVisibility(boolean bl) {
        int n;
        boolean[] blArray = DotIndicator.$jacocoInit();
        if (bl) {
            n = 0;
            blArray[86] = true;
        } else {
            n = 4;
            blArray[87] = true;
        }
        this.setVisibility(n);
        blArray[88] = true;
    }

    @Override
    public boolean isVisible() {
        boolean bl;
        boolean[] blArray = DotIndicator.$jacocoInit();
        if (this.getVisibility() == 0) {
            bl = blArray[89] = true;
        } else {
            bl = false;
            blArray[90] = true;
        }
        blArray[91] = true;
        return bl;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-3752931709977145715L, (String)"com/instabug/library/ui/custom/pagerindicator/DotIndicator", (int)92);
        }
        return blArray;
    }
}

