/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.content.Context;
import android.os.Environment;
import com.instabug.library.internal.storage.cache.AssetCache;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.network.Request;
import com.instabug.library.network.RequestResponse;
import com.instabug.library.network.a.b;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.reactivex.disposables.Disposable;
import io.reactivex.observers.DisposableObserver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class AssetsCacheManager {
    private static final String ASSETS_MEMORY_CACHE_KEY = "assets_memory_cache";
    private static LinkedHashMap<String, a> currentDownloadingFiles;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public AssetsCacheManager() {
        boolean[] blArray = AssetsCacheManager.$jacocoInit();
        blArray[0] = true;
    }

    public static AssetCache getCache() {
        boolean[] blArray = AssetsCacheManager.$jacocoInit();
        if (CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY)) {
            blArray[1] = true;
        } else {
            blArray[2] = true;
            InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets cache not found, create it");
            blArray[3] = true;
            CacheManager.getInstance().addCache(new AssetCache(ASSETS_MEMORY_CACHE_KEY));
            blArray[4] = true;
            InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets created successfully");
            blArray[5] = true;
        }
        InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets cache found");
        blArray[6] = true;
        blArray[7] = true;
        return (AssetCache)CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY);
    }

    public static AssetEntity createEmptyEntity(Context context, String string2, AssetEntity.AssetType assetType) {
        boolean[] blArray = AssetsCacheManager.$jacocoInit();
        File file = new File(AssetsCacheManager.getCashDirectory(context), String.valueOf(string2.hashCode()));
        blArray[8] = true;
        blArray[9] = true;
        return new AssetEntity(String.valueOf(string2.hashCode()), assetType, string2, file);
    }

    public static void getAssetEntity(Context context, AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        AssetEntity assetEntity2;
        boolean[] blArray = AssetsCacheManager.$jacocoInit();
        AssetCache assetCache = AssetsCacheManager.getCache();
        if (assetCache != null) {
            blArray[10] = true;
            assetEntity2 = (AssetEntity)assetCache.get(assetEntity.getKey());
            blArray[11] = true;
        } else {
            assetEntity2 = null;
            blArray[12] = true;
        }
        if (assetEntity2 != null) {
            blArray[13] = true;
            InstabugSDKLogger.d(AssetsCacheManager.class, "Get file from cache");
            blArray[14] = true;
            onDownloadFinished.onSuccess(assetEntity2);
            blArray[15] = true;
        } else if (AssetsCacheManager.isDownloading(assetEntity.getKey())) {
            blArray[16] = true;
            InstabugSDKLogger.d(AssetsCacheManager.class, "File currently downloading, wait download to finish");
            blArray[17] = true;
            AssetsCacheManager.waitDownloadToFinish(assetEntity, onDownloadFinished);
            blArray[18] = true;
        } else {
            InstabugSDKLogger.d(AssetsCacheManager.class, "File not exist download it");
            blArray[19] = true;
            AssetsCacheManager.downloadAssetEntity(context, assetEntity, onDownloadFinished);
            blArray[20] = true;
        }
        blArray[21] = true;
    }

    public static void downloadAssetEntity(Context context, AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        boolean[] blArray = AssetsCacheManager.$jacocoInit();
        a a2 = new a();
        blArray[22] = true;
        a2.a(assetEntity);
        blArray[23] = true;
        List<OnDownloadFinished> list = a2.c();
        blArray[24] = true;
        list.add(onDownloadFinished);
        blArray[25] = true;
        a2.a(list);
        blArray[26] = true;
        DisposableObserver<RequestResponse> disposableObserver = b.a().a(context, assetEntity, new Request.Callbacks<AssetEntity, Throwable>(assetEntity){
            final /* synthetic */ AssetEntity a;
            private static transient /* synthetic */ boolean[] b;
            {
                boolean[] blArray = 1.a();
                this.a = assetEntity;
                blArray[0] = true;
            }

            public void a(AssetEntity assetEntity) {
                boolean[] blArray = 1.a();
                AssetsCacheManager.addAssetEntity(assetEntity);
                blArray[1] = true;
                AssetsCacheManager.notifyDownloadFinishedSuccessfully(assetEntity);
                blArray[2] = true;
            }

            public void a(Throwable throwable) {
                boolean[] blArray = 1.a();
                InstabugSDKLogger.e(this, "downloading asset entity got error: ", throwable);
                blArray[3] = true;
                AssetsCacheManager.notifyDownloadFailed(this.a, throwable);
                blArray[4] = true;
            }

            @Override
            public /* synthetic */ void onFailed(Object object) {
                boolean[] blArray = 1.a();
                this.a((Throwable)object);
                blArray[5] = true;
            }

            @Override
            public /* synthetic */ void onSucceeded(Object object) {
                boolean[] blArray = 1.a();
                this.a((AssetEntity)object);
                blArray[6] = true;
            }

            private static /* synthetic */ boolean[] a() {
                boolean[] blArray = b;
                if (b == null) {
                    blArray = b = Offline.getProbes((long)4663862115780727833L, (String)"com/instabug/library/internal/storage/cache/AssetsCacheManager$1", (int)7);
                }
                return blArray;
            }
        });
        blArray[27] = true;
        a2.a((Disposable)disposableObserver);
        blArray[28] = true;
        currentDownloadingFiles.put(a2.b().getKey(), a2);
        blArray[29] = true;
    }

    public static void addAssetEntity(AssetEntity assetEntity) {
        boolean[] blArray = AssetsCacheManager.$jacocoInit();
        AssetCache assetCache = AssetsCacheManager.getCache();
        if (assetCache == null) {
            blArray[30] = true;
        } else {
            blArray[31] = true;
            assetCache.put(assetEntity.getKey(), assetEntity);
            blArray[32] = true;
        }
        blArray[33] = true;
    }

    public static boolean isDownloading(String string2) {
        boolean bl;
        boolean[] blArray = AssetsCacheManager.$jacocoInit();
        if (currentDownloadingFiles.get(string2) != null) {
            bl = blArray[34] = true;
        } else {
            bl = false;
            blArray[35] = true;
        }
        blArray[36] = true;
        return bl;
    }

    public static void waitDownloadToFinish(AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        boolean[] blArray = AssetsCacheManager.$jacocoInit();
        List<OnDownloadFinished> list = currentDownloadingFiles.get(assetEntity.getKey()).c();
        blArray[37] = true;
        list.add(onDownloadFinished);
        blArray[38] = true;
        currentDownloadingFiles.get(assetEntity.getKey()).a(list);
        blArray[39] = true;
    }

    public static void notifyDownloadFinishedSuccessfully(AssetEntity assetEntity) {
        boolean[] blArray = AssetsCacheManager.$jacocoInit();
        Iterator<OnDownloadFinished> iterator = currentDownloadingFiles.get(assetEntity.getKey()).c().iterator();
        blArray[40] = true;
        while (iterator.hasNext()) {
            OnDownloadFinished onDownloadFinished = iterator.next();
            if (onDownloadFinished == null) {
                blArray[41] = true;
            } else {
                blArray[42] = true;
                onDownloadFinished.onSuccess(assetEntity);
                blArray[43] = true;
                currentDownloadingFiles.remove(assetEntity.getKey());
                blArray[44] = true;
            }
            blArray[45] = true;
        }
        blArray[46] = true;
    }

    public static void notifyDownloadFailed(AssetEntity assetEntity, Throwable throwable) {
        boolean[] blArray = AssetsCacheManager.$jacocoInit();
        Iterator<OnDownloadFinished> iterator = currentDownloadingFiles.get(assetEntity.getKey()).c().iterator();
        blArray[47] = true;
        while (iterator.hasNext()) {
            OnDownloadFinished onDownloadFinished = iterator.next();
            if (onDownloadFinished == null) {
                blArray[48] = true;
            } else {
                blArray[49] = true;
                onDownloadFinished.onFailed(throwable);
                blArray[50] = true;
                currentDownloadingFiles.remove(assetEntity.getKey());
                blArray[51] = true;
            }
            blArray[52] = true;
        }
        blArray[53] = true;
    }

    public static void stopRunningDownloads() {
        boolean[] blArray = AssetsCacheManager.$jacocoInit();
        blArray[54] = true;
        blArray[55] = true;
        Iterator<Map.Entry<String, a>> iterator = currentDownloadingFiles.entrySet().iterator();
        blArray[56] = true;
        while (iterator.hasNext()) {
            Map.Entry<String, a> entry = iterator.next();
            blArray[57] = true;
            entry.getValue().a().dispose();
            blArray[58] = true;
        }
        currentDownloadingFiles.clear();
        blArray[59] = true;
    }

    public static void clearRedundantFiles(Context context) {
        boolean[] blArray = AssetsCacheManager.$jacocoInit();
        File[] fileArray = AssetsCacheManager.getCashDirectory(context).listFiles();
        if (fileArray == null) {
            blArray[60] = true;
            return;
        }
        File[] fileArray2 = fileArray;
        int n = fileArray2.length;
        blArray[61] = true;
        for (int i = 0; i < n; ++i) {
            File file = fileArray2[i];
            blArray[62] = true;
            file.delete();
            blArray[63] = true;
        }
        blArray[64] = true;
    }

    public static void cleanUpCache(Context context) {
        boolean[] blArray = AssetsCacheManager.$jacocoInit();
        AssetsCacheManager.stopRunningDownloads();
        blArray[65] = true;
        if (!CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY)) {
            blArray[66] = true;
        } else {
            blArray[67] = true;
            Cache cache = CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY);
            if (cache == null) {
                blArray[68] = true;
            } else {
                blArray[69] = true;
                cache.invalidate();
                blArray[70] = true;
            }
        }
        AssetsCacheManager.clearRedundantFiles(context);
        blArray[71] = true;
    }

    /*
     * Unable to fully structure code
     */
    public static File getCashDirectory(Context var0) {
        block6: {
            var1_1 = AssetsCacheManager.$jacocoInit();
            if (Environment.getExternalStorageState().equals("mounted")) break block6;
            var1_1[72] = true;
            ** GOTO lbl14
        }
        if (var0.getExternalCacheDir() != null) {
            var1_1[74] = true;
            InstabugSDKLogger.d(AssetsCacheManager.class, "Media Mounted");
            var1_1[75] = true;
            var2_2 = var0.getExternalCacheDir().getPath();
            var1_1[76] = true;
        } else {
            var1_1[73] = true;
lbl14:
            // 2 sources

            InstabugSDKLogger.d(AssetsCacheManager.class, "External storage not available, saving file to internal storage.");
            var1_1[77] = true;
            var2_2 = var0.getCacheDir().getAbsolutePath();
            var1_1[78] = true;
        }
        var3_3 = new File(var2_2 + "/instabug/assetCache");
        var1_1[79] = true;
        if (var3_3.exists()) {
            var1_1[80] = true;
        } else {
            var1_1[81] = true;
            var4_4 = var3_3.mkdirs();
            var1_1[82] = true;
            InstabugSDKLogger.d(AssetsCacheManager.class, "Is created: " + var4_4);
            var1_1[83] = true;
            var5_5 = new File(var3_3, ".nomedia");
            try {
                var1_1[84] = true;
                var5_5.createNewFile();
                var1_1[85] = true;
            }
            catch (IOException var6_6) {
                var1_1[86] = true;
                var6_6.printStackTrace();
                var1_1[87] = true;
            }
        }
        var1_1[88] = true;
        return var3_3;
    }

    static {
        boolean[] blArray = AssetsCacheManager.$jacocoInit();
        currentDownloadingFiles = new LinkedHashMap();
        blArray[89] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)3727060432891230983L, (String)"com/instabug/library/internal/storage/cache/AssetsCacheManager", (int)90);
        }
        return blArray;
    }

    public static interface OnDownloadFinished {
        public void onSuccess(AssetEntity var1);

        public void onFailed(Throwable var1);
    }

    public static class a {
        public AssetEntity a;
        public Disposable b;
        public List<OnDownloadFinished> c;
        private static transient /* synthetic */ boolean[] d;

        public a() {
            boolean[] blArray = com.instabug.library.internal.storage.cache.AssetsCacheManager$a.d();
            blArray[0] = true;
            this.c = new ArrayList<OnDownloadFinished>();
            blArray[1] = true;
        }

        public a a(AssetEntity assetEntity) {
            boolean[] blArray = com.instabug.library.internal.storage.cache.AssetsCacheManager$a.d();
            this.a = assetEntity;
            blArray[2] = true;
            return this;
        }

        public Disposable a() {
            boolean[] blArray = com.instabug.library.internal.storage.cache.AssetsCacheManager$a.d();
            blArray[3] = true;
            return this.b;
        }

        public a a(List<OnDownloadFinished> list) {
            boolean[] blArray = com.instabug.library.internal.storage.cache.AssetsCacheManager$a.d();
            this.c = list;
            blArray[4] = true;
            return this;
        }

        public AssetEntity b() {
            boolean[] blArray = com.instabug.library.internal.storage.cache.AssetsCacheManager$a.d();
            blArray[5] = true;
            return this.a;
        }

        public a a(Disposable disposable) {
            boolean[] blArray = com.instabug.library.internal.storage.cache.AssetsCacheManager$a.d();
            this.b = disposable;
            blArray[6] = true;
            return this;
        }

        public List<OnDownloadFinished> c() {
            boolean[] blArray = com.instabug.library.internal.storage.cache.AssetsCacheManager$a.d();
            blArray[7] = true;
            return this.c;
        }

        private static /* synthetic */ boolean[] d() {
            boolean[] blArray = d;
            if (d == null) {
                blArray = d = Offline.getProbes((long)-4774685224529879722L, (String)"com/instabug/library/internal/storage/cache/AssetsCacheManager$DownloadingEntity", (int)8);
            }
            return blArray;
        }
    }
}

