/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.support.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class AttachmentManager {
    private static final double MAX_FILE_SIZE_IN_MB = 50.0;
    private static transient /* synthetic */ boolean[] $jacocoData;

    public AttachmentManager() {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        blArray[0] = true;
    }

    public static File getAttachmentDirectory(Context context) {
        String string2;
        block14: {
            block12: {
                block13: {
                    block11: {
                        boolean[] blArray = AttachmentManager.$jacocoInit();
                        if (context != null) {
                            blArray[1] = true;
                        } else {
                            blArray[2] = true;
                            if (!Instabug.isBuilt()) {
                                blArray[3] = true;
                            } else {
                                blArray[4] = true;
                                context = Instabug.getApplicationContext();
                                blArray[5] = true;
                            }
                        }
                        if (context == null) {
                            blArray[6] = true;
                            return null;
                        }
                        if (context.getExternalFilesDir(null) != null) break block11;
                        blArray[7] = true;
                        break block12;
                    }
                    if (!Environment.getExternalStorageState().equals("mounted")) break block13;
                    try {
                        blArray[9] = true;
                        string2 = context.getExternalFilesDir(null).getAbsolutePath();
                    }
                    catch (NullPointerException nullPointerException) {
                        blArray[11] = true;
                        string2 = AttachmentManager.getInternalStoragePath(context);
                        blArray[12] = true;
                    }
                    blArray[10] = true;
                    break block14;
                    break block14;
                }
                blArray[8] = true;
            }
            string2 = AttachmentManager.getInternalStoragePath(context);
            blArray[13] = true;
        }
        File file = new File(string2 + "/instabug/");
        blArray[14] = true;
        if (file.exists()) {
            blArray[15] = true;
        } else {
            blArray[16] = true;
            file.mkdirs();
            blArray[17] = true;
            File file2 = new File(file, ".nomedia");
            try {
                blArray[18] = true;
                file2.createNewFile();
                blArray[19] = true;
            }
            catch (IOException iOException) {
                blArray[20] = true;
                iOException.printStackTrace();
                blArray[21] = true;
            }
        }
        blArray[22] = true;
        return file;
    }

    public static File getNewDirectory(Context context, String string2) {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        File file = new File(AttachmentManager.getAttachmentDirectory(context) + "/" + string2 + "/");
        blArray[23] = true;
        if (file.exists()) {
            blArray[24] = true;
        } else {
            blArray[25] = true;
            file.mkdirs();
            blArray[26] = true;
            File file2 = new File(file, ".nomedia");
            try {
                blArray[27] = true;
                file2.createNewFile();
                blArray[28] = true;
            }
            catch (IOException iOException) {
                blArray[29] = true;
                iOException.printStackTrace();
                blArray[30] = true;
            }
        }
        blArray[31] = true;
        return file;
    }

    public static File getVideoFile(Context context) {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        File file = AttachmentManager.getVideoRecordingVideosDirectory(context);
        blArray[32] = true;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.getDefault());
        blArray[33] = true;
        String string2 = "video-" + simpleDateFormat.format(new Date()) + ".mp4";
        blArray[34] = true;
        blArray[35] = true;
        return new File(file, string2);
    }

    public static File getVideoRecordingFramesDirectory(Context context) {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        File file = new File(AttachmentManager.getAttachmentDirectory(context) + "/frames/");
        blArray[36] = true;
        if (file.exists()) {
            blArray[37] = true;
        } else {
            blArray[38] = true;
            file.mkdirs();
            blArray[39] = true;
            File file2 = new File(file, ".nomedia");
            try {
                blArray[40] = true;
                file2.createNewFile();
                blArray[41] = true;
            }
            catch (IOException iOException) {
                blArray[42] = true;
                iOException.printStackTrace();
                blArray[43] = true;
            }
        }
        blArray[44] = true;
        return file;
    }

    public static File getVideoRecordingVideosDirectory(Context context) {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        File file = new File(AttachmentManager.getAttachmentDirectory(context) + "/videos/");
        blArray[45] = true;
        if (file.exists()) {
            blArray[46] = true;
        } else {
            blArray[47] = true;
            file.mkdirs();
            blArray[48] = true;
            File file2 = new File(file, ".nomedia");
            try {
                blArray[49] = true;
                file2.createNewFile();
                blArray[50] = true;
            }
            catch (IOException iOException) {
                blArray[51] = true;
                iOException.printStackTrace();
                blArray[52] = true;
            }
        }
        blArray[53] = true;
        return file;
    }

    public static File getAutoScreenRecordingVideosDirectory(Context context) {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        File file = new File(AttachmentManager.getAttachmentDirectory(context) + "/auto_recording/");
        blArray[54] = true;
        if (file.exists()) {
            blArray[55] = true;
        } else {
            blArray[56] = true;
            file.mkdirs();
            blArray[57] = true;
            File file2 = new File(file, ".nomedia");
            try {
                blArray[58] = true;
                file2.createNewFile();
                blArray[59] = true;
            }
            catch (IOException iOException) {
                blArray[60] = true;
                iOException.printStackTrace();
                blArray[61] = true;
            }
        }
        blArray[62] = true;
        return file;
    }

    public static File getAutoScreenRecordingFile(Context context) {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        File file = AttachmentManager.getAutoScreenRecordingVideosDirectory(context);
        blArray[63] = true;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.ENGLISH);
        blArray[64] = true;
        String string2 = "auto-recording-" + simpleDateFormat.format(new Date()) + ".mp4";
        blArray[65] = true;
        blArray[66] = true;
        return new File(file, string2);
    }

    private static String getInternalStoragePath(Context context) {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        InstabugSDKLogger.i(AttachmentManager.class, "External storage not available, saving file to internal storage.");
        blArray[67] = true;
        blArray[68] = true;
        return context.getFilesDir().getAbsolutePath();
    }

    private static void saveBytesToFile(byte[] byArray, File file) throws IOException {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        blArray[69] = true;
        bufferedOutputStream.write(byArray);
        blArray[70] = true;
        bufferedOutputStream.flush();
        blArray[71] = true;
        bufferedOutputStream.close();
        blArray[72] = true;
    }

    private static File getAttachmentFile(Context context, String string2) {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        File file = AttachmentManager.getAttachmentDirectory(context);
        blArray[73] = true;
        File file2 = new File(file, string2);
        blArray[74] = true;
        if (!file2.exists()) {
            blArray[75] = true;
        } else {
            blArray[76] = true;
            file2 = new File(file, String.valueOf(System.currentTimeMillis()) + "_" + string2);
            blArray[77] = true;
        }
        blArray[78] = true;
        return file2;
    }

    public static Uri getUriFromBytes(Context context, byte[] byArray, String string2) {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        File file = AttachmentManager.getAttachmentFile(context, string2);
        try {
            blArray[79] = true;
            AttachmentManager.saveBytesToFile(byArray, file);
        }
        catch (IOException iOException) {
            blArray[80] = true;
            InstabugSDKLogger.e(AttachmentManager.class, iOException.getMessage(), iOException);
            blArray[81] = true;
            return null;
        }
        blArray[82] = true;
        return Uri.fromFile((File)file);
    }

    public static void copyFromUriIntoFile(Context context, Uri uri, File file) throws IOException {
        int n;
        boolean[] blArray = AttachmentManager.$jacocoInit();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(context.getContentResolver().openInputStream(uri));
        blArray[83] = true;
        InstabugSDKLogger.d(AttachmentManager.class, "Target file path: " + file.getPath());
        blArray[84] = true;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(context.getContentResolver().openOutputStream(Uri.fromFile((File)file)));
        byte[] byArray = new byte[32768];
        blArray[85] = true;
        while ((n = bufferedInputStream.read(byArray)) > 0) {
            blArray[86] = true;
            bufferedOutputStream.write(byArray, 0, n);
            blArray[87] = true;
        }
        bufferedOutputStream.close();
        blArray[88] = true;
        bufferedInputStream.close();
        blArray[89] = true;
    }

    @Nullable
    public static String getGalleryImagePath(Activity activity, Uri uri) {
        block6: {
            block5: {
                block4: {
                    boolean[] blArray = AttachmentManager.$jacocoInit();
                    if (activity != null) break block4;
                    blArray[90] = true;
                    break block5;
                }
                if (uri != null) break block6;
                blArray[91] = true;
            }
            blArray[92] = true;
            return null;
        }
        String[] stringArray = new String[]{"_data"};
        blArray[93] = true;
        Cursor cursor = activity.managedQuery(uri, stringArray, null, null, null);
        if (cursor != null) {
            blArray[94] = true;
            int n = cursor.getColumnIndexOrThrow("_data");
            blArray[95] = true;
            cursor.moveToFirst();
            blArray[96] = true;
            blArray[97] = true;
            return cursor.getString(n);
        }
        blArray[98] = true;
        return null;
    }

    @Nullable
    public static Uri getNewFileUri(Context context, Uri uri, String string2) {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        if (uri == null) {
            blArray[99] = true;
            return null;
        }
        String string3 = uri.getLastPathSegment().toLowerCase();
        blArray[100] = true;
        if (string2 == null) {
            blArray[101] = true;
        } else {
            blArray[102] = true;
            if (!SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(uri)) {
                blArray[103] = true;
            } else {
                string3 = string2;
                blArray[104] = true;
            }
        }
        File file = AttachmentManager.getAttachmentFile(context, string3);
        try {
            blArray[105] = true;
            AttachmentManager.copyFromUriIntoFile(context, uri, file);
            blArray[106] = true;
            if (!AttachmentManager.validateFileSize(uri, file)) {
                blArray[107] = true;
                return null;
            }
        }
        catch (IOException iOException) {
            blArray[108] = true;
            InstabugSDKLogger.e(AttachmentManager.class, iOException.getMessage(), iOException);
            blArray[109] = true;
            return null;
        }
        blArray[110] = true;
        return Uri.fromFile((File)file);
    }

    public static Uri getNewFileUri(Context context, Uri uri) {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        blArray[111] = true;
        return AttachmentManager.getNewFileUri(context, uri, null);
    }

    private static boolean validateFileSize(Uri uri, File file) {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        if (!SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(uri)) {
            blArray[112] = true;
        } else {
            blArray[113] = true;
            long l = file.length();
            double d2 = (double)l / 1048576.0;
            blArray[114] = true;
            InstabugSDKLogger.d(AttachmentManager.class, "External attachment file size is " + l + " bytes or " + d2 + " MBs");
            if (!(d2 > 50.0)) {
                blArray[115] = true;
            } else {
                blArray[116] = true;
                InstabugSDKLogger.i(AttachmentManager.class, "Attachment exceeds 50.0 MBs file size limit, ignoring attachment");
                blArray[117] = true;
                return false;
            }
        }
        blArray[118] = true;
        return true;
    }

    public static void saveBitmap(Bitmap bitmap, Context context, a a2) {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        File file = AttachmentManager.getAttachmentDirectory(context);
        blArray[119] = true;
        File file2 = new File(file, "bug_" + System.currentTimeMillis() + "_.jpg");
        blArray[120] = true;
        InstabugSDKLogger.v(AttachmentManager.class, "image path: " + file2.toString());
        try {
            blArray[121] = true;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            blArray[122] = true;
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bufferedOutputStream);
            blArray[123] = true;
            bufferedOutputStream.close();
            blArray[124] = true;
            Uri uri = Uri.fromFile((File)file2);
            if (uri != null) {
                blArray[125] = true;
                a2.a(uri);
                blArray[126] = true;
            } else {
                a2.a(new Throwable("Uri equal null"));
                blArray[127] = true;
            }
            blArray[128] = true;
        }
        catch (IOException iOException) {
            blArray[129] = true;
            a2.a(iOException);
            blArray[130] = true;
        }
        blArray[131] = true;
    }

    public static void saveBitmap(Bitmap bitmap, File file, a a2) {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        File file2 = new File(file, "frame_" + System.currentTimeMillis() + "_.jpg");
        blArray[132] = true;
        InstabugSDKLogger.v(AttachmentManager.class, "video frame path: " + file2.toString());
        try {
            Bitmap bitmap2;
            int n;
            blArray[133] = true;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            blArray[134] = true;
            if (bitmap.getWidth() > bitmap.getHeight()) {
                n = bitmap.getWidth();
                blArray[135] = true;
            } else {
                n = bitmap.getHeight();
                blArray[136] = true;
            }
            int n2 = n;
            if (n2 > 640) {
                blArray[137] = true;
                bitmap2 = AttachmentManager.resizeBitmap(bitmap, 640);
                blArray[138] = true;
                bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bufferedOutputStream);
                blArray[139] = true;
            } else {
                bitmap2 = AttachmentManager.resizeBitmap(bitmap, 320);
                blArray[140] = true;
                bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bufferedOutputStream);
                blArray[141] = true;
            }
            bufferedOutputStream.close();
            blArray[142] = true;
            bitmap2 = Uri.fromFile((File)file2);
            if (bitmap2 != null) {
                blArray[143] = true;
                a2.a((Uri)bitmap2);
                blArray[144] = true;
            } else {
                a2.a(new Throwable("Uri equal null"));
                blArray[145] = true;
            }
            blArray[146] = true;
        }
        catch (IOException iOException) {
            blArray[147] = true;
            a2.a(iOException);
            blArray[148] = true;
        }
        blArray[149] = true;
    }

    private static Bitmap resizeBitmap(Bitmap bitmap, int n) {
        boolean[] blArray = AttachmentManager.$jacocoInit();
        int n2 = bitmap.getWidth();
        blArray[150] = true;
        int n3 = bitmap.getHeight();
        float f2 = (float)n2 / (float)n3;
        if (f2 > 1.0f) {
            n2 = n;
            n3 = (int)((float)n2 / f2);
            blArray[151] = true;
        } else {
            n3 = n;
            n2 = (int)((float)n3 * f2);
            blArray[152] = true;
        }
        blArray[153] = true;
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n2, (int)n3, (boolean)false);
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-8374081541354711419L, (String)"com/instabug/library/internal/storage/AttachmentManager", (int)154);
        }
        return blArray;
    }

    public static interface a {
        public void a(Uri var1);

        public void a(Throwable var1);
    }
}

