/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.content.ContentValues;
import android.content.Context;
import com.instabug.library.internal.storage.cache.a.a;
import com.instabug.library.internal.storage.cache.a.c;
import org.json.JSONException;
import org.json.JSONObject;

public class NetworkLog {
    public static final String CONTENT_TYPE = "content-type";
    public static final String JSON = "application/json";
    public static final String XML_1 = "application/xml";
    public static final String XML_2 = "text/xml";
    public static final String HTML = "text/html";
    public static final String PLAIN_TEXT = "text/plain";
    public static final String LIMIT_ERROR = "{\"InstabugNetworkLog Error\":\"Response body exceeded limit\"}";
    private String date;
    private String url;
    private String request;
    private String response;
    private String method;
    private int responseCode;
    private String headers;

    public String getDate() {
        return this.date;
    }

    public void setDate(String string2) {
        this.date = string2;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string2) {
        this.url = string2;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String string2) {
        this.request = string2;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String string2) {
        this.response = string2;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string2) {
        this.method = string2;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int n) {
        this.responseCode = n;
    }

    public String getHeaders() {
        return this.headers;
    }

    public void setHeaders(String string2) {
        this.headers = string2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NetworkLog)) {
            return false;
        }
        NetworkLog networkLog = (NetworkLog)object;
        if (this.responseCode != networkLog.responseCode) {
            return false;
        }
        if (this.date != null ? !this.date.equals(networkLog.date) : networkLog.date != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(networkLog.url) : networkLog.url != null) {
            return false;
        }
        if (this.request != null ? !this.request.equals(networkLog.request) : networkLog.request != null) {
            return false;
        }
        if (this.response != null ? !this.response.equals(networkLog.response) : networkLog.response != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(networkLog.method) : networkLog.method != null) {
            return false;
        }
        return this.headers != null ? this.headers.equals(networkLog.headers) : networkLog.headers == null;
    }

    public int hashCode() {
        int n = this.date != null ? this.date.hashCode() : 0;
        n = 31 * n + (this.url != null ? this.url.hashCode() : 0);
        n = 31 * n + (this.request != null ? this.request.hashCode() : 0);
        n = 31 * n + (this.response != null ? this.response.hashCode() : 0);
        n = 31 * n + (this.method != null ? this.method.hashCode() : 0);
        n = 31 * n + this.responseCode;
        n = 31 * n + (this.headers != null ? this.headers.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "NetworkLog{date='" + this.date + '\'' + ", url='" + this.url + '\'' + ", request='" + this.request + '\'' + ", method='" + this.method + '\'' + ", responseCode=" + this.responseCode + ", headers='" + this.headers + '\'' + ", response='" + this.response + '\'' + '}';
    }

    @Deprecated
    public long insert(Context context) {
        return this.insert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert() {
        c c2 = a.a().b();
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put("url", this.getUrl());
            contentValues.put("request", this.getRequest());
            contentValues.put("method", this.getMethod());
            contentValues.put("response", this.getResponse());
            contentValues.put("status", "" + this.getResponseCode());
            contentValues.put("date", this.getDate());
            contentValues.put("headers", this.getHeaders());
            long l = c2.a("network_logs", null, contentValues);
            return l;
        }
        finally {
            c2.b();
        }
    }

    public String toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("date", (Object)this.getDate());
        jSONObject.put("method", (Object)this.getMethod());
        jSONObject.put("status", this.getResponseCode());
        jSONObject.put("url", (Object)this.getUrl());
        try {
            JSONObject jSONObject2 = new JSONObject(this.getHeaders());
            jSONObject.put("headers", (Object)jSONObject2);
            JSONObject jSONObject3 = new JSONObject(this.getRequest());
            jSONObject.put("request", (Object)jSONObject3);
            JSONObject jSONObject4 = new JSONObject(this.getResponse());
            jSONObject.put("response", (Object)jSONObject4);
        }
        catch (JSONException jSONException) {
            jSONObject.put("headers", (Object)this.getHeaders());
            jSONObject.put("response", (Object)this.getResponse());
            jSONObject.put("request", (Object)this.getRequest());
        }
        return jSONObject.toString();
    }

    public JSONObject toJsonObject() throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("date", (Object)this.getDate());
        jSONObject2.put("method", (Object)this.getMethod());
        jSONObject2.put("status", this.getResponseCode());
        jSONObject2.put("url", (Object)this.getUrl());
        try {
            jSONObject = new JSONObject(this.getHeaders());
            jSONObject2.put("headers", (Object)jSONObject);
        }
        catch (Exception exception) {
            jSONObject2.put("headers", (Object)this.getHeaders());
        }
        try {
            jSONObject = new JSONObject(this.getRequest());
            jSONObject2.put("request", (Object)jSONObject);
        }
        catch (Exception exception) {
            jSONObject2.put("request", (Object)this.getRequest());
        }
        try {
            jSONObject = new JSONObject(this.getResponse());
            jSONObject2.put("response", (Object)jSONObject);
        }
        catch (Exception exception) {
            jSONObject2.put("response", (Object)this.getResponse());
        }
        return jSONObject2;
    }

    public static NetworkLog fromJson(String string2) throws JSONException {
        JSONObject jSONObject = new JSONObject(string2);
        NetworkLog networkLog = new NetworkLog();
        networkLog.setHeaders(jSONObject.getString("headers"));
        networkLog.setResponse(jSONObject.getString("response"));
        networkLog.setMethod(jSONObject.getString("method"));
        networkLog.setDate(jSONObject.getString("date"));
        networkLog.setRequest(jSONObject.getString("request"));
        networkLog.setUrl(jSONObject.getString("url"));
        networkLog.setResponseCode(jSONObject.getInt("status"));
        return networkLog;
    }
}

