/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.instabug.library.Instabug;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.a;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapUtils {
    public static int getInMemoryByteSizeOfBitmap(Bitmap bitmap) {
        if (null == bitmap) {
            return 0;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            return bitmap.getAllocationByteCount();
        }
        if (Build.VERSION.SDK_INT >= 12) {
            return bitmap.getByteCount();
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    public static int getOnDiskByteSizeOfBitmap(Bitmap bitmap) {
        if (null == bitmap) {
            return 0;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray().length;
    }

    public static Bitmap getBitmapFromFilePath(@NonNull String string2) {
        Uri uri = Uri.fromFile((File)new File(string2));
        Bitmap bitmap = null;
        try {
            bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)Instabug.getApplicationContext().getContentResolver(), (Uri)uri);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            InstabugSDKLogger.e(BitmapUtils.class, "getBitmapFromFilePath returns null because of " + iOException.getMessage());
        }
        return bitmap;
    }

    public static void compressBitmapAndSave(@NonNull File file) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)options);
            int n = 900;
            int n2 = 1;
            while (options.outWidth / n2 / 2 >= 900 && options.outHeight / n2 / 2 >= 900) {
                n2 *= 2;
            }
            BitmapFactory.Options options2 = new BitmapFactory.Options();
            options2.inSampleSize = n2;
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)options2);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            bitmap.compress(BitmapUtils.getImageMimeType(file), 100, (OutputStream)fileOutputStream);
            bitmap.recycle();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            InstabugSDKLogger.e(BitmapUtils.class, "compressBitmapAndSave bitmap doesn't compressed correctly " + fileNotFoundException.getMessage());
        }
    }

    private static Bitmap.CompressFormat getImageMimeType(File file) {
        if (file.getName().contains("png")) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    public static void loadBitmap(String string2, ImageView imageView) {
        com.instabug.library.util.a a2 = new com.instabug.library.util.a(imageView);
        a2.execute(new String[]{string2});
    }

    public static void loadBitmap(String string2, ImageView imageView, float f2, float f3) {
        com.instabug.library.util.a a2 = new com.instabug.library.util.a(imageView, f2, f3);
        a2.execute(new String[]{string2});
    }

    public static void loadBitmap(String string2, ImageView imageView, a.a a2) {
        com.instabug.library.util.a a3 = new com.instabug.library.util.a(imageView, a2);
        a3.execute(new String[]{string2});
    }

    public static int calculateInSampleSize(BitmapFactory.Options options) {
        int n = options.outHeight;
        int n2 = options.outWidth;
        int n3 = 1;
        int n4 = 500;
        int n5 = 500;
        if (n > n4 || n2 > n5) {
            int n6 = n / 2;
            int n7 = n2 / 2;
            while (n6 / n3 >= n4 && n7 / n3 >= n5) {
                n3 *= 2;
            }
        }
        return n3;
    }

    public static Bitmap decodeSampledBitmapFromLocalPath(String string2) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
    }

    public static Bitmap resizeBitmap(Bitmap bitmap, float f2, float f3) {
        if (bitmap == null) {
            return null;
        }
        if (f2 == 0.0f && f3 == 0.0f) {
            return bitmap;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)((int)f2), (int)((int)f3), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bitmap.getWidth() < bitmap.getHeight() && f2 > f3) {
            return bitmap;
        }
        if (bitmap.getWidth() > bitmap.getHeight() && f2 < f3) {
            return bitmap;
        }
        Canvas canvas = new Canvas(bitmap2);
        Matrix matrix = new Matrix();
        if (bitmap.getWidth() < bitmap.getHeight()) {
            matrix.setScale(f2 / (float)bitmap.getWidth(), f3 / (float)bitmap.getHeight());
        } else {
            matrix.setScale(f3 / (float)bitmap.getHeight(), f2 / (float)bitmap.getWidth());
        }
        canvas.drawBitmap(bitmap, matrix, new Paint());
        return bitmap2;
    }

    private static Bitmap resizeBitmap(Bitmap bitmap, int n) {
        int n2;
        int n3 = bitmap.getWidth();
        float f2 = (float)n3 / (float)(n2 = bitmap.getHeight());
        if (f2 > 1.0f) {
            n3 = n;
            n2 = (int)((float)n3 / f2);
        } else {
            n2 = n;
            n3 = (int)((float)n2 * f2);
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n3, (int)n2, (boolean)false);
    }

    public static void saveBitmap(Bitmap bitmap, Context context, a a2) {
        File file = DiskUtils.getInstabugDirectory(context);
        File file2 = new File(file, "bug_" + System.currentTimeMillis() + "_.jpg");
        InstabugSDKLogger.v(AttachmentsUtility.class, "image path: " + file2.toString());
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bufferedOutputStream);
            bufferedOutputStream.close();
            Uri uri = Uri.fromFile((File)file2);
            if (uri != null) {
                a2.a(uri);
            } else {
                a2.a(new Throwable("Uri equal null"));
            }
        }
        catch (IOException iOException) {
            a2.a(iOException);
        }
    }

    public static void saveBitmap(Bitmap bitmap, Uri uri, Context context) {
        try {
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, context.getContentResolver().openOutputStream(Uri.fromFile((File)new File(uri.getPath()))));
        }
        catch (FileNotFoundException fileNotFoundException) {
            InstabugSDKLogger.e(BitmapUtils.class, fileNotFoundException.getMessage(), fileNotFoundException);
        }
    }

    public static void saveBitmap(Bitmap bitmap, File file, a a2) {
        File file2 = new File(file, "frame_" + System.currentTimeMillis() + "_.jpg");
        InstabugSDKLogger.v(AttachmentsUtility.class, "video frame path: " + file2.toString());
        try {
            Bitmap bitmap2;
            int n;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            int n2 = n = bitmap.getWidth() > bitmap.getHeight() ? bitmap.getWidth() : bitmap.getHeight();
            if (n > 640) {
                bitmap2 = BitmapUtils.resizeBitmap(bitmap, 640);
                bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bufferedOutputStream);
            } else {
                bitmap2 = BitmapUtils.resizeBitmap(bitmap, 320);
                bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bufferedOutputStream);
            }
            bufferedOutputStream.close();
            bitmap2 = Uri.fromFile((File)file2);
            if (bitmap2 != null) {
                a2.a((Uri)bitmap2);
            } else {
                a2.a(new Throwable("Uri equal null"));
            }
        }
        catch (IOException iOException) {
            a2.a(iOException);
        }
    }

    public static interface a {
        public void a(Uri var1);

        public void a(Throwable var1);
    }
}

