/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.RectF;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.widget.TextView;

public class InstabugAutoResizeTextView
extends TextView {
    private RectF mTextRect = new RectF();
    private RectF mAvailableSpaceRect;
    private SparseIntArray mTextCachedSizes;
    private TextPaint mPaint;
    private float mMaxTextSize;
    private float mSpacingMult = 1.0f;
    private float mSpacingAdd = 0.0f;
    private float mMinTextSize = 20.0f;
    private int mWidthLimit;
    private static final int NO_LINE_LIMIT = -1;
    private int mMaxLines;
    private boolean mEnableSizeCache = true;
    private boolean mInitializedDimens;
    private final SizeTester mSizeTester = new SizeTester(){

        @Override
        @TargetApi(value=16)
        public int onTestSize(int n, RectF rectF) {
            boolean bl;
            InstabugAutoResizeTextView.this.mPaint.setTextSize((float)n);
            String string2 = InstabugAutoResizeTextView.this.getText().toString();
            boolean bl2 = bl = InstabugAutoResizeTextView.this.getMaxLines() == 1;
            if (bl) {
                ((InstabugAutoResizeTextView)InstabugAutoResizeTextView.this).mTextRect.bottom = InstabugAutoResizeTextView.this.mPaint.getFontSpacing();
                ((InstabugAutoResizeTextView)InstabugAutoResizeTextView.this).mTextRect.right = InstabugAutoResizeTextView.this.mPaint.measureText(string2);
            } else {
                StaticLayout staticLayout = new StaticLayout((CharSequence)string2, InstabugAutoResizeTextView.this.mPaint, InstabugAutoResizeTextView.this.mWidthLimit, Layout.Alignment.ALIGN_NORMAL, InstabugAutoResizeTextView.this.mSpacingMult, InstabugAutoResizeTextView.this.mSpacingAdd, true);
                if (InstabugAutoResizeTextView.this.getMaxLines() != -1 && staticLayout.getLineCount() > InstabugAutoResizeTextView.this.getMaxLines()) {
                    return 1;
                }
                ((InstabugAutoResizeTextView)InstabugAutoResizeTextView.this).mTextRect.bottom = staticLayout.getHeight();
                int n2 = -1;
                for (int i = 0; i < staticLayout.getLineCount(); ++i) {
                    if (!((float)n2 < staticLayout.getLineWidth(i))) continue;
                    n2 = (int)staticLayout.getLineWidth(i);
                }
                ((InstabugAutoResizeTextView)InstabugAutoResizeTextView.this).mTextRect.right = n2;
            }
            InstabugAutoResizeTextView.this.mTextRect.offsetTo(0.0f, 0.0f);
            if (rectF.contains(InstabugAutoResizeTextView.this.mTextRect)) {
                return -1;
            }
            return 1;
        }
    };

    public InstabugAutoResizeTextView(Context context) {
        super(context);
        this.initialize();
    }

    public InstabugAutoResizeTextView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initialize();
    }

    public InstabugAutoResizeTextView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initialize();
    }

    private void initialize() {
        this.mPaint = new TextPaint((Paint)this.getPaint());
        this.mMaxTextSize = this.getTextSize();
        this.mAvailableSpaceRect = new RectF();
        this.mTextCachedSizes = new SparseIntArray();
        if (this.mMaxLines == 0) {
            this.mMaxLines = -1;
        }
    }

    public void setTextSize(float f2) {
        this.mMaxTextSize = f2;
        this.mTextCachedSizes.clear();
        this.adjustTextSize();
    }

    public void setMaxLines(int n) {
        super.setMaxLines(n);
        this.mMaxLines = n;
        this.adjustTextSize();
    }

    public int getMaxLines() {
        return this.mMaxLines;
    }

    public void setSingleLine() {
        super.setSingleLine();
        this.mMaxLines = 1;
        this.adjustTextSize();
    }

    public void setSingleLine(boolean bl) {
        super.setSingleLine(bl);
        this.mMaxLines = bl ? 1 : -1;
        this.adjustTextSize();
    }

    public void setLines(int n) {
        super.setLines(n);
        this.mMaxLines = n;
        this.adjustTextSize();
    }

    public void setTextSize(int n, float f2) {
        Context context = this.getContext();
        Resources resources = context == null ? Resources.getSystem() : context.getResources();
        this.mMaxTextSize = TypedValue.applyDimension((int)n, (float)f2, (DisplayMetrics)resources.getDisplayMetrics());
        this.mTextCachedSizes.clear();
        this.adjustTextSize();
    }

    public void setLineSpacing(float f2, float f3) {
        super.setLineSpacing(f2, f3);
        this.mSpacingMult = f3;
        this.mSpacingAdd = f2;
    }

    public void setMinTextSize(float f2) {
        this.mMinTextSize = f2;
        this.adjustTextSize();
    }

    private void adjustTextSize() {
        if (!this.mInitializedDimens) {
            return;
        }
        int n = (int)this.mMinTextSize;
        int n2 = this.getMeasuredHeight() - this.getCompoundPaddingBottom() - this.getCompoundPaddingTop();
        this.mWidthLimit = this.getMeasuredWidth() - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        this.mAvailableSpaceRect.right = this.mWidthLimit;
        this.mAvailableSpaceRect.bottom = n2;
        super.setTextSize(0, (float)this.efficientTextSizeSearch(n, (int)this.mMaxTextSize, this.mSizeTester, this.mAvailableSpaceRect));
    }

    public void enableSizeCache(boolean bl) {
        this.mEnableSizeCache = bl;
        this.mTextCachedSizes.clear();
        this.adjustTextSize();
    }

    private int efficientTextSizeSearch(int n, int n2, SizeTester sizeTester, RectF rectF) {
        if (!this.mEnableSizeCache) {
            return InstabugAutoResizeTextView.binarySearch(n, n2, sizeTester, rectF);
        }
        int n3 = this.getText().toString().length();
        int n4 = this.mTextCachedSizes.get(n3);
        if (n4 != 0) {
            return n4;
        }
        n4 = InstabugAutoResizeTextView.binarySearch(n, n2, sizeTester, rectF);
        this.mTextCachedSizes.put(n3, n4);
        return n4;
    }

    private static int binarySearch(int n, int n2, SizeTester sizeTester, RectF rectF) {
        int n3 = n;
        int n4 = n;
        int n5 = n2 - 1;
        int n6 = 0;
        while (n4 <= n5) {
            n6 = n4 + n5 >>> 1;
            int n7 = sizeTester.onTestSize(n6, rectF);
            if (n7 < 0) {
                n3 = n4;
                n4 = n6 + 1;
                continue;
            }
            if (n7 > 0) {
                n3 = n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return n3;
    }

    protected void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        super.onTextChanged(charSequence, n, n2, n3);
        this.adjustTextSize();
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.mInitializedDimens = true;
        this.mTextCachedSizes.clear();
        super.onSizeChanged(n, n2, n3, n4);
        if (n != n3 || n2 != n4) {
            this.adjustTextSize();
        }
    }

    private static interface SizeTester {
        public int onTestSize(int var1, RectF var2);
    }
}

