/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.messaging;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import com.instabug.library.g.d;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.messaging.a.a;
import com.instabug.library.messaging.cache.ChatsCacheManager;
import com.instabug.library.messaging.model.Chat;
import com.instabug.library.messaging.model.Message;
import com.instabug.library.model.Attachment;
import com.instabug.library.network.InstabugNetworkBasedBackgroundService;
import com.instabug.library.network.Request;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;

public class InstabugMessageUploaderService
extends InstabugNetworkBasedBackgroundService {
    @Override
    protected void runBackgroundTask() throws Exception {
        this.a();
        this.a(ChatsCacheManager.getOfflineMessages());
    }

    private void a() throws IOException, JSONException {
        List<Chat> list = ChatsCacheManager.getOfflineChats();
        InstabugSDKLogger.v((Object)this, "Found " + list.size() + " offline chats in cache");
        for (final Chat chat : ChatsCacheManager.getOfflineChats()) {
            if (chat.c().equals((Object)Chat.ChatState.READY_TO_BE_SENT) && chat.b().size() > 0) {
                InstabugSDKLogger.v((Object)this, "Uploading offline Chat: " + chat);
                a.a().a((Context)this, chat.f(), new Request.Callbacks<String, Throwable>(){

                    public void a(String string2) {
                        InstabugSDKLogger.v((Object)InstabugMessageUploaderService.this, "triggering chat " + chat.toString() + " triggeredChatId: " + string2);
                        String string3 = chat.a();
                        Intent intent = new Intent();
                        intent.setAction("local_chat_triggered");
                        intent.putExtra("old_chat_id", string3);
                        intent.putExtra("new_chat_id", string2);
                        LocalBroadcastManager.getInstance((Context)InstabugMessageUploaderService.this).sendBroadcast(intent);
                        InstabugSDKLogger.v((Object)InstabugMessageUploaderService.this, "Updating local chat with id: " + string3 + ", with synced chat with id: " + string2);
                        chat.a(string2);
                        chat.a(Chat.ChatState.LOGS_READY_TO_BE_UPLOADED);
                        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
                        if (inMemoryCache != null) {
                            inMemoryCache.delete(string3);
                            inMemoryCache.put(chat.a(), chat);
                        }
                        ChatsCacheManager.saveCacheToDisk();
                        InstabugMessageUploaderService.this.a(chat);
                    }

                    public void a(Throwable throwable) {
                        InstabugSDKLogger.e((Object)InstabugMessageUploaderService.this, "Something went wrong while triggering offline chat with id: " + chat.a(), throwable);
                    }

                    @Override
                    public /* synthetic */ void onFailed(Object object) {
                        this.a((Throwable)object);
                    }

                    @Override
                    public /* synthetic */ void onSucceeded(Object object) {
                        this.a((String)object);
                    }
                });
                continue;
            }
            if (!chat.c().equals((Object)Chat.ChatState.LOGS_READY_TO_BE_UPLOADED)) continue;
            InstabugSDKLogger.d((Object)this, "chat: " + chat.toString() + " already uploaded but has unsent logs, uploading now");
            this.a(chat);
        }
    }

    private void a(List<Message> list) throws IOException, JSONException {
        InstabugSDKLogger.v((Object)this, "Found " + list.size() + " offline messages in cache");
        for (int i2 = 0; i2 < list.size(); ++i2) {
            final Message message = list.get(i2);
            if (message.i() == Message.MessageState.READY_TO_BE_SENT) {
                InstabugSDKLogger.v((Object)this, "Uploading message: " + list.get(i2));
                a.a().a((Context)this, message, new Request.Callbacks<String, Throwable>(){

                    public void a(String string2) {
                        InstabugSDKLogger.v((Object)InstabugMessageUploaderService.this, "Send message response: " + string2);
                        if (string2 != null && !string2.equals("") && !string2.equals("null")) {
                            Chat chat = ChatsCacheManager.getChat(message.b());
                            if (chat != null) {
                                chat.b().remove(message);
                                message.a(string2);
                                if (message.j().size() == 0) {
                                    message.a(Message.MessageState.READY_TO_BE_SYNCED);
                                } else {
                                    message.a(Message.MessageState.SENT);
                                }
                                InstabugSDKLogger.v((Object)InstabugMessageUploaderService.this, "Caching sent message:" + message.toString());
                                chat.b().add(message);
                                InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
                                if (inMemoryCache != null) {
                                    inMemoryCache.put(chat.a(), chat);
                                }
                                ChatsCacheManager.saveCacheToDisk();
                                if (message.j().size() == 0) {
                                    InstabugMessageUploaderService.this.b();
                                } else {
                                    try {
                                        InstabugMessageUploaderService.this.a(message);
                                    }
                                    catch (FileNotFoundException | JSONException throwable) {
                                        InstabugSDKLogger.v((Object)InstabugMessageUploaderService.this, "Something went wrong while uploading messageattach attachments " + throwable.getMessage());
                                    }
                                }
                            } else {
                                InstabugSDKLogger.e(this, "Chat is null so can't remove message from it");
                            }
                        }
                    }

                    public void a(Throwable throwable) {
                        InstabugSDKLogger.e((Object)InstabugMessageUploaderService.this, "Something went wrong while uploading cached message", throwable);
                    }

                    @Override
                    public /* synthetic */ void onFailed(Object object) {
                        this.a((Throwable)object);
                    }

                    @Override
                    public /* synthetic */ void onSucceeded(Object object) {
                        this.a((String)object);
                    }
                });
                continue;
            }
            if (message.i() != Message.MessageState.SENT) continue;
            InstabugSDKLogger.v((Object)this, "Uploading message's attachments : " + list.get(i2));
            try {
                this.a(message);
                continue;
            }
            catch (FileNotFoundException | JSONException throwable) {
                InstabugSDKLogger.v((Object)this, "Something went wrong while uploading message attachments " + throwable.getMessage());
            }
        }
    }

    private void a(final Message message) throws JSONException, FileNotFoundException {
        InstabugSDKLogger.v((Object)this, "Found " + message.j().size() + " attachments related to message: " + message.c());
        a.a().b((Context)this, message, new Request.Callbacks<Boolean, Message>(){

            public void a(Boolean bl) {
                InstabugSDKLogger.v((Object)InstabugMessageUploaderService.this, "Message attachments uploaded successfully");
                Chat chat = ChatsCacheManager.getChat(message.b());
                if (chat != null) {
                    chat.b().remove(message);
                    message.a(Message.MessageState.READY_TO_BE_SYNCED);
                    for (int i2 = 0; i2 < message.j().size(); ++i2) {
                        message.j().get(i2).setAttachmentState(Attachment.AttachmentState.SYNCED);
                    }
                    InstabugSDKLogger.v((Object)InstabugMessageUploaderService.this, "Caching sent message:" + message.toString());
                    chat.b().add(message);
                    InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
                    if (inMemoryCache != null) {
                        inMemoryCache.put(chat.a(), chat);
                    }
                    ChatsCacheManager.saveCacheToDisk();
                    InstabugMessageUploaderService.this.b();
                } else {
                    InstabugSDKLogger.e(this, "Chat is null so can't remove message from it");
                }
            }

            public void a(Message message2) {
                InstabugSDKLogger.e((Object)InstabugMessageUploaderService.this, "Something went wrong while uploading message attachments, Message: " + message);
            }

            @Override
            public /* synthetic */ void onFailed(Object object) {
                this.a((Message)object);
            }

            @Override
            public /* synthetic */ void onSucceeded(Object object) {
                this.a((Boolean)object);
            }
        });
    }

    private void a(final Chat chat) {
        InstabugSDKLogger.d((Object)this, "Start uploading all logs related to this chat id = " + chat.a());
        a.a().a((Context)this, chat, new Request.Callbacks<Boolean, Chat>(){

            public void a(Boolean bl) {
                InstabugSDKLogger.d((Object)InstabugMessageUploaderService.this, "chat logs uploaded successfully, change its state");
                chat.a(Chat.ChatState.SENT);
                ChatsCacheManager.saveCacheToDisk();
            }

            public void a(Chat chat2) {
                InstabugSDKLogger.d((Object)InstabugMessageUploaderService.this, "Something went wrong while uploading chat logs");
            }

            @Override
            public /* synthetic */ void onFailed(Object object) {
                this.a((Chat)object);
            }

            @Override
            public /* synthetic */ void onSucceeded(Object object) {
                this.a((Boolean)object);
            }
        });
    }

    private void b() {
        Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
        InstabugSDKLogger.v((Object)this, "Updating last_contacted_at to " + calendar.getTime());
        d.a().b(calendar.getTime().getTime());
        d.a().e(calendar.getTime().getTime());
        Intent intent = new Intent();
        intent.setAction("User last contact at changed");
        intent.putExtra("last_contacted_at", calendar.getTime().getTime());
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }
}

