/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.content.Context;
import android.os.Environment;
import com.instabug.library.internal.storage.cache.AssetCache;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.model.a;
import com.instabug.library.network.Request;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import rx.Subscription;

public class AssetsCacheManager {
    private static final String ASSETS_MEMORY_CACHE_KEY = "assets_memory_cache";
    private static LinkedHashMap<String, a> currentDownloadingFiles = new LinkedHashMap();

    public static AssetCache getCache() {
        if (!CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets cache not found, create it");
            CacheManager.getInstance().addCache(new AssetCache(ASSETS_MEMORY_CACHE_KEY));
            InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets created successfully");
        }
        InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets cache found");
        return (AssetCache)CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY);
    }

    public static com.instabug.library.model.a createEmptyEntity(Context context, String string2, a.a a2) {
        File file = new File(AssetsCacheManager.getCashDirectory(context), String.valueOf(string2.hashCode()));
        return new com.instabug.library.model.a(String.valueOf(string2.hashCode()), a2, string2, file);
    }

    public static void getAssetEntity(Context context, com.instabug.library.model.a a2, b b2) {
        AssetCache assetCache = AssetsCacheManager.getCache();
        com.instabug.library.model.a a3 = assetCache != null ? (com.instabug.library.model.a)assetCache.get(a2.a()) : null;
        if (a3 != null) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "Get file from cache");
            b2.a(a3);
        } else if (AssetsCacheManager.isDownloading(a2.a())) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "File currently downloading, wait download to finish");
            AssetsCacheManager.waitDownloadToFinish(a2, b2);
        } else {
            InstabugSDKLogger.d(AssetsCacheManager.class, "File not exist download it");
            AssetsCacheManager.downloadAssetEntity(context, a2, b2);
        }
    }

    public static void downloadAssetEntity(Context context, final com.instabug.library.model.a a2, b b2) {
        a a3 = new a();
        a3.a(a2);
        List<b> list = a3.c();
        list.add(b2);
        a3.a(list);
        Subscription subscription = com.instabug.library.network.a.b.a().a(context, a2, new Request.Callbacks<com.instabug.library.model.a, Throwable>(){

            public void a(com.instabug.library.model.a a22) {
                AssetsCacheManager.addAssetEntity(a22);
                AssetsCacheManager.notifyDownloadFinishedSuccessfully(a22);
            }

            public void a(Throwable throwable) {
                InstabugSDKLogger.e(this, "downloading asset entity got error: ", throwable);
                AssetsCacheManager.notifyDownloadFailed(a2, throwable);
            }

            @Override
            public /* synthetic */ void onFailed(Object object) {
                this.a((Throwable)object);
            }

            @Override
            public /* synthetic */ void onSucceeded(Object object) {
                this.a((com.instabug.library.model.a)object);
            }
        });
        a3.a(subscription);
        currentDownloadingFiles.put(a3.a().a(), a3);
    }

    public static void addAssetEntity(com.instabug.library.model.a a2) {
        AssetCache assetCache = AssetsCacheManager.getCache();
        if (assetCache != null) {
            assetCache.put(a2.a(), a2);
        }
    }

    public static boolean isDownloading(String string2) {
        return currentDownloadingFiles.get(string2) != null;
    }

    public static void waitDownloadToFinish(com.instabug.library.model.a a2, b b2) {
        List<b> list = currentDownloadingFiles.get(a2.a()).c();
        list.add(b2);
        currentDownloadingFiles.get(a2.a()).a(list);
    }

    public static void notifyDownloadFinishedSuccessfully(com.instabug.library.model.a a2) {
        for (b b2 : currentDownloadingFiles.get(a2.a()).c()) {
            if (b2 == null) continue;
            b2.a(a2);
            currentDownloadingFiles.remove(a2.a());
        }
    }

    public static void notifyDownloadFailed(com.instabug.library.model.a a2, Throwable throwable) {
        for (b b2 : currentDownloadingFiles.get(a2.a()).c()) {
            if (b2 == null) continue;
            b2.a(throwable);
            currentDownloadingFiles.remove(a2.a());
        }
    }

    public static void stopRunningDownloads() {
        for (Map.Entry<String, a> entry : currentDownloadingFiles.entrySet()) {
            entry.getValue().b().unsubscribe();
        }
        currentDownloadingFiles.clear();
    }

    public static void clearRedundantFiles(Context context) {
        File[] fileArray = AssetsCacheManager.getCashDirectory(context).listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            file.delete();
        }
    }

    public static void cleanUpCache(Context context) {
        Cache cache;
        AssetsCacheManager.stopRunningDownloads();
        if (CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY) && (cache = CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY)) != null) {
            cache.invalidate();
        }
        AssetsCacheManager.clearRedundantFiles(context);
    }

    public static File getCashDirectory(Context context) {
        String string2;
        if (Environment.getExternalStorageState().equals("mounted") && context.getExternalCacheDir() != null) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "Media Mounted");
            string2 = context.getExternalCacheDir().getPath();
        } else {
            InstabugSDKLogger.d(AssetsCacheManager.class, "External storage not available, saving file to internal storage.");
            string2 = context.getCacheDir().getAbsolutePath();
        }
        File file = new File(string2 + "/instabug/assetCache");
        if (!file.exists()) {
            boolean bl = file.mkdirs();
            InstabugSDKLogger.d(AssetsCacheManager.class, "Is created: " + bl);
            File file2 = new File(file, ".nomedia");
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static interface b {
        public void a(com.instabug.library.model.a var1);

        public void a(Throwable var1);
    }

    public static class a {
        public com.instabug.library.model.a a;
        public Subscription b;
        public List<b> c = new ArrayList<b>();

        public a a(com.instabug.library.model.a a2) {
            this.a = a2;
            return this;
        }

        public a a(Subscription subscription) {
            this.b = subscription;
            return this;
        }

        public a a(List<b> list) {
            this.c = list;
            return this;
        }

        public com.instabug.library.model.a a() {
            return this.a;
        }

        public Subscription b() {
            return this.b;
        }

        public List<b> c() {
            return this.c;
        }
    }
}

