/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core.ui;

import android.os.Bundle;
import android.support.annotation.CallSuper;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.instabug.library.core.ui.BaseContract;
import com.instabug.library.util.InstabugSDKLogger;

public abstract class BaseFragment<P extends BaseContract.Presenter>
extends Fragment
implements BaseContract.View<Fragment> {
    protected P presenter;
    protected View rootView;

    public void onCreate(Bundle bundle) {
        InstabugSDKLogger.d(this, "onCreate called");
        super.onCreate(bundle);
    }

    @CallSuper
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        InstabugSDKLogger.d(this, "onCreateView called");
        this.rootView = layoutInflater.inflate(this.getLayout(), viewGroup, false);
        this.initViews(this.rootView, bundle);
        return this.rootView;
    }

    public void onViewCreated(View view, @Nullable Bundle bundle) {
        InstabugSDKLogger.d(this, "onViewCreated called");
        super.onViewCreated(view, bundle);
    }

    public void onStart() {
        InstabugSDKLogger.d(this, "onStart called");
        super.onStart();
    }

    public void onStop() {
        InstabugSDKLogger.d(this, "onStop called");
        super.onStop();
    }

    public void onDestroyView() {
        InstabugSDKLogger.d(this, "onDestroyView called");
        super.onDestroyView();
    }

    @Override
    public Fragment getViewContext() {
        return this;
    }

    @Override
    public void finishActivity() {
        this.getActivity().finish();
    }

    protected View findViewById(@IdRes int n2) {
        return this.rootView.findViewById(n2);
    }

    @LayoutRes
    protected abstract int getLayout();

    protected abstract void initViews(View var1, Bundle var2);
}

