/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.bugreporting.network;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import com.instabug.library.bugreporting.BugsCacheManager;
import com.instabug.library.bugreporting.model.Bug;
import com.instabug.library.g.d;
import com.instabug.library.model.Attachment;
import com.instabug.library.model.State;
import com.instabug.library.network.NetworkManager;
import com.instabug.library.network.Request;
import com.instabug.library.network.RequestResponse;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;
import rx.Observable;
import rx.Subscriber;

public class a {
    private static a a;
    private NetworkManager b = new NetworkManager();

    public static a a() {
        if (a == null) {
            a = new a();
        }
        return a;
    }

    private a() {
    }

    public void a(final Context context, Bug bug, final Request.Callbacks<String, Throwable> callbacks) throws JSONException, IOException {
        InstabugSDKLogger.d(this, "Reporting a bug with message: " + bug.d());
        Request request = this.b.buildRequest(context, Request.Endpoint.ReportBug, Request.RequestMethod.Post);
        ArrayList<State.StateItem> arrayList = bug.f().getStateItems();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            InstabugSDKLogger.d(this, "Bug State Key: " + arrayList.get(i2).getKey() + ", Bug State value: " + arrayList.get(i2).getValue());
            request.addRequestBodyParameter(bug.f().getStateItems().get(i2).getKey(), bug.f().getStateItems().get(i2).getValue());
        }
        request.addRequestBodyParameter("title", bug.d());
        request.addRequestBodyParameter("type", bug.c().toString());
        request.addRequestBodyParameter("attachments_count", bug.e().size());
        this.b.doRequest(request).subscribe((Subscriber)new Subscriber<RequestResponse>(){

            public void onStart() {
                InstabugSDKLogger.d((Object)this, "reportingBugRequest started");
            }

            public void onCompleted() {
                InstabugSDKLogger.d((Object)this, "reportingBugRequest completed");
            }

            public void onError(Throwable throwable) {
                InstabugSDKLogger.e((Object)this, "reportingBugRequest got error: " + throwable.getMessage(), throwable);
                callbacks.onFailed(throwable);
            }

            public void a(RequestResponse requestResponse) {
                InstabugSDKLogger.v((Object)this, "reportingBugRequest onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody());
                try {
                    callbacks.onSucceeded(new JSONObject((String)requestResponse.getResponseBody()).getString("id"));
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e((Object)this, "reportingBugRequest onNext got error: " + jSONException.getMessage(), jSONException);
                }
                if (requestResponse.getResponseCode() == 200) {
                    Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
                    InstabugSDKLogger.d((Object)this, "Updating last_contacted_at to " + calendar.getTime());
                    d.a().c(calendar.getTime().getTime());
                    d.a().b(calendar.getTime().getTime());
                    Intent intent = new Intent();
                    intent.setAction("User last contact at changed");
                    intent.putExtra("last_contacted_at", calendar.getTime().getTime());
                    LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
                }
            }

            public /* synthetic */ void onNext(Object object) {
                this.a((RequestResponse)object);
            }
        });
    }

    public void b(Context context, final Bug bug, final Request.Callbacks<Boolean, Bug> callbacks) throws JSONException, FileNotFoundException {
        InstabugSDKLogger.d(this, "Uploading Bug attachments");
        Observable[] observableArray = new Observable[bug.e().size()];
        for (int i2 = 0; i2 < observableArray.length; ++i2) {
            Attachment attachment = bug.e().get(i2);
            Request request = this.b.buildRequest(context, Request.Endpoint.AddBugAttachment, Request.RequestMethod.Post, NetworkManager.RequestType.MULTI_PART);
            request.setEndpoint(request.getEndpoint().replaceAll(":bug_token", bug.b()));
            request.addParameter("metadata[file_type]", (Object)attachment.getType());
            if (attachment.getType() == Attachment.Type.AUDIO) {
                request.addParameter("metadata[duration]", attachment.getDuration());
            }
            request.setFileToUpload(new Request.FileToUpload("file", attachment.getName(), attachment.getLocalPath(), attachment.getFileType()));
            observableArray[i2] = this.b.doRequest(request);
        }
        Observable.merge((Observable[])observableArray, (int)1).subscribe((Subscriber)new Subscriber<RequestResponse>(){

            public void onStart() {
                InstabugSDKLogger.d((Object)this, "uploadingBugAttachmentRequest started");
            }

            public void onCompleted() {
                InstabugSDKLogger.d((Object)this, "uploadingBugAttachmentRequest completed");
                if (bug.e().size() == 0) {
                    callbacks.onSucceeded(true);
                }
            }

            public void onError(Throwable throwable) {
                InstabugSDKLogger.e((Object)this, "uploadingBugAttachmentRequest got error: " + throwable.getMessage(), throwable);
                callbacks.onFailed(bug);
            }

            public void a(RequestResponse requestResponse) {
                InstabugSDKLogger.d((Object)this, "uploadingBugAttachmentRequest onNext, Response code: " + requestResponse.getResponseCode() + ", Response body: " + requestResponse.getResponseBody());
                File file = new File(bug.e().get(0).getLocalPath());
                file.delete();
                bug.e().remove(0);
                BugsCacheManager.addBug(bug);
                BugsCacheManager.saveCacheToDisk();
            }

            public /* synthetic */ void onNext(Object object) {
                this.a((RequestResponse)object);
            }
        });
    }

    public void c(Context context, final Bug bug, final Request.Callbacks<Boolean, Bug> callbacks) {
        try {
            Request request = this.b.buildRequest(context, Request.Endpoint.bugLogs, Request.RequestMethod.Post);
            request.setEndpoint(request.getEndpoint().replaceAll(":bug_token", bug.b()));
            ArrayList<State.StateItem> arrayList = bug.f().getLogsItems();
            for (State.StateItem stateItem : arrayList) {
                request.addRequestBodyParameter(stateItem.getKey(), stateItem.getValue());
            }
            if (bug.h() != null) {
                request.addRequestBodyParameter("view_hierarchy", bug.h());
            }
            this.b.doRequest(request).subscribe((Subscriber)new Subscriber<RequestResponse>(){

                public void onStart() {
                    InstabugSDKLogger.d((Object)this, "uploading bug logs started");
                }

                public void a(RequestResponse requestResponse) {
                    InstabugSDKLogger.v((Object)this, "uploading bug logs onNext, Response code: " + requestResponse.getResponseCode() + "Response body: " + requestResponse.getResponseBody());
                }

                public void onCompleted() {
                    InstabugSDKLogger.d((Object)this, "uploading bug logs completed");
                    callbacks.onSucceeded(true);
                }

                public void onError(Throwable throwable) {
                    InstabugSDKLogger.d((Object)this, "uploading bug logs got error: " + throwable.getMessage());
                    callbacks.onFailed(bug);
                }

                public /* synthetic */ void onNext(Object object) {
                    this.a((RequestResponse)object);
                }
            });
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.d(this, "uploading bug logs got Json error: " + jSONException.getMessage());
            callbacks.onFailed(bug);
        }
    }
}

