/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.bugreporting;

import android.content.Intent;
import android.support.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.bugreporting.model.Bug;
import com.instabug.library.bugreporting.network.InstabugBugsUploaderService;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.model.Attachment;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class BugsCacheManager {
    public static final String BUGS_DISK_CACHE_KEY = "bugs_disk_cache";
    public static final String BUGS_MEMORY_CACHE_KEY = "bugs_memory_cache";
    public static final String BUGS_DISK_CACHE_FILE_NAME = "/bugs.cache";

    public static InMemoryCache<String, Bug> getCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(BUGS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(BugsCacheManager.class, "In-memory Bugs cache not found, loading it from disk " + CacheManager.getInstance().getCache(BUGS_MEMORY_CACHE_KEY));
            CacheManager.getInstance().migrateCache(BUGS_DISK_CACHE_KEY, BUGS_MEMORY_CACHE_KEY, new CacheManager.KeyExtractor<String, Bug>(){

                public String a(Bug bug) {
                    return bug.a();
                }

                @Override
                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((Bug)object);
                }
            });
            Cache cache = CacheManager.getInstance().getCache(BUGS_MEMORY_CACHE_KEY);
            if (cache != null) {
                InstabugSDKLogger.d(BugsCacheManager.class, "In-memory Bugs cache restored from disk, " + cache.getValues().size() + " elements restored");
            }
        }
        InstabugSDKLogger.d(BugsCacheManager.class, "In-memory Bugs cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(BUGS_MEMORY_CACHE_KEY);
    }

    public static void saveCacheToDisk() {
        Cache cache = CacheManager.getInstance().getCache(BUGS_MEMORY_CACHE_KEY);
        Cache cache2 = CacheManager.getInstance().getCache(BUGS_DISK_CACHE_KEY);
        if (cache != null && cache2 != null) {
            CacheManager.getInstance().migrateCache(cache, cache2, new CacheManager.KeyExtractor<String, Bug>(){

                public String a(Bug bug) {
                    return bug.a();
                }

                @Override
                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((Bug)object);
                }
            });
        }
    }

    public static void addBug(Bug bug) {
        InMemoryCache<String, Bug> inMemoryCache = BugsCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.put(bug.a(), bug);
        }
        BugsCacheManager.sendBug(bug);
    }

    private static void sendBug(Bug bug) {
        if (bug.g() == Bug.BugState.READY_TO_BE_SENT) {
            InstabugSDKLogger.d(BugsCacheManager.class, "sending bug report to the server");
            Instabug.getApplicationContext().startService(new Intent(Instabug.getApplicationContext(), InstabugBugsUploaderService.class));
        }
    }

    public static void addHangingBug(Bug bug) {
        BugsCacheManager.cleanHangingBug();
        bug.a(Bug.BugState.IN_PROGRESS);
        InMemoryCache<String, Bug> inMemoryCache = BugsCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.put(bug.a(), bug);
        }
    }

    @Nullable
    public static Bug getHangingBug() {
        InMemoryCache<String, Bug> inMemoryCache = BugsCacheManager.getCache();
        if (inMemoryCache != null) {
            List<Bug> list = inMemoryCache.getValues();
            for (Bug bug : list) {
                if (!bug.g().equals((Object)Bug.BugState.IN_PROGRESS)) continue;
                return bug;
            }
        }
        return null;
    }

    public static void cleanHangingBug() {
        InstabugSDKLogger.d(BugsCacheManager.class, "cleanHangingBug");
        Bug bug = BugsCacheManager.getHangingBug();
        if (bug != null) {
            for (Attachment attachment : bug.e()) {
                File file = new File(attachment.getLocalPath());
                file.delete();
            }
            BugsCacheManager.deleteBug(bug.a());
        }
    }

    @Nullable
    public static Bug getBug(String string) {
        InMemoryCache<String, Bug> inMemoryCache = BugsCacheManager.getCache();
        if (inMemoryCache != null) {
            return inMemoryCache.get(string);
        }
        return null;
    }

    public static List<Bug> getBugs() {
        InMemoryCache<String, Bug> inMemoryCache = BugsCacheManager.getCache();
        if (inMemoryCache != null) {
            return inMemoryCache.getValues();
        }
        return new ArrayList<Bug>();
    }

    @Nullable
    public static Bug deleteBug(String string) {
        InMemoryCache<String, Bug> inMemoryCache = BugsCacheManager.getCache();
        if (inMemoryCache != null) {
            return inMemoryCache.delete(string);
        }
        return null;
    }
}

