/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.messaging.cache;

import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.messaging.model.c;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReadQueueCacheManager {
    public static final String READ_QUEUE_DISK_CACHE_FILE_NAME = "/read_queue.cache";
    public static final String READ_QUEUE_DISK_CACHE_KEY = "read_queue_disk_cache_key";
    public static final String READ_QUEUE_MEMORY_CACHE_KEY = "read_queue_memory_cache_key";
    private static ReadQueueCacheManager mReadQueueCacheManager;

    public static ReadQueueCacheManager getInstance() {
        if (mReadQueueCacheManager == null) {
            mReadQueueCacheManager = new ReadQueueCacheManager();
        }
        return mReadQueueCacheManager;
    }

    public static InMemoryCache<String, c> getCache() {
        if (!CacheManager.getInstance().cacheExists(READ_QUEUE_MEMORY_CACHE_KEY) || CacheManager.getInstance().getCache(READ_QUEUE_MEMORY_CACHE_KEY).getValues().size() > 0) {
            InstabugSDKLogger.d(ReadQueueCacheManager.class, "In-memory cache not found, loading it from disk " + CacheManager.getInstance().getCache(READ_QUEUE_MEMORY_CACHE_KEY));
            CacheManager.getInstance().migrateCache(READ_QUEUE_DISK_CACHE_KEY, READ_QUEUE_MEMORY_CACHE_KEY, new CacheManager.KeyExtractor<String, c>(){

                public String a(c c2) {
                    return c2.a();
                }

                @Override
                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((c)object);
                }
            });
            Cache cache = CacheManager.getInstance().getCache(READ_QUEUE_MEMORY_CACHE_KEY);
            if (cache != null) {
                InstabugSDKLogger.d(ReadQueueCacheManager.class, "In-memory cache restored from disk, " + cache.getValues().size() + " elements restored");
            }
        }
        InstabugSDKLogger.d(ReadQueueCacheManager.class, "In-memory cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(READ_QUEUE_MEMORY_CACHE_KEY);
    }

    public static void saveCacheToDisk() {
        Cache cache = CacheManager.getInstance().getCache(READ_QUEUE_MEMORY_CACHE_KEY);
        Cache cache2 = CacheManager.getInstance().getCache(READ_QUEUE_DISK_CACHE_KEY);
        if (cache != null && cache2 != null) {
            CacheManager.getInstance().migrateCache(cache, cache2, new CacheManager.KeyExtractor<String, c>(){

                public String a(c c2) {
                    return c2.a();
                }

                @Override
                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((c)object);
                }
            });
        }
    }

    public ReadQueueCacheManager() {
        InstabugSDKLogger.d(this, "Initializing ReadQueueCacheManager");
        InMemoryCache inMemoryCache = new InMemoryCache(READ_QUEUE_MEMORY_CACHE_KEY);
        CacheManager.getInstance().addCache(inMemoryCache);
    }

    public void add(c c2) {
        InstabugSDKLogger.v(this, "Adding message " + c2 + " to read queue in-memory cache");
        Cache cache = CacheManager.getInstance().getCache(READ_QUEUE_MEMORY_CACHE_KEY);
        if (cache != null) {
            cache.put(c2.a(), c2);
            InstabugSDKLogger.v(this, "Added message " + c2 + " to read queue in-memory cache " + cache.size());
        }
    }

    public JSONArray getReadMessagesArray() {
        JSONArray jSONArray = new JSONArray();
        List<c> list = this.getAll();
        for (c c2 : list) {
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("chat_number", (Object)c2.a());
                jSONObject.put("message_id", (Object)c2.c());
                jSONObject.put("read_at", c2.b());
                jSONArray.put((Object)jSONObject);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return jSONArray;
    }

    public List<c> getAll() {
        Cache cache = CacheManager.getInstance().getCache(READ_QUEUE_MEMORY_CACHE_KEY);
        if (cache != null) {
            return cache.getValues();
        }
        return new ArrayList<c>();
    }

    private void remove(String string2) {
        Cache cache = CacheManager.getInstance().getCache(READ_QUEUE_MEMORY_CACHE_KEY);
        if (cache != null) {
            cache.delete(string2);
        }
    }

    public void notify(List<c> list) {
        for (c c2 : this.getAll()) {
            for (c c3 : list) {
                if (c2.a() != c3.a() || c2.c() != c3.c()) continue;
                this.remove(c3.a());
            }
        }
    }
}

