/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.messaging;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugBaseFragment;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.InstabugState;
import com.instabug.library.R;
import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.util.ViewResourcesUtil;
import com.instabug.library.b;
import com.instabug.library.d;
import com.instabug.library.i;
import com.instabug.library.internal.storage.AttachmentManager;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.messaging.InstabugMessageUploaderService;
import com.instabug.library.messaging.a;
import com.instabug.library.messaging.cache.ChatsCacheManager;
import com.instabug.library.messaging.cache.ReadQueueCacheManager;
import com.instabug.library.messaging.e;
import com.instabug.library.messaging.f;
import com.instabug.library.messaging.g;
import com.instabug.library.messaging.model.Chat;
import com.instabug.library.messaging.model.Message;
import com.instabug.library.messaging.model.a;
import com.instabug.library.model.Attachment;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.j;
import com.instabug.library.util.m;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observer;
import rx.Subscription;
import rx.android.schedulers.AndroidSchedulers;
import rx.subjects.PublishSubject;

public class c
extends InstabugBaseFragment
implements View.OnClickListener,
b.a,
d.b,
com.instabug.library.internal.storage.cache.a<Chat>,
a.a,
e.a,
g {
    private String a;
    private Chat b;
    private ListView c;
    private e d;
    private EditText e;
    private a f;
    private com.instabug.library.messaging.a g = new com.instabug.library.messaging.a(this);
    private PublishSubject<String> h;
    private Subscription i;

    public static c a(String string2) {
        c c2 = new c();
        Bundle bundle = new Bundle();
        bundle.putString("chat_id", string2);
        c2.setArguments(bundle);
        return c2;
    }

    public static c a(Context context) {
        String string2 = ChatsCacheManager.addOfflineChat(context);
        c c2 = new c();
        Bundle bundle = new Bundle();
        bundle.putString("chat_id", string2);
        c2.setArguments(bundle);
        return c2;
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_lyt_conversation;
    }

    @Override
    protected String getTitle() {
        return this.getString(R.string.instabug_str_empty);
    }

    @Override
    protected void consumeNewInstanceSavedArguments() {
        this.a = this.getArguments().getString("chat_id");
    }

    @Override
    protected void restoreState(Bundle bundle) {
        this.a = bundle.getString("chat_id");
        this.b = ChatsCacheManager.getChat(this.a);
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle bundle) {
        ImageButton imageButton;
        super.onViewCreated(view, bundle);
        view.findViewById(R.id.instabug_btn_toolbar_right).setVisibility(8);
        view.findViewById(R.id.instabug_btn_toolbar_left).setOnClickListener((View.OnClickListener)this);
        if (ChatsCacheManager.getValidChats().size() > 0) {
            imageButton = (ImageButton)view.findViewById(R.id.instabug_btn_toolbar_left);
            imageButton.setImageResource(R.drawable.instabug_ic_back);
            imageButton.setRotation((float)this.getResources().getInteger(R.integer.instabug_icon_lang_rotation));
        } else {
            ((ImageButton)view.findViewById(R.id.instabug_btn_toolbar_left)).setImageResource(R.drawable.instabug_ic_close);
        }
        this.c = (ListView)view.findViewById(R.id.instabug_lst_messages);
        this.e = (EditText)view.findViewById(R.id.instabug_edit_text_new_message);
        this.e.setHint((CharSequence)j.a(InstabugCustomTextPlaceHolder.Key.CONVERSATION_TEXT_FIELD_HINT, this.getString(R.string.instabug_str_sending_message_hint)));
        if (com.instabug.library.g.d.a().q()) {
            imageButton = (ImageView)view.findViewById(R.id.instabug_btn_attach);
            com.instabug.library.util.c.a((ImageView)imageButton);
            imageButton.setOnClickListener((View.OnClickListener)this);
        } else {
            view.findViewById(R.id.instabug_btn_attach).setVisibility(8);
        }
        imageButton = (ImageView)view.findViewById(R.id.instabug_btn_send);
        Drawable drawable2 = com.instabug.library.util.c.a(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.instabug_ic_send));
        imageButton.setImageDrawable(drawable2);
        imageButton.setOnClickListener((View.OnClickListener)this);
        this.b = ChatsCacheManager.getChat(this.a);
        if (this.b == null) {
            return;
        }
        Collections.sort(this.b.b(), new Message.a());
        this.b((List<Message>)this.b.b());
        this.b.e();
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.put(this.b.a(), this.b);
        }
        this.setTitle(this.b.a((Context)this.getPreservedActivity()));
        this.d = new e(this.c(this.b.b()), (Context)this.getActivity(), this.c, this);
        this.c.setAdapter((ListAdapter)this.d);
        InstabugSDKLogger.d(this, "Chat: " + this.b.a() + " loaded from cache where number of " + "messages = " + this.b.b().size());
        this.j();
    }

    @Override
    private void b(List<Message> list) {
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            if (list.get(i2).m() || list.get(i2).d()) continue;
            InstabugSDKLogger.v(this, "Adding message " + list.get(i2) + " to read queue");
            com.instabug.library.messaging.model.c c2 = new com.instabug.library.messaging.model.c();
            c2.a(this.b.a());
            c2.b(list.get(i2).a());
            c2.a(InstabugDateFormatter.getCurrentUTCTimeStampInSeconds());
            ReadQueueCacheManager.getInstance().add(c2);
            break;
        }
    }

    @Override
    protected void saveState(Bundle bundle) {
        bundle.putString("chat_id", this.b.a());
    }

    @Override
    public void onPause() {
        super.onPause();
        CacheManager.getInstance().unSubscribe("chats_memory_cache", this);
        com.instabug.library.messaging.f.a().b(this);
        LocalBroadcastManager.getInstance((Context)this.getActivity()).unregisterReceiver((BroadcastReceiver)this.g);
    }

    @Override
    public void onResume() {
        super.onResume();
        CacheManager.getInstance().subscribe("chats_memory_cache", this);
        com.instabug.library.messaging.f.a().a(this);
        LocalBroadcastManager.getInstance((Context)this.getActivity()).registerReceiver((BroadcastReceiver)this.g, new IntentFilter("local_chat_triggered"));
    }

    @Override
    public void a(Chat chat) {
        InstabugSDKLogger.d(this, "Chat removed from chat cache, removed chat: " + chat + ", Time: " + System.currentTimeMillis());
        this.e(chat.a());
    }

    @Override
    public void b(Chat chat) {
        InstabugSDKLogger.d(this, "Chat added to chat cache, added chat: " + chat + ", Time: " + System.currentTimeMillis());
        this.e(chat.a());
    }

    @Override
    public void a(Chat chat, Chat chat2) {
        InstabugSDKLogger.d(this, "Message updated in chat: " + chat2 + ", Time: " + System.currentTimeMillis());
        this.e(chat2.a());
    }

    @Override
    public void e() {
        InstabugSDKLogger.d(this, "Chats cache was invalidated, Time: " + System.currentTimeMillis());
    }

    public void onClick(View view) {
        AnalyticsObserver.getInstance().catchUIClickingEvent(ViewResourcesUtil.getViewResourceIdAsString(this.getContext(), view.getId()), "instabug_chat_fragment");
        if (view.getId() == R.id.instabug_btn_send) {
            String string2 = this.e.getText().toString();
            if (TextUtils.isEmpty((CharSequence)string2.trim())) {
                return;
            }
            this.a(string2, this.b.a(), null, null, null);
            this.e.setText((CharSequence)"");
        } else if (view.getId() == R.id.instabug_btn_attach) {
            m.a((Activity)this.getActivity());
            this.k();
        } else if (view.getId() == R.id.instabug_btn_toolbar_left) {
            m.a((Activity)this.getActivity());
            this.getActivity().onBackPressed();
        }
    }

    private void a(String string2, String string3, Uri uri, Attachment.Type type, String string4) {
        Object object;
        Message message = new Message().b(string3).c(string2).b(InstabugDateFormatter.getCurrentUTCTimeStampInSeconds()).a(InstabugDateFormatter.getCurrentUTCTimeStampInSeconds()).a(Message.b.a).d(com.instabug.library.user.b.c()).a(Message.MessageState.READY_TO_BE_SENT);
        if (uri != null) {
            object = new Attachment();
            ((Attachment)object).setLocalPath(uri.getPath());
            ((Attachment)object).setType(type);
            ((Attachment)object).setDuration(string4);
            ((Attachment)object).setAttachmentState(Attachment.AttachmentState.OFFLINE);
            message.j().add((Attachment)object);
            InstabugSDKLogger.d(this, "Adding not sent message with attachment \"" + uri.getPath() + "\" to chat " + this.b + " cache " + ChatsCacheManager.getCache());
        }
        InstabugSDKLogger.d(this, "Adding not sent message with body \"" + message.c() + "\" to chat " + this.b + " cache " + ChatsCacheManager.getCache());
        this.b.b().add(message);
        object = ChatsCacheManager.getCache();
        if (object != null) {
            ((InMemoryCache)object).put(this.b.a(), this.b);
        }
        InstabugSDKLogger.d(this, "Sent message with body \"" + message.c() + "\" added to " + "Conversations last message cache");
        this.getActivity().getApplicationContext().startService(new Intent((Context)this.getActivity(), InstabugMessageUploaderService.class));
    }

    @Override
    public List<Message> a(@NonNull List<Message> list) {
        InstabugSDKLogger.d(this, list.size() + " messages received while in thread number" + " " + this.b.a());
        if (this.getPreservedActivity() != null) {
            for (Message message : list) {
                if (!message.b().equals(this.b.a())) continue;
                InstabugSDKLogger.d(this, "Found message that belongs to this thread " + this.b.a() + " deleting it");
                list.remove(message);
                InstabugSDKLogger.d(this, "Matching message removed from list, remaining messages count is " + list.size());
                com.instabug.library.i.a().b((Context)this.getPreservedActivity());
                this.b((List<Message>)this.b.b());
                this.b.e();
            }
            InstabugSDKLogger.d(this, "Matching messages done, remaining messages count is " + list.size());
            return list;
        }
        InstabugSDKLogger.d(this, "Couldn't find activity returning list as-is with size " + list.size());
        return list;
    }

    public void onDestroyView() {
        InMemoryCache<String, Chat> inMemoryCache;
        super.onDestroyView();
        if (this.d != null) {
            this.d.b();
        }
        if (this.i != null && !this.i.isUnsubscribed()) {
            this.i.unsubscribe();
        }
        if (this.b != null && this.b.b().size() == 0 && !this.b.a().equals(com.instabug.library.g.d.a().S()) && (inMemoryCache = ChatsCacheManager.getCache()) != null) {
            inMemoryCache.delete(this.b.a());
        }
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.f = (a)activity;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(activity.toString() + " must implement OnAttachmentClickListener");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.f = null;
    }

    private List<com.instabug.library.messaging.model.a> c(List<Message> list) {
        ArrayList<com.instabug.library.messaging.model.a> arrayList = new ArrayList<com.instabug.library.messaging.model.a>();
        for (Message message : list) {
            Object object;
            if (message.j() != null && message.j().size() > 0) {
                for (Attachment attachment : message.j()) {
                    com.instabug.library.messaging.model.a a2 = new com.instabug.library.messaging.model.a().a(message.c()).b(message.h()).a(message.f()).c(attachment.getUrl()).d(attachment.getLocalPath()).a(message.m());
                    InstabugSDKLogger.i(this, "type" + attachment.getFileType());
                    switch (attachment.getType()) {
                        case IMAGE: {
                            a2.a(a.b.b);
                            break;
                        }
                        case AUDIO: {
                            a2.a(a.b.c);
                            a2.a(a.a.a);
                            break;
                        }
                        case VIDEO: {
                            a2.a(a.b.d);
                            if (attachment.isVideoEncoded()) {
                                a2.b(true);
                                break;
                            }
                            a2.b(false);
                        }
                    }
                    arrayList.add(a2);
                }
            }
            if (!TextUtils.isEmpty((CharSequence)message.c())) {
                object = new com.instabug.library.messaging.model.a();
                ((com.instabug.library.messaging.model.a)object).a(message.c()).b(message.h()).a(message.f()).a(message.m()).a(a.b.a);
                if (message.k() != null && message.k().size() > 0) {
                    ((com.instabug.library.messaging.model.a)object).a(message.k());
                }
                arrayList.add((com.instabug.library.messaging.model.a)object);
                continue;
            }
            if (message.m() || message.k() == null || message.k().size() <= 0) continue;
            object = new com.instabug.library.messaging.model.a();
            ((com.instabug.library.messaging.model.a)object).a(message.c()).b(message.h()).a(message.f()).a(message.m()).a(a.b.a);
            ((com.instabug.library.messaging.model.a)object).a(message.k());
            arrayList.add((com.instabug.library.messaging.model.a)object);
        }
        return arrayList;
    }

    @Override
    public void b(String string2, String string3) {
        InstabugSDKLogger.v(this, "Chat triggered, old chat id: " + string2 + ", new chat id: " + string3);
        if (this.b.a().equals(string2)) {
            this.b.a(string3);
            this.a = string3;
            if (com.instabug.library.g.d.a().S() != null) {
                com.instabug.library.g.d.a().h(string3);
            }
        }
    }

    @Override
    public void b(String string2) {
        m.a((Activity)this.getActivity());
        FragmentTransaction fragmentTransaction = this.getActivity().getSupportFragmentManager().beginTransaction();
        fragmentTransaction.add(R.id.instabug_fragment_container, (Fragment)com.instabug.library.internal.video.c.a(string2), "video_player").addToBackStack("play video").commit();
    }

    @Override
    public void c(String string2) {
        if (this.f != null) {
            this.f.b(string2);
        }
    }

    @Override
    public void d(String string2) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)string2));
            this.startActivity(intent);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(this, "Unable to view this url " + string2 + "\n" + "Error message: " + exception.getMessage());
        }
    }

    @Override
    public void a() {
        this.l();
    }

    @Override
    public void b() {
        this.g();
    }

    @Override
    public void c() {
        this.n();
    }

    public void f() {
        if (ContextCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.RECORD_AUDIO") != 0) {
            this.requestPermissions(new String[]{"android.permission.RECORD_AUDIO"}, 2);
        } else {
            this.m();
        }
    }

    @Override
    public void d() {
        this.f();
    }

    @Override
    public void a(String string2, String string3) {
        this.a("", this.b.a(), Uri.fromFile((File)new File(string2)), Attachment.Type.AUDIO, string3);
    }

    private void g() {
        com.instabug.library.g.d.a().h(this.b.a());
        Instabug.setState(InstabugState.IMPORTING_IMAGE_FROM_GALLERY_FOR_CHAT);
        com.instabug.library.util.i.a(this, "android.permission.WRITE_EXTERNAL_STORAGE", 1, new Runnable(){

            @Override
            public void run() {
            }
        }, new Runnable(){

            @Override
            public void run() {
                InstabugSDKLogger.i(c.this, "Permission granted");
                c.this.h();
            }
        });
    }

    private void h() {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.putExtra("android.intent.extra.LOCAL_ONLY", true);
        intent.setType("image/*");
        this.startActivityForResult(intent, 161);
    }

    public void onRequestPermissionsResult(int n2, @NonNull String[] stringArray, @NonNull int[] nArray) {
        if (nArray[0] == 0) {
            switch (n2) {
                case 1: {
                    this.h();
                    break;
                }
                case 2: {
                    this.m();
                    break;
                }
                default: {
                    super.onRequestPermissionsResult(n2, stringArray, nArray);
                }
            }
        }
    }

    public void onActivityResult(int n2, int n3, Intent intent) {
        super.onActivityResult(n2, n3, intent);
        switch (n2) {
            case 161: {
                if (n3 != -1 || intent == null) break;
                Uri uri = intent.getData();
                String string2 = AttachmentManager.getGalleryImagePath((Activity)this.getActivity(), uri);
                if (string2 == null) {
                    string2 = intent.getData().getPath();
                }
                if (string2 == null) break;
                Uri uri2 = AttachmentManager.getNewFileUri((Context)this.getActivity(), Uri.fromFile((File)new File(string2)));
                FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
                fragmentTransaction.add(R.id.instabug_fragment_container, (Fragment)com.instabug.library.c.a(uri2, this.b.a((Context)this.getPreservedActivity()), 1), "annotation").addToBackStack("annotation").commit();
            }
        }
    }

    private void i() {
        this.d.a().clear();
        this.b = ChatsCacheManager.getChat(this.b.a());
        if (this.b != null) {
            Collections.sort(this.b.b(), new Message.a());
            this.d.a().addAll(this.c(this.b.b()));
            this.d.notifyDataSetChanged();
        }
    }

    private void j() {
        this.h = PublishSubject.create();
        this.i = this.h.debounce(300L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<String>(){

            public void onCompleted() {
            }

            public void onError(Throwable throwable) {
            }

            public void a(String string2) {
                c.this.i();
            }

            public /* synthetic */ void onNext(Object object) {
                this.a((String)object);
            }
        });
    }

    private void e(String string2) {
        if (string2.equals(this.b.a())) {
            this.h.onNext((Object)string2);
        }
    }

    private void k() {
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        fragmentTransaction.add(R.id.instabug_attachments_bottom_sheet_container, (Fragment)com.instabug.library.b.a(this), "sheet").addToBackStack("Add attachment").commit();
    }

    private void l() {
        com.instabug.library.g.d.a().h(this.b.a());
        Instabug.setState(InstabugState.TAKING_SCREENSHOT_FOR_CHAT);
        this.getActivity().finish();
    }

    private void m() {
        if (!com.instabug.library.g.d.a().Y()) {
            com.instabug.library.g.d.a().o(true);
            com.instabug.library.g.d.a().h(this.b.a());
            Instabug.setState(InstabugState.RECORDING_VIDEO_FOR_CHAT);
            this.getActivity().finish();
        } else {
            Toast.makeText((Context)this.getActivity(), (int)R.string.instabug_str_video_encoder_busy, (int)0).show();
        }
    }

    private void n() {
        File file = AttachmentManager.getAttachmentDirectory((Context)this.getActivity());
        File file2 = new File(file, "audioMessage_" + String.valueOf(System.currentTimeMillis()) + ".mp4");
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        fragmentTransaction.setCustomAnimations(R.anim.instabug_anim_bottom_sheet_enter, R.anim.instabug_anim_bottom_sheet_exit);
        fragmentTransaction.add(R.id.instabug_attachments_bottom_sheet_container, (Fragment)com.instabug.library.d.a(file2.getAbsolutePath(), this), "record_audio").addToBackStack("Record Audio").commit();
    }

    public static interface a {
        public void b(String var1);
    }
}

