/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.app.Activity;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.instabug.library.g.d;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class AttachmentManager {
    private static final double MAX_FILE_SIZE_IN_MB = 50.0;

    public static File getAttachmentDirectory(@NonNull Context context) {
        File file;
        String string2;
        if (context.getExternalFilesDir(null) != null && Environment.getExternalStorageState().equals("mounted")) {
            try {
                string2 = context.getExternalFilesDir(null).getAbsolutePath();
            }
            catch (NullPointerException nullPointerException) {
                string2 = AttachmentManager.getInternalStoragePath(context);
            }
        } else {
            string2 = AttachmentManager.getInternalStoragePath(context);
        }
        if (!(file = new File(string2 + "/instabug/")).exists()) {
            file.mkdirs();
            File file2 = new File(file, ".nomedia");
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File getVideoFile(Context context) {
        File file = AttachmentManager.getVideoRecordingVideosDirectory(context);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.getDefault());
        String string2 = "video-" + simpleDateFormat.format(new Date()) + ".mp4";
        return new File(file, string2);
    }

    public static File getVideoRecordingFramesDirectory(Context context) {
        File file = new File(AttachmentManager.getAttachmentDirectory(context) + "/frames/");
        if (!file.exists()) {
            file.mkdirs();
            File file2 = new File(file, ".nomedia");
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static File getVideoRecordingVideosDirectory(Context context) {
        File file = new File(AttachmentManager.getAttachmentDirectory(context) + "/videos/");
        if (!file.exists()) {
            file.mkdirs();
            File file2 = new File(file, ".nomedia");
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    private static String getInternalStoragePath(Context context) {
        InstabugSDKLogger.i(AttachmentManager.class, "External storage not available, saving file to internal storage.");
        return context.getFilesDir().getAbsolutePath();
    }

    private static void saveBytesToFile(byte[] byArray, File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        bufferedOutputStream.write(byArray);
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
    }

    private static File getAttachmentFile(Context context, String string2) {
        File file = AttachmentManager.getAttachmentDirectory(context);
        File file2 = new File(file, string2);
        if (file2.exists()) {
            file2 = new File(file, String.valueOf(System.currentTimeMillis()) + "_" + string2);
        }
        return file2;
    }

    public static Uri getUriFromBytes(Context context, byte[] byArray, String string2) {
        File file = AttachmentManager.getAttachmentFile(context, string2);
        try {
            AttachmentManager.saveBytesToFile(byArray, file);
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(AttachmentManager.class, iOException.getMessage(), iOException);
            return null;
        }
        return Uri.fromFile((File)file);
    }

    public static void copyFromUriIntoFile(Context context, Uri uri, File file) throws IOException {
        int n2;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(context.getContentResolver().openInputStream(uri));
        InstabugSDKLogger.d(AttachmentManager.class, "Target file path: " + file.getPath());
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(context.getContentResolver().openOutputStream(Uri.fromFile((File)file)));
        byte[] byArray = new byte[32768];
        while ((n2 = bufferedInputStream.read(byArray)) > 0) {
            bufferedOutputStream.write(byArray, 0, n2);
        }
        bufferedOutputStream.close();
        bufferedInputStream.close();
    }

    @Nullable
    public static String getGalleryImagePath(Activity activity, Uri uri) {
        String[] stringArray = new String[]{"_data"};
        Cursor cursor = activity.managedQuery(uri, stringArray, null, null, null);
        if (cursor != null) {
            int n2 = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            return cursor.getString(n2);
        }
        return null;
    }

    @Nullable
    public static Uri getNewFileUri(Context context, Uri uri, String string2) {
        if (uri == null) {
            return null;
        }
        String string3 = uri.getLastPathSegment().toLowerCase();
        if (string2 != null && d.a().l().containsKey(uri)) {
            string3 = string2;
        }
        File file = AttachmentManager.getAttachmentFile(context, string3);
        try {
            AttachmentManager.copyFromUriIntoFile(context, uri, file);
            if (!AttachmentManager.validateFileSize(uri, file)) {
                return null;
            }
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(AttachmentManager.class, iOException.getMessage(), iOException);
            return null;
        }
        return Uri.fromFile((File)file);
    }

    public static Uri getNewFileUri(Context context, Uri uri) {
        return AttachmentManager.getNewFileUri(context, uri, null);
    }

    private static boolean validateFileSize(Uri uri, File file) {
        if (d.a().l().containsKey(uri)) {
            long l2 = file.length();
            double d2 = (double)l2 / 1048576.0;
            InstabugSDKLogger.d(AttachmentManager.class, "External attachment file size is " + l2 + " bytes or " + d2 + " MBs");
            if (d2 > 50.0) {
                InstabugSDKLogger.i(AttachmentManager.class, "Attachment exceeds 50.0 MBs file size limit, ignoring attachment");
                return false;
            }
        }
        return true;
    }

    public static void saveBitmap(Bitmap bitmap, Context context, a a2) {
        File file = AttachmentManager.getAttachmentDirectory(context);
        File file2 = new File(file, "bug_" + System.currentTimeMillis() + "_" + ".jpg");
        InstabugSDKLogger.v(AttachmentManager.class, "image path: " + file2.toString());
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bufferedOutputStream);
            bufferedOutputStream.close();
            Uri uri = Uri.fromFile((File)file2);
            if (uri != null) {
                a2.a(uri);
            } else {
                a2.a(new Throwable("Uri equal null"));
            }
        }
        catch (IOException iOException) {
            a2.a(iOException);
        }
    }

    public static void saveBitmap(Bitmap bitmap, File file, a a2) {
        File file2 = new File(file, "frame_" + System.currentTimeMillis() + "_" + ".jpg");
        InstabugSDKLogger.v(AttachmentManager.class, "video frame path: " + file2.toString());
        try {
            Bitmap bitmap2;
            int n2;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            int n3 = n2 = bitmap.getWidth() > bitmap.getHeight() ? bitmap.getWidth() : bitmap.getHeight();
            if (n2 > 640) {
                bitmap2 = AttachmentManager.resizeBitmap(bitmap, 640);
                bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bufferedOutputStream);
            } else {
                bitmap2 = AttachmentManager.resizeBitmap(bitmap, 320);
                bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bufferedOutputStream);
            }
            bufferedOutputStream.close();
            bitmap2 = Uri.fromFile((File)file2);
            if (bitmap2 != null) {
                a2.a((Uri)bitmap2);
            } else {
                a2.a(new Throwable("Uri equal null"));
            }
        }
        catch (IOException iOException) {
            a2.a(iOException);
        }
    }

    private static Bitmap resizeBitmap(Bitmap bitmap, int n2) {
        int n3;
        int n4 = bitmap.getWidth();
        float f2 = (float)n4 / (float)(n3 = bitmap.getHeight());
        if (f2 > 1.0f) {
            n4 = n2;
            n3 = (int)((float)n4 / f2);
        } else {
            n3 = n2;
            n4 = (int)((float)n3 * f2);
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n4, (int)n3, (boolean)false);
    }

    public static interface a {
        public void a(Uri var1);

        public void a(Throwable var1);
    }
}

