/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import com.instabug.library.internal.storage.cache.a;
import java.util.ArrayList;
import java.util.List;

public abstract class Cache<K, V> {
    private final List<a<V>> listeners;
    private String id;
    private int appVersion = -1;

    public Cache(String string2) {
        this(string2, 1);
    }

    protected Cache(String string2, int n2) {
        this.id = string2;
        this.appVersion = n2;
        this.listeners = new ArrayList<a<V>>();
    }

    public abstract V get(K var1);

    public abstract V put(K var1, V var2);

    public abstract V delete(K var1);

    public abstract List<V> getValues();

    public abstract long size();

    public void notifyItemRemoved(V v) {
        for (a<V> a2 : this.listeners) {
            a2.a(v);
        }
    }

    public void notifyItemAdded(V v) {
        for (a<V> a2 : this.listeners) {
            a2.b(v);
        }
    }

    public void notifyItemUpdated(V v, V v2) {
        for (a<V> a2 : this.listeners) {
            a2.a(v, v2);
        }
    }

    public void notifyCacheInvalidated() {
        for (a<V> a2 : this.listeners) {
            a2.e();
        }
    }

    public abstract void invalidate();

    public String getId() {
        return this.id;
    }

    public int getAppVersion() {
        return this.appVersion;
    }

    public boolean addOnCacheChangedListener(a<V> a2) {
        return this.listeners.add(a2);
    }

    public boolean removeOnCacheChangedListener(a<V> a2) {
        return this.listeners.remove(a2);
    }
}

