/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.logging;

import com.instabug.library.analytics.AnalyticsObserver;
import com.instabug.library.analytics.a.a;
import com.instabug.library.model.NetworkLog;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import org.json.JSONException;
import org.json.JSONObject;

public class InstabugNetworkLog {
    private NetworkLog networkLog = new NetworkLog();

    public void log(String string2, String string3, String string4, String string5, int n2) throws IOException {
        AnalyticsObserver.getInstance().catchApiUsage(new a.a().a("connection").a(HttpURLConnection.class), new a.a().a("requestBody").a(String.class), new a.a().a("responseBody").a(String.class));
        this.networkLog.setResponseCode(n2);
        this.networkLog.setDate(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds() + "");
        this.networkLog.setMethod(string3);
        this.networkLog.setUrl(string2);
        try {
            this.networkLog.setRequest(this.validateBody(string4));
            this.networkLog.setResponse(this.validateBody(string5));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InstabugSDKLogger.d(this, "Content-type is not allowed to be logged");
            this.networkLog = null;
            return;
        }
        this.insert();
        InstabugSDKLogger.d(this, "adding network log: " + this.networkLog.toString());
    }

    @Deprecated
    public void Log(HttpURLConnection httpURLConnection, String string2, String string3) throws IOException {
        AnalyticsObserver.getInstance().catchApiUsage(new a.a().a("connection").a(HttpURLConnection.class), new a.a().a("requestBody").a(String.class), new a.a().a("responseBody").a(String.class));
        this.networkLog.setResponseCode(httpURLConnection.getResponseCode());
        this.networkLog.setDate(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds() + "");
        this.networkLog.setMethod(httpURLConnection.getRequestMethod());
        this.networkLog.setUrl(httpURLConnection.getURL().toString());
        try {
            this.addHeaders(httpURLConnection);
            this.networkLog.setRequest(this.validateBody(string2));
            this.networkLog.setResponse(this.validateBody(string3));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InstabugSDKLogger.d(this, "Content-type is not allowed to be logged");
            this.networkLog = null;
            return;
        }
        this.insert();
        InstabugSDKLogger.d(this, "adding network log: " + this.networkLog.toString());
    }

    private String validateBody(String string2) {
        if (string2 == null) {
            return null;
        }
        long l2 = 1000000L;
        if ((long)string2.getBytes(Charset.forName("UTF-8")).length > l2) {
            return "{\"InstabugNetworkLog Error\":\"Response body exceeded limit\"}";
        }
        return string2;
    }

    public void log(HttpURLConnection httpURLConnection, String string2, String string3) throws IOException {
        AnalyticsObserver.getInstance().catchApiUsage(new a.a().a("connection").a(HttpURLConnection.class), new a.a().a("requestBody").a(String.class), new a.a().a("responseBody").a(String.class));
        this.networkLog.setResponseCode(httpURLConnection.getResponseCode());
        this.networkLog.setDate(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds() + "");
        this.networkLog.setMethod(httpURLConnection.getRequestMethod());
        this.networkLog.setUrl(httpURLConnection.getURL().toString());
        try {
            this.addHeaders(httpURLConnection);
            this.networkLog.setRequest(this.validateBody(string2));
            this.networkLog.setResponse(this.validateBody(string3));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InstabugSDKLogger.d(this, "Content-type is not allowed to be logged");
            this.networkLog = null;
            return;
        }
        this.insert();
        InstabugSDKLogger.d(this, "adding network log: " + this.networkLog.toString());
    }

    private void addHeaders(HttpURLConnection httpURLConnection) throws JSONException, IllegalArgumentException {
        JSONObject jSONObject = new JSONObject();
        for (String string2 : httpURLConnection.getHeaderFields().keySet()) {
            if (string2 == null) continue;
            for (String string3 : httpURLConnection.getHeaderFields().get(string2)) {
                if (!(!string2.equalsIgnoreCase("content-type") || string3.contains("application/json") || string3.contains("application/xml") || string3.contains("text/xml") || string3.contains("text/html") || string3.contains("text/plain"))) {
                    throw new IllegalArgumentException();
                }
                jSONObject.put(string2, (Object)string3);
            }
        }
        this.networkLog.setHeaders(jSONObject.toString());
    }

    private void insert() {
        this.networkLog.insert();
    }
}

