/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import com.instabug.library.internal.storage.cache.Cache;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class InMemoryCache<K, V>
extends Cache<K, V> {
    private final LinkedHashMap<K, V> map = new LinkedHashMap();

    public InMemoryCache(String string2) {
        this(string2, 1);
    }

    public InMemoryCache(String string2, int n2) {
        super(string2, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K k2) {
        LinkedHashMap<K, V> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            return this.map.get(k2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k2, V v) {
        if (v != null && k2 != null) {
            V v2;
            LinkedHashMap<K, V> linkedHashMap = this.map;
            synchronized (linkedHashMap) {
                v2 = this.map.put(k2, v);
            }
            if (v2 == null) {
                this.notifyItemAdded(v);
                return v;
            }
            this.notifyItemUpdated(v2, v);
            return v2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V delete(K k2) {
        Object v;
        LinkedHashMap<K, V> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            v = this.map.remove(k2);
        }
        if (v != null) {
            this.notifyItemRemoved(v);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() {
        LinkedHashMap<K, V> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        LinkedHashMap<K, V> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            this.map.clear();
        }
        this.notifyCacheInvalidated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> getValues() {
        ArrayList<V> arrayList = new ArrayList<V>();
        LinkedHashMap<K, V> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            for (K k2 : this.map.keySet()) {
                arrayList.add(this.get(k2));
            }
        }
        return arrayList;
    }
}

