/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.instabug.library.Instabug;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.util.BitmapWorkerTask;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapUtils {
    public static int getInMemoryByteSizeOfBitmap(Bitmap bitmap) {
        if (null == bitmap) {
            return 0;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            return bitmap.getAllocationByteCount();
        }
        if (Build.VERSION.SDK_INT >= 12) {
            return bitmap.getByteCount();
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    public static int getOnDiskByteSizeOfBitmap(Bitmap bitmap) {
        if (null == bitmap) {
            return 0;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray().length;
    }

    public static Bitmap getBitmapFromFilePath(@NonNull String string2) {
        Uri uri = Uri.fromFile((File)new File(string2));
        return BitmapUtils.getBitmapFromUri(uri);
    }

    public static Bitmap getBitmapFromUri(@NonNull Uri uri) {
        Bitmap bitmap = null;
        try {
            bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)Instabug.getApplicationContext().getContentResolver(), (Uri)uri);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            InstabugSDKLogger.e(BitmapUtils.class, "getBitmapFromFilePath returns null because of " + iOException.getMessage());
        }
        return bitmap;
    }

    public static void compressBitmapAndSave(final @NonNull File file) {
        PoolProvider.postBitmapTask(new Runnable(){

            @Override
            public void run() {
                try {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = true;
                    BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)options);
                    int n = 900;
                    int n2 = 1;
                    while (options.outWidth / n2 / 2 >= 900 && options.outHeight / n2 / 2 >= 900) {
                        n2 *= 2;
                    }
                    BitmapFactory.Options options2 = new BitmapFactory.Options();
                    options2.inSampleSize = n2;
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)options2);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    bitmap.compress(BitmapUtils.getImageMimeType(file), 100, (OutputStream)fileOutputStream);
                    bitmap.recycle();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    InstabugSDKLogger.e(BitmapUtils.class, "compressBitmapAndSave bitmap doesn't compressed correctly " + fileNotFoundException.getMessage());
                }
            }
        });
    }

    private static Bitmap.CompressFormat getImageMimeType(File file) {
        if (file.getName().contains("png")) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    public static void loadBitmap(String string2, ImageView imageView) {
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask(imageView);
        bitmapWorkerTask.execute(new String[]{string2});
    }

    public static void loadBitmap(String string2, ImageView imageView, float f2, float f3) {
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask(imageView, f2, f3);
        bitmapWorkerTask.execute(new String[]{string2});
    }

    public static void loadBitmap(String string2, ImageView imageView, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask(imageView, onImageLoadedListener);
        bitmapWorkerTask.execute(new String[]{string2});
    }

    public static int calculateInSampleSize(BitmapFactory.Options options) {
        int n = options.outHeight;
        int n2 = options.outWidth;
        int n3 = 1;
        int n4 = 500;
        int n5 = 500;
        if (n > n4 || n2 > n5) {
            int n6 = n / 2;
            int n7 = n2 / 2;
            while (n6 / n3 >= n4 && n7 / n3 >= n5) {
                n3 *= 2;
            }
        }
        return n3;
    }

    public static Bitmap decodeSampledBitmapFromLocalPath(String string2) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
    }

    public static Bitmap resizeBitmap(Bitmap bitmap, float f2, float f3) {
        if (bitmap == null) {
            return null;
        }
        if (f2 == 0.0f && f3 == 0.0f) {
            return bitmap;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)((int)f2), (int)((int)f3), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bitmap.getWidth() < bitmap.getHeight() && f2 > f3) {
            return bitmap;
        }
        if (bitmap.getWidth() > bitmap.getHeight() && f2 < f3) {
            return bitmap;
        }
        Canvas canvas = new Canvas(bitmap2);
        Matrix matrix = new Matrix();
        if (bitmap.getWidth() < bitmap.getHeight()) {
            matrix.setScale(f2 / (float)bitmap.getWidth(), f3 / (float)bitmap.getHeight());
        } else {
            matrix.setScale(f3 / (float)bitmap.getHeight(), f2 / (float)bitmap.getWidth());
        }
        canvas.drawBitmap(bitmap, matrix, new Paint());
        return bitmap2;
    }

    private static Bitmap resizeBitmap(Bitmap bitmap, int n) {
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        if (n3 > n2) {
            n3 = n;
            n2 = n / 2;
        } else {
            n2 = n;
            n3 = n / 2;
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n2, (int)n3, (boolean)false);
    }

    public static void saveBitmapAsPNG(final Bitmap bitmap, final int n, final File file, final String string2, final OnSaveBitmapCallback onSaveBitmapCallback) {
        PoolProvider.postBitmapTask(new Runnable(){

            @Override
            public void run() {
                File file2 = new File(file, string2 + "_" + System.currentTimeMillis() + ".png");
                InstabugSDKLogger.v(AttachmentsUtility.class, "image path: " + file2.toString());
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    bitmap.compress(Bitmap.CompressFormat.PNG, n, (OutputStream)bufferedOutputStream);
                    bufferedOutputStream.close();
                    Uri uri = Uri.fromFile((File)file2);
                    if (uri != null) {
                        onSaveBitmapCallback.onSuccess(uri);
                    } else {
                        onSaveBitmapCallback.onError(new Throwable("Uri equal null"));
                    }
                }
                catch (IOException iOException) {
                    onSaveBitmapCallback.onError(iOException);
                }
            }
        });
    }

    public static void saveBitmap(final Bitmap bitmap, final Context context, final OnSaveBitmapCallback onSaveBitmapCallback) {
        PoolProvider.postBitmapTask(new Runnable(){

            @Override
            public void run() {
                File file = DiskUtils.getInstabugDirectory(context);
                File file2 = new File(file, "bug_" + System.currentTimeMillis() + "_.jpg");
                InstabugSDKLogger.v(AttachmentsUtility.class, "image path: " + file2.toString());
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bufferedOutputStream);
                    bufferedOutputStream.close();
                    final Uri uri = Uri.fromFile((File)file2);
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (uri != null) {
                                onSaveBitmapCallback.onSuccess(uri);
                            } else {
                                onSaveBitmapCallback.onError(new Throwable("Uri equal null"));
                            }
                        }
                    });
                }
                catch (IOException iOException) {
                    onSaveBitmapCallback.onError(iOException);
                }
            }
        });
    }

    public static void saveBitmap(final Bitmap bitmap, final Uri uri, final Context context, final OnSaveBitmapCallback onSaveBitmapCallback) {
        PoolProvider.postBitmapTask(new Runnable(){

            @Override
            public void run() {
                try {
                    final boolean bl = bitmap.compress(Bitmap.CompressFormat.PNG, 100, context.getContentResolver().openOutputStream(Uri.fromFile((File)new File(uri.getPath()))));
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (bl && onSaveBitmapCallback != null) {
                                onSaveBitmapCallback.onSuccess(null);
                            }
                        }
                    });
                }
                catch (FileNotFoundException fileNotFoundException) {
                    InstabugSDKLogger.e(BitmapUtils.class, fileNotFoundException.getMessage(), fileNotFoundException);
                }
            }
        });
    }

    public static void saveBitmap(final Bitmap bitmap, final File file, final OnSaveBitmapCallback onSaveBitmapCallback) {
        PoolProvider.postBitmapTask(new Runnable(){

            @Override
            public void run() {
                File file2 = new File(file, "frame_" + System.currentTimeMillis() + "_.jpg");
                InstabugSDKLogger.v(AttachmentsUtility.class, "video frame path: " + file2.toString());
                try {
                    Bitmap bitmap2;
                    int n;
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    int n2 = n = bitmap.getWidth() > bitmap.getHeight() ? bitmap.getWidth() : bitmap.getHeight();
                    if (n > 640) {
                        bitmap2 = BitmapUtils.resizeBitmap(bitmap, 640);
                        bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bufferedOutputStream);
                    } else {
                        bitmap2 = BitmapUtils.resizeBitmap(bitmap, 320);
                        bitmap2.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bufferedOutputStream);
                    }
                    bufferedOutputStream.close();
                    bitmap2 = Uri.fromFile((File)file2);
                    if (bitmap2 != null) {
                        onSaveBitmapCallback.onSuccess((Uri)bitmap2);
                    } else {
                        onSaveBitmapCallback.onError(new Throwable("Uri equal null"));
                    }
                }
                catch (IOException iOException) {
                    onSaveBitmapCallback.onError(iOException);
                }
            }
        });
    }

    public static interface OnSaveBitmapCallback {
        public void onSuccess(Uri var1);

        public void onError(Throwable var1);
    }
}

