/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.net.Uri;
import com.instabug.library.Instabug;
import com.instabug.library.core.eventbus.ScreenRecordingEventBus;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.video.ScreenRecordEvent;
import com.instabug.library.internal.video.VideoProcessingService;
import com.instabug.library.internal.video.c;
import com.instabug.library.invocation.a.c;
import com.instabug.library.invocation.b;
import com.instabug.library.model.Session;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.File;

public class InternalScreenRecordHelper
implements c.b,
c.c {
    private static InternalScreenRecordHelper INSTANCE;
    private com.instabug.library.invocation.a.c fab;
    private Disposable sessionDisposable;

    private InternalScreenRecordHelper() {
    }

    public static InternalScreenRecordHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InternalScreenRecordHelper();
        }
        return INSTANCE;
    }

    public void init() {
        b.c().h();
        if (this.fab == null) {
            this.fab = new com.instabug.library.invocation.a.c(this);
            this.fab.a();
        } else {
            this.fab.a();
        }
    }

    @Override
    public void start() {
        this.subscribeToSessionEvents();
        this.startSnapping();
    }

    public void pause() {
    }

    @Override
    public void stop() {
        c.a().b();
        this.release();
    }

    public void release() {
        if (this.fab != null) {
            this.fab.b();
        }
        this.unsubscribeFromSessionEvents();
        b.c().i();
        com.instabug.library.util.b.b(Instabug.getApplicationContext());
    }

    public void cancel() {
        if (this.isRecording()) {
            c.a().c();
            com.instabug.library.util.b.b(Instabug.getApplicationContext());
            if (this.fab != null) {
                this.fab.b();
                this.fab.a();
            }
            InstabugSDKLogger.d(this, "Cancelling screen recording");
            SettingsManager.getInstance().setVideoProcessorBusy(false);
        }
    }

    private void startSnapping() {
        if (!c.a().d()) {
            c.a().a(this);
        }
    }

    public boolean isRecording() {
        return c.a().d() || SettingsManager.getInstance().isVideoProcessorBusy();
    }

    private void subscribeToSessionEvents() {
        if (this.sessionDisposable == null || this.sessionDisposable.isDisposed()) {
            this.sessionDisposable = SessionStateEventBus.getInstance().subscribe(new Consumer<Session.SessionState>(){

                public void a(Session.SessionState sessionState) {
                    if (sessionState == Session.SessionState.FINISH) {
                        InternalScreenRecordHelper.this.cancel();
                    }
                }

                public /* synthetic */ void accept(Object object) throws Exception {
                    this.a((Session.SessionState)((Object)object));
                }
            });
        }
    }

    private void unsubscribeFromSessionEvents() {
        if (!this.sessionDisposable.isDisposed()) {
            this.sessionDisposable.dispose();
        }
    }

    @Override
    public void onFramesCapturingFinished(String string2) {
        File file = AttachmentsUtility.getVideoFile(Instabug.getApplicationContext());
        Uri uri = Uri.fromFile((File)file);
        ScreenRecordingEventBus.getInstance().post(new ScreenRecordEvent(0, uri));
        InstabugSDKLogger.i(this, "Encoding...");
        VideoProcessingService.a(Instabug.getApplicationContext(), file.getPath(), string2);
    }
}

