/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class InMemoryCache<K, V>
extends Cache<K, V> {
    private final LinkedHashMap<K, V> map = new LinkedHashMap();

    public InMemoryCache(String string2) {
        this(string2, 1);
    }

    public InMemoryCache(String string2, int n) {
        super(string2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public V get(K k) {
        LinkedHashMap<K, V> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            return this.map.get(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K k, V v) {
        if (v != null && k != null) {
            V v2;
            LinkedHashMap<K, V> linkedHashMap = this.map;
            synchronized (linkedHashMap) {
                v2 = this.map.put(k, v);
            }
            if (v2 == null) {
                this.notifyItemAdded(v);
                return v;
            }
            this.notifyItemUpdated(v2, v);
            return v2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V delete(K k) {
        Object v;
        LinkedHashMap<K, V> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            v = this.map.remove(k);
        }
        if (v != null) {
            this.notifyItemRemoved(v);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() {
        LinkedHashMap<K, V> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        LinkedHashMap<K, V> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            this.map.clear();
        }
        this.notifyCacheInvalidated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> getValues() {
        ArrayList<V> arrayList = new ArrayList<V>();
        LinkedHashMap<K, V> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            for (K k : this.map.keySet()) {
                arrayList.add(this.get(k));
            }
        }
        return arrayList;
    }
}

