/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.view;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.widget.TextView;
import com.instabug.library.R;
import com.instabug.library.settings.a;
import com.instabug.library.view.ViewUtils;

public class IconView
extends TextView {
    public static final int ANDROID_ACTIONBAR_ICON_SIZE_DP = 24;
    public static final int ANDROID_ACTIONBAR_ICON_SIZE_PADDING_DP = 1;
    private Typeface font;
    @ColorInt
    int backgroundColor = 0;
    float strokeWidth = 0.0f;
    @ColorInt
    int strokeColor = 0;
    Paint paint;

    public IconView(Context context) {
        this(context, null);
    }

    public IconView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public IconView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        int n2;
        if (this.isInEditMode()) {
            return;
        }
        if (this.font == null) {
            this.font = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"font_icons.ttf");
        }
        this.setTypeface(this.font);
        context = context.obtainStyledAttributes(attributeSet, R.styleable.IconView);
        if (!context.hasValue(R.styleable.IconView_android_textSize)) {
            this.setActionBarSize();
        }
        if (!context.hasValue(R.styleable.IconView_android_padding)) {
            this.setActionBarPadding();
        }
        if (!context.hasValue(R.styleable.IconView_android_textColor)) {
            this.setTextColor(a.b().j());
        }
        if ((n2 = context.getInt(R.styleable.IconView_instabug_icon, -1)) != -1) {
            this.setText(com.instabug.library.core.eventbus.coreeventbus.a.a(n2));
        }
        context.recycle();
        this.paint = new Paint(1);
    }

    private void setActionBarSize() {
        this.setTextSize(1, 24.0f);
    }

    private void setActionBarPadding() {
        int n = ViewUtils.convertDpToPx(this.getContext(), 1.0f);
        this.setPadding(n);
    }

    public void setPadding(int n) {
        this.setPadding(n, n, n, n);
    }

    public void setBackgroundColor(@ColorInt int n) {
        this.backgroundColor = n;
        this.invalidate();
    }

    public void setStrokeWidth(float f2) {
        this.strokeWidth = f2;
        this.invalidate();
    }

    public void setStrokeColor(@ColorInt int n) {
        this.strokeColor = n;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        this.paint.setColor(this.backgroundColor);
        this.paint.setStyle(Paint.Style.FILL);
        canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, Math.min((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f) - this.strokeWidth / 2.0f, this.paint);
        this.paint.setStrokeWidth(this.strokeWidth);
        this.paint.setColor(this.strokeColor);
        this.paint.setStyle(Paint.Style.STROKE);
        canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, Math.min((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f) - this.strokeWidth / 2.0f, this.paint);
        super.onDraw(canvas);
    }
}

