/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.instabug.library.e;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.internal.device.a;
import com.instabug.library.tracking.d;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DeviceStateProvider {
    public static String getDevice() {
        return InstabugDeviceProperties.getDeviceType();
    }

    public static boolean isDeviceRooted() {
        try {
            if (a.a()) {
                return true;
            }
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("DeviceStateProvider", "Something went wrong while checking if device is rooted or not " + exception.getMessage());
            return false;
        }
        return false;
    }

    public static String getOS() {
        return "OS Level " + Build.VERSION.SDK_INT;
    }

    public static String getCarrier(Context context) {
        try {
            return ((TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get Carrier", exception);
            return "Unknown";
        }
    }

    public static String getAppPackageName(Context context) {
        return InstabugDeviceProperties.getPackageName(context);
    }

    public static String getAppVersion(Context context) {
        return InstabugDeviceProperties.getAppVersion(context);
    }

    public static int getBatteryLevel(Context context) {
        try {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            context = context.registerReceiver(null, intentFilter);
            assert (context != null);
            int n = context.getIntExtra("level", -1);
            int n2 = context.getIntExtra("scale", -1);
            float f2 = (float)n / (float)n2;
            return (int)(f2 * 100.0f);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get battery level", exception);
            return -1;
        }
    }

    public static String getBatteryState(Context context) {
        try {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            context = context.registerReceiver(null, intentFilter);
            assert (context != null);
            int n = context.getIntExtra("status", -1);
            n = n == 2 || n == 5 ? 1 : 0;
            int n2 = context.getIntExtra("plugged", -1);
            boolean bl = n2 == 2;
            int n3 = n2 = n2 == 1 ? 1 : 0;
            if (n != 0) {
                return "Charging" + (n2 != 0 ? " through AC Charger" : (bl ? " through USB cable" : ""));
            }
            return "Unplugged";
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get battery state", exception);
            return "Unknown";
        }
    }

    public static boolean getWifiState(Context context) {
        try {
            context = (ConnectivityManager)context.getSystemService("connectivity");
            context = context.getNetworkInfo(1);
            return context.isConnected();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while get wifi state", exception);
            return false;
        }
    }

    public static String getWifiSSID(Context context) {
        if (DeviceStateProvider.getWifiState(context)) {
            try {
                context = (WifiManager)context.getSystemService("wifi");
                context = context.getConnectionInfo();
                return context.getSSID();
            }
            catch (SecurityException securityException) {
                InstabugSDKLogger.e("DeviceStateProvider", "Could not read wifi SSID. To enable please add the following line in your AndroidManifest.xml <uses-permission android:name=\"android.permission.ACCESS_WIFI_STATE\"/>");
                return "Connected";
            }
        }
        return "Not Connected";
    }

    public static long getFreeMemory(Context context) {
        context = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        context.getMemoryInfo(memoryInfo);
        return memoryInfo.availMem / 0x100000L;
    }

    public static long getUsedMemory(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        long l = DeviceStateProvider.calculateTotalMemory(context) - memoryInfo.availMem;
        return l / 0x100000L;
    }

    public static long getTotalMemory(Context context) {
        long l = DeviceStateProvider.calculateTotalMemory(context);
        if (l == 0L) {
            InstabugSDKLogger.e("DeviceStateProvider", "Got error while calculate total memory");
            return -1L;
        }
        return l / 0x100000L;
    }

    private static long calculateTotalMemory(Context context) {
        if (Build.VERSION.SDK_INT >= 16) {
            return DeviceStateProvider.calculateTotalMemoryApi16(context);
        }
        return DeviceStateProvider.calculateTotalMemoryPreApi16();
    }

    @TargetApi(value=16)
    private static long calculateTotalMemoryApi16(Context context) {
        context = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        context.getMemoryInfo(memoryInfo);
        return memoryInfo.totalMem;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long calculateTotalMemoryPreApi16() {
        Object object = null;
        object = new RandomAccessFile("/proc/meminfo", "r");
        Object object2 = ((RandomAccessFile)object).readLine();
        object2 = ((String)object2).split(":");
        object2 = object2[1].trim();
        object2 = ((String)object2).substring(0, ((String)object2).length() - 3).trim();
        ((RandomAccessFile)object).close();
        long l = Long.parseLong((String)object2) << 10;
        try {
            ((RandomAccessFile)object).close();
            return l;
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
        }
        return l;
        catch (IOException iOException) {
            IOException iOException2;
            try {
                iOException2 = iOException;
                iOException.printStackTrace();
                if (object == null) return 0L;
            }
            catch (Throwable throwable) {
                if (object == null) throw throwable;
                try {
                    ((RandomAccessFile)object).close();
                    throw throwable;
                }
                catch (IOException iOException3) {
                    object = iOException3;
                    iOException3.printStackTrace();
                }
                throw throwable;
            }
            try {
                ((RandomAccessFile)object).close();
                return 0L;
            }
            catch (IOException iOException4) {
                iOException2 = iOException4;
                iOException4.printStackTrace();
            }
            return 0L;
        }
    }

    public static long getFreeStorage() {
        if (DeviceStateProvider.externalMemoryAvailable()) {
            long l = Environment.getExternalStorageDirectory().getUsableSpace();
            return l / 0x100000L;
        }
        InstabugSDKLogger.e("DeviceStateProvider", "Got error while calculate free storage");
        return -1L;
    }

    public static long getUsedStorage() {
        if (DeviceStateProvider.externalMemoryAvailable()) {
            long l = Environment.getExternalStorageDirectory().getTotalSpace() - Environment.getExternalStorageDirectory().getFreeSpace();
            return l / 0x100000L;
        }
        InstabugSDKLogger.e("DeviceStateProvider", "Got error while calculate used storage");
        return -1L;
    }

    public static long getTotalStorage() {
        if (DeviceStateProvider.externalMemoryAvailable()) {
            long l = Environment.getExternalStorageDirectory().getTotalSpace();
            return (int)(l / 0x100000L);
        }
        InstabugSDKLogger.e("DeviceStateProvider", "Got error while calculate total storage");
        return -1L;
    }

    private static boolean externalMemoryAvailable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getScreenDensity(Context context) {
        context = DeviceStateProvider.getDisplayMetrics(context);
        if (context.densityDpi < 160) {
            return "ldpi";
        }
        if (context.densityDpi < 240) {
            return "mdpi";
        }
        if (context.densityDpi < 320) {
            return "hdpi";
        }
        if (context.densityDpi < 480) {
            return "xhdpi";
        }
        if (context.densityDpi < 640) {
            return "xxhdpi";
        }
        return "xxxhdpi";
    }

    public static String getScreenSize(Context context) {
        context = DeviceStateProvider.getDisplayMetrics(context);
        return String.format("%sx%s", context.widthPixels, context.heightPixels);
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        context = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        context.getMetrics(displayMetrics);
        if (Build.VERSION.SDK_INT >= 17) {
            context.getRealMetrics(displayMetrics);
        }
        return displayMetrics;
    }

    public static String getScreenOrientation(Context context) {
        if (context.getResources().getConfiguration().orientation == 2) {
            return "landscape";
        }
        return "portrait";
    }

    public static String getCurrentView() {
        return d.a().b();
    }

    public static String getSdkVersion() {
        return "4.14.0";
    }

    public static String getLocale(Context context) {
        return context.getResources().getConfiguration().locale.toString();
    }

    public static long getActiveSessionDuration() {
        return e.a().b();
    }
}

