/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.widget.ImageView;
import com.instabug.library.util.BitmapUtils;
import java.lang.ref.WeakReference;

public class BitmapWorkerTask
extends AsyncTask<String, Void, Bitmap> {
    private final WeakReference<ImageView> imageViewReference;
    private float targetWidth;
    private float targetHeight;
    private boolean resize;
    private OnImageLoadedListener onImageLoadedListener;

    public BitmapWorkerTask(ImageView imageView) {
        this.imageViewReference = new WeakReference<ImageView>(imageView);
    }

    public BitmapWorkerTask(ImageView imageView, float f2, float f3) {
        this(imageView);
        this.targetWidth = f2;
        this.targetHeight = f3;
        this.resize = true;
    }

    public BitmapWorkerTask(ImageView imageView, OnImageLoadedListener onImageLoadedListener) {
        this(imageView);
        this.onImageLoadedListener = onImageLoadedListener;
    }

    public BitmapWorkerTask(ImageView imageView, float f2, float f3, OnImageLoadedListener onImageLoadedListener) {
        this(imageView, f2, f3);
        this.onImageLoadedListener = onImageLoadedListener;
    }

    protected Bitmap doInBackground(String ... bitmap) {
        bitmap = BitmapUtils.decodeSampledBitmapFromLocalPath(bitmap[0]);
        if (this.resize) {
            bitmap = BitmapUtils.resizeBitmap(bitmap, this.targetWidth, this.targetHeight);
        }
        return bitmap;
    }

    protected void onPostExecute(Bitmap bitmap) {
        ImageView imageView;
        if (bitmap != null && (imageView = (ImageView)this.imageViewReference.get()) != null) {
            imageView.setImageBitmap(bitmap);
            if (this.onImageLoadedListener != null) {
                this.onImageLoadedListener.onImageLoaded();
            }
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded();
    }
}

